/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;

public class MethodTypeFlow
extends TypeFlow<AnalysisMethod> {
    protected final PointsToAnalysisMethod method;
    private volatile MethodFlowsGraph flowsGraph;
    private InvokeTypeFlow parsingReason;
    private int returnedParameterIndex;

    public MethodTypeFlow(PointsToAnalysisMethod method) {
        super(method, null);
        this.method = method;
    }

    public PointsToAnalysisMethod getMethod() {
        return this.method;
    }

    public MethodFlowsGraph getOrCreateMethodFlowsGraph(PointsToAnalysis bb, InvokeTypeFlow reason) {
        this.ensureFlowsGraphCreated(bb, reason);
        return this.flowsGraph;
    }

    public MethodFlowsGraph getMethodFlowsGraph() {
        assert (this.flowsGraph != null);
        return this.flowsGraph;
    }

    public boolean flowsGraphCreated() {
        return this.flowsGraph != null;
    }

    protected void ensureFlowsGraphCreated(PointsToAnalysis bb, InvokeTypeFlow reason) {
        if (this.flowsGraph == null) {
            this.createFlowsGraph(bb, reason);
        }
    }

    private synchronized void createFlowsGraph(PointsToAnalysis bb, InvokeTypeFlow reason) {
        if (this.flowsGraph == null) {
            this.parsingReason = reason;
            try {
                MethodTypeFlowBuilder builder = bb.createMethodTypeFlowBuilder(bb, this.method);
                builder.apply();
                this.returnedParameterIndex = MethodTypeFlow.computeReturnedParameterIndex(builder.graph);
                bb.numParsedGraphs.incrementAndGet();
                this.flowsGraph = builder.flowsGraph;
                this.initFlowsGraph(bb);
            }
            catch (Throwable t) {
                throw AnalysisError.parsingError(this.method, t);
            }
        }
    }

    private static int computeReturnedParameterIndex(StructuredGraph graph) {
        if (graph == null) {
            return -1;
        }
        ValueNode singleReturnedValue = null;
        for (ReturnNode returnNode : graph.getNodes(ReturnNode.TYPE)) {
            if (singleReturnedValue == null) {
                singleReturnedValue = returnNode.result();
                continue;
            }
            if (returnNode.result() == singleReturnedValue) continue;
            return -1;
        }
        if (singleReturnedValue instanceof ParameterNode) {
            return ((ParameterNode)singleReturnedValue).index();
        }
        return -1;
    }

    protected void initFlowsGraph(PointsToAnalysis bb) {
        this.flowsGraph.init(bb);
    }

    public Collection<MethodFlowsGraph> getFlows() {
        return this.flowsGraph == null ? Collections.emptyList() : List.of(this.flowsGraph);
    }

    public EconomicMap<Object, InvokeTypeFlow> getInvokes() {
        return this.flowsGraph == null ? EconomicMap.emptyMap() : this.flowsGraph.getInvokes();
    }

    public Iterable<TypeFlow<?>> getParameters() {
        return this.flowsGraph == null ? Collections.emptyList() : Arrays.asList(this.flowsGraph.getParameters());
    }

    public boolean isSaturated(PointsToAnalysis bb, TypeFlow<?> originalTypeFlow) {
        return originalTypeFlow.isSaturated();
    }

    public TypeState foldTypeFlow(PointsToAnalysis bb, TypeFlow<?> originalTypeFlow) {
        return originalTypeFlow == null ? null : originalTypeFlow.getState();
    }

    public int getReturnedParameterIndex() {
        return this.returnedParameterIndex;
    }

    public StackTraceElement[] getParsingContext() {
        ArrayList<StackTraceElement> parsingContext = new ArrayList<StackTraceElement>();
        InvokeTypeFlow invokeFlow = this.parsingReason;
        int maxSize = 100;
        while (invokeFlow != null && parsingContext.size() < maxSize) {
            parsingContext.add(((BytecodePosition)invokeFlow.getSource()).getMethod().asStackTraceElement(((BytecodePosition)invokeFlow.getSource()).getBCI()));
            invokeFlow = ((PointsToAnalysisMethod)((BytecodePosition)invokeFlow.getSource()).getMethod()).getTypeFlow().parsingReason;
        }
        return parsingContext.toArray(new StackTraceElement[0]);
    }

    @Override
    public void update(PointsToAnalysis bb) {
        JVMCIError.shouldNotReachHere();
    }

    @Override
    public String toString() {
        return "MethodTypeFlow<" + this.method + ">";
    }
}

