/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.util.GraalAccess;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.ResolvedJavaField;

public interface OriginalFieldProvider {
    public static Field getJavaField(ResolvedJavaField field) {
        if (field instanceof OriginalFieldProvider) {
            return ((OriginalFieldProvider)field).getJavaField();
        }
        try {
            return GraalAccess.getOriginalSnippetReflection().originalField(field);
        }
        catch (LinkageError ignored) {
            return null;
        }
    }

    public Field getJavaField();
}

