/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.util.GraalAccess;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public interface OriginalMethodProvider {
    public static Executable getJavaMethod(ResolvedJavaMethod method) {
        if (method instanceof OriginalMethodProvider) {
            return ((OriginalMethodProvider)method).getJavaMethod();
        }
        try {
            return GraalAccess.getOriginalSnippetReflection().originalMethod(method);
        }
        catch (LinkageError ignored) {
            return null;
        }
    }

    public Executable getJavaMethod();
}

