/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractSpecialInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.DefaultInvokeTypeFlowUtil;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.LightImmutableCollection;
import com.oracle.svm.common.meta.MultiMethod;
import java.util.Collection;
import jdk.vm.ci.code.BytecodePosition;

final class DefaultSpecialInvokeTypeFlow
extends AbstractSpecialInvokeTypeFlow {
    private volatile boolean calleesLinked = false;

    DefaultSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        assert (!this.isSaturated());
        this.initializeCallees(bb);
        LightImmutableCollection.forEach(this, CALLEES_ACCESSOR, callee -> {
            MethodFlowsGraphInfo calleeFlows = callee.getTypeFlow().getOrCreateMethodFlowsGraphInfo(bb, this);
            assert (calleeFlows.getMethod().equals(callee));
            if (!this.calleesLinked) {
                this.linkCallee(bb, false, calleeFlows);
            }
            TypeState invokeState = this.filterReceiverState(bb, this.getReceiver().getState());
            this.updateReceiver(bb, calleeFlows, invokeState);
        });
        this.calleesLinked = true;
    }

    @Override
    protected Collection<MethodFlowsGraph> getAllCalleesFlows(PointsToAnalysis bb) {
        return DefaultInvokeTypeFlowUtil.getAllCalleesFlows(this);
    }
}

