/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.results;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.results.AbstractAnalysisResultsBuilder;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.graal.pointsto.results.StrengthenGraphsCounters;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.util.ImageBuildStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.java.ClassIsAssignableFromNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LimitedValueProxy;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;

public abstract class StrengthenGraphs
extends AbstractAnalysisResultsBuilder {
    private final boolean strengthenGraphWithConstants;
    private final StrengthenGraphsCounters beforeCounters;
    private final StrengthenGraphsCounters afterCounters;

    public StrengthenGraphs(PointsToAnalysis bb, Universe converter) {
        super(bb, converter);
        this.strengthenGraphWithConstants = (Boolean)Options.StrengthenGraphWithConstants.getValue(bb.getOptions());
        if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(bb.getOptions())).booleanValue()) {
            this.beforeCounters = new StrengthenGraphsCounters(ImageBuildStatistics.CheckCountLocation.BEFORE_STRENGTHEN_GRAPHS);
            this.afterCounters = new StrengthenGraphsCounters(ImageBuildStatistics.CheckCountLocation.AFTER_STRENGTHEN_GRAPHS);
        } else {
            this.beforeCounters = null;
            this.afterCounters = null;
        }
    }

    private PointsToAnalysis getAnalysis() {
        return (PointsToAnalysis)this.bb;
    }

    @Override
    public StaticAnalysisResults makeOrApplyResults(AnalysisMethod m) {
        if (!m.isImplementationInvoked()) {
            return StaticAnalysisResults.NO_RESULTS;
        }
        PointsToAnalysisMethod method = PointsToAnalysis.assertPointsToAnalysisMethod(m);
        MethodTypeFlow methodTypeFlow = method.getTypeFlow();
        if (!methodTypeFlow.flowsGraphCreated()) {
            return StaticAnalysisResults.NO_RESULTS;
        }
        DebugContext debug = new DebugContext.Builder(this.bb.getOptions(), (DebugHandlersFactory)new GraalDebugHandlersFactory(this.bb.getSnippetReflectionProvider())).build();
        StructuredGraph graph = method.decodeAnalyzedGraph(debug, methodTypeFlow.getMethodFlowsGraph().getNodeFlows().getKeys());
        if (graph != null) {
            graph.resetDebug(debug);
            if (this.beforeCounters != null) {
                this.beforeCounters.collect(graph);
            }
            try (DebugContext.Scope s = debug.scope((Object)"StrengthenGraphs", (Object)graph);
                 DebugContext.Activation a = debug.activate();){
                new AnalysisStrengthenGraphsPhase(method, graph).apply(graph, (Object)this.bb.getProviders(method));
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
            if (this.afterCounters != null) {
                this.afterCounters.collect(graph);
            }
            method.setAnalyzedGraph(GraphEncoder.encodeSingleGraph((StructuredGraph)graph, (Architecture)AnalysisParsedGraph.HOST_ARCHITECTURE));
        }
        MapCursor cursor = methodTypeFlow.getMethodFlowsGraph().getNodeFlows().getEntries();
        while (cursor.advance()) {
            ((EncodedGraph.EncodedNodeReference)cursor.getKey()).clear();
        }
        return StaticAnalysisResults.NO_RESULTS;
    }

    @Override
    public JavaTypeProfile makeTypeProfile(AnalysisField field) {
        return null;
    }

    protected abstract AnalysisType getSingleImplementorType(AnalysisType var1);

    protected abstract AnalysisType getStrengthenStampType(AnalysisType var1);

    protected abstract FixedNode createUnreachable(StructuredGraph var1, CoreProviders var2, Supplier<String> var3);

    protected abstract FixedNode createInvokeWithNullReceiverReplacement(StructuredGraph var1);

    protected abstract void setInvokeProfiles(Invoke var1, JavaTypeProfile var2, JavaMethodProfile var3);

    protected abstract String getTypeName(AnalysisType var1);

    protected abstract boolean simplifyDelegate(Node var1, SimplifierTool var2);

    public static class Options {
        public static final OptionKey<Boolean> StrengthenGraphWithConstants = new OptionKey((Object)true);
    }

    class AnalysisStrengthenGraphsPhase
    extends BasePhase<CoreProviders> {
        final CanonicalizerPhase phase;

        AnalysisStrengthenGraphsPhase(PointsToAnalysisMethod method, StructuredGraph graph) {
            this.phase = CanonicalizerPhase.create().copyWithCustomSimplification((CanonicalizerPhase.CustomSimplification)new StrengthenSimplifier(method, graph));
        }

        public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
            return this.phase.notApplicableTo(graphState);
        }

        protected void run(StructuredGraph graph, CoreProviders context) {
            this.phase.apply(graph, (Object)context);
        }

        public CharSequence getName() {
            return "AnalysisStrengthenGraphs";
        }
    }

    class StrengthenSimplifier
    implements CanonicalizerPhase.CustomSimplification {
        private final StructuredGraph graph;
        private final MethodTypeFlow methodFlow;
        private final NodeBitMap createdPiNodes;
        private final TypeFlow<?>[] parameterFlows;
        private final NodeMap<TypeFlow<?>> nodeFlows;
        private final boolean allowConstantFolding;
        private final boolean allowOptimizeReturnParameter;
        private final EconomicSet<ValueNode> unreachableValues = EconomicSet.create();
        private final Function<AnalysisType, ResolvedJavaType> toTargetFunction;

        StrengthenSimplifier(PointsToAnalysisMethod method, StructuredGraph graph) {
            this.graph = graph;
            this.methodFlow = method.getTypeFlow();
            this.createdPiNodes = new NodeBitMap((Graph)graph);
            MethodFlowsGraph originalFlows = this.methodFlow.getMethodFlowsGraph();
            this.parameterFlows = originalFlows.getParameters();
            this.nodeFlows = new NodeMap((Graph)graph);
            MapCursor cursor = originalFlows.getNodeFlows().getEntries();
            while (cursor.advance()) {
                Node node = ((EncodedGraph.EncodedNodeReference)cursor.getKey()).getNode();
                assert (this.nodeFlows.get(node) == null) : "overwriting existing entry for " + node;
                this.nodeFlows.put(node, (Object)((TypeFlow)cursor.getValue()));
            }
            this.allowConstantFolding = StrengthenGraphs.this.strengthenGraphWithConstants && StrengthenGraphs.this.bb.getHostVM().allowConstantFolding(method);
            this.allowOptimizeReturnParameter = method.isOriginalMethod();
            this.toTargetFunction = StrengthenGraphs.this.bb.getHostVM().getStrengthenGraphsToTargetFunction(method.getMultiMethodKey());
        }

        private TypeFlow<?> getNodeFlow(Node node) {
            return this.nodeFlows.isNew(node) ? null : (TypeFlow)this.nodeFlows.get(node);
        }

        public void simplify(Node n, SimplifierTool tool) {
            ValueNode node;
            if (n instanceof ValueNode && !(n instanceof LimitedValueProxy) && !(n instanceof PhiNode)) {
                node = (ValueNode)n;
                node.inferStamp();
                this.updateStampInPlace(node, this.strengthenStamp(node.stamp(NodeView.DEFAULT)), tool);
            }
            if (!StrengthenGraphs.this.simplifyDelegate(n, tool)) {
                Stamp oldStamp;
                Stamp newStamp;
                if (n instanceof ParameterNode) {
                    node = (ParameterNode)n;
                    StartNode anchorPoint = this.graph.start();
                    Object newStampOrConstant = this.strengthenStampFromTypeFlow(node, this.parameterFlows[node.index()], (FixedWithNextNode)anchorPoint, tool);
                    this.updateStampUsingPiNode(node, newStampOrConstant, (FixedWithNextNode)anchorPoint, tool);
                } else if (n instanceof LoadFieldNode || n instanceof LoadIndexedNode) {
                    node = (FixedWithNextNode)n;
                    Object newStampOrConstant = this.strengthenStampFromTypeFlow(node, this.getNodeFlow((Node)node), (FixedWithNextNode)node, tool);
                    if (newStampOrConstant instanceof JavaConstant) {
                        ConstantNode replacement = ConstantNode.forConstant((JavaConstant)((JavaConstant)newStampOrConstant), (MetaAccessProvider)StrengthenGraphs.this.bb.getMetaAccess(), (StructuredGraph)this.graph);
                        this.graph.replaceFixedWithFloating((FixedWithNextNode)node, (ValueNode)replacement);
                        tool.addToWorkList((Node)replacement);
                    } else {
                        this.updateStampInPlace(node, (Stamp)newStampOrConstant, tool);
                    }
                } else if (n instanceof Invoke) {
                    Invoke invoke = (Invoke)n;
                    if (invoke.callTarget() instanceof MethodCallTargetNode) {
                        this.handleInvoke(invoke, tool);
                    }
                } else if (n instanceof IfNode) {
                    node = (IfNode)n;
                    boolean trueUnreachable = this.isUnreachable((Node)node.trueSuccessor());
                    boolean falseUnreachable = this.isUnreachable((Node)node.falseSuccessor());
                    if (trueUnreachable && falseUnreachable) {
                        this.makeUnreachable((FixedNode)node, (CoreProviders)tool, () -> this.lambda$simplify$0((IfNode)node));
                    } else if (trueUnreachable || falseUnreachable) {
                        AbstractBeginNode killedBegin = node.successor(trueUnreachable);
                        AbstractBeginNode survivingBegin = node.successor(!trueUnreachable);
                        if (survivingBegin.hasUsages()) {
                            ValueAnchorNode anchor = (ValueAnchorNode)this.graph.add((Node)new ValueAnchorNode(null));
                            this.graph.addAfterFixed((FixedWithNextNode)survivingBegin, (FixedNode)anchor);
                            survivingBegin.replaceAtUsages((Node)anchor, new InputType[]{InputType.Guard, InputType.Anchor});
                        }
                        this.graph.removeSplit((ControlSplitNode)node, survivingBegin);
                        GraphUtil.killCFG((FixedNode)killedBegin);
                    }
                } else if (n instanceof FixedGuardNode) {
                    node = (FixedGuardNode)n;
                    if (this.isUnreachable((Node)node)) {
                        node.setCondition((LogicNode)LogicConstantNode.tautology((Graph)this.graph), true);
                        tool.addToWorkList((Node)node);
                    }
                } else if (n instanceof InstanceOfNode) {
                    node = (InstanceOfNode)n;
                    ObjectStamp oldStamp2 = node.getCheckedStamp();
                    Stamp newStamp2 = this.strengthenStamp((Stamp)oldStamp2);
                    if (newStamp2 != null) {
                        LogicNode replacement = (LogicNode)this.graph.addOrUniqueWithInputs((Node)InstanceOfNode.createHelper((ObjectStamp)((ObjectStamp)oldStamp2.improveWith(newStamp2)), (ValueNode)node.getValue(), (JavaTypeProfile)node.profile(), (AnchoringNode)node.getAnchor()));
                        node.replaceAndDelete((Node)replacement);
                        tool.addToWorkList((Node)replacement);
                    }
                } else if (n instanceof ClassIsAssignableFromNode) {
                    node = (ClassIsAssignableFromNode)n;
                    AnalysisType nonReachableType = this.asConstantNonReachableType(node.getThisClass(), (CoreProviders)tool);
                    if (nonReachableType != null) {
                        node.replaceAndDelete((Node)LogicConstantNode.contradiction((Graph)this.graph));
                    }
                } else if (n instanceof BytecodeExceptionNode) {
                    AnalysisType nonReachableType;
                    node = (BytecodeExceptionNode)n;
                    if (node.getExceptionKind() == BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST && (nonReachableType = this.asConstantNonReachableType((ValueNode)node.getArguments().get(1), (CoreProviders)tool)) != null) {
                        node.getArguments().set(1, (Object)ConstantNode.forConstant((JavaConstant)tool.getConstantReflection().forString(StrengthenGraphs.this.getTypeName(nonReachableType)), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph));
                    }
                } else if (n instanceof FrameState) {
                    node = (FrameState)n;
                    for (int i = 0; i < node.values().size(); ++i) {
                        AnalysisType nonReachableType = this.asConstantNonReachableType((ValueNode)node.values().get(i), (CoreProviders)tool);
                        if (nonReachableType == null) continue;
                        node.values().set(i, (Object)ConstantNode.forConstant((JavaConstant)tool.getConstantReflection().forString(StrengthenGraphs.this.getTypeName(nonReachableType)), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph));
                    }
                } else if (n instanceof PiNode && (newStamp = this.strengthenStamp(oldStamp = (node = (PiNode)n).piStamp())) != null) {
                    node.strengthenPiStamp(oldStamp.improveWith(newStamp));
                    tool.addToWorkList((Node)node);
                }
            }
        }

        private AnalysisType asConstantNonReachableType(ValueNode value, CoreProviders providers) {
            AnalysisType expectedType;
            if (value != null && value.isConstant() && (expectedType = (AnalysisType)providers.getConstantReflection().asJavaType(value.asConstant())) != null && !expectedType.isReachable()) {
                return expectedType;
            }
            return null;
        }

        private void handleInvoke(Invoke invoke, SimplifierTool tool) {
            PointsToAnalysis pta = StrengthenGraphs.this.getAnalysis();
            FixedNode node = invoke.asFixedNode();
            MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
            InvokeTypeFlow invokeFlow = (InvokeTypeFlow)this.getNodeFlow((Node)node);
            Collection<AnalysisMethod> callees = invokeFlow.getOriginalCallees();
            if (callees.isEmpty()) {
                this.unreachableInvoke(invoke, tool);
                return;
            }
            FixedWithNextNode beforeInvoke = (FixedWithNextNode)invoke.predecessor();
            NodeInputList arguments = callTarget.arguments();
            for (int i = 0; i < arguments.size(); ++i) {
                ValueNode pi;
                ValueNode argument = (ValueNode)arguments.get(i);
                Object newStampOrConstant = this.strengthenStampFromTypeFlow(argument, invokeFlow.getActualParameters()[i], beforeInvoke, tool);
                if (node.isDeleted()) {
                    return;
                }
                if (i == 0 && invoke.getInvokeKind() != CallTargetNode.InvokeKind.Static) {
                    boolean nullReceiver = false;
                    if (argument instanceof ConstantNode) {
                        ConstantNode constantNode = (ConstantNode)argument;
                        nullReceiver = constantNode.getValue().isDefaultForKind();
                    }
                    if (!nullReceiver && newStampOrConstant instanceof ObjectStamp) {
                        ObjectStamp stamp = (ObjectStamp)newStampOrConstant;
                        nullReceiver = stamp.alwaysNull();
                    }
                    if (!nullReceiver && newStampOrConstant instanceof Constant) {
                        Constant constantValue = (Constant)newStampOrConstant;
                        nullReceiver = constantValue.isDefaultForKind();
                    }
                    if (nullReceiver) {
                        this.invokeWithNullReceiver(invoke);
                        return;
                    }
                }
                if (newStampOrConstant == null || (pi = this.insertPi(argument, newStampOrConstant, beforeInvoke)) == null || pi == argument) continue;
                callTarget.replaceAllInputs((Node)argument, (Node)pi);
            }
            if (callees.size() == 1) {
                AnalysisMethod singleCallee = callees.iterator().next();
                if (callTarget.invokeKind().isDirect()) {
                    assert (callTarget.targetMethod().equals(singleCallee)) : "Direct invoke target mismatch: " + callTarget.targetMethod() + " != " + singleCallee;
                } else {
                    this.devirtualizeInvoke(singleCallee, invoke);
                }
            } else {
                TypeState receiverTypeState = null;
                if (invokeFlow.getTargetMethod().hasReceiver() && !this.methodFlow.isSaturated(pta, invokeFlow.getReceiver())) {
                    receiverTypeState = this.methodFlow.foldTypeFlow(pta, invokeFlow.getReceiver());
                }
                JavaTypeProfile typeProfile = StrengthenGraphs.this.makeTypeProfile(receiverTypeState);
                JavaMethodProfile methodProfile = StrengthenGraphs.this.makeMethodProfile(callees);
                assert (typeProfile == null || typeProfile.getTypes().length > 1) : "Should devirtualize with typeProfile=" + typeProfile + " and methodProfile=" + methodProfile;
                assert (methodProfile == null || methodProfile.getMethods().length > 1) : "Should devirtualize with typeProfile=" + typeProfile + " and methodProfile=" + methodProfile;
                StrengthenGraphs.this.setInvokeProfiles(invoke, typeProfile, methodProfile);
            }
            if (this.allowOptimizeReturnParameter && StrengthenGraphs.this.getAnalysis().optimizeReturnedParameter()) {
                this.optimizeReturnedParameter(callees, (NodeInputList<ValueNode>)arguments, node, tool);
            }
            FixedWithNextNode anchorPointAfterInvoke = (FixedWithNextNode)(invoke instanceof InvokeWithExceptionNode ? invoke.next() : invoke);
            Object newStampOrConstant = this.strengthenStampFromTypeFlow((ValueNode)node, invokeFlow.getResult(), anchorPointAfterInvoke, tool);
            this.updateStampUsingPiNode((ValueNode)node, newStampOrConstant, anchorPointAfterInvoke, tool);
        }

        private void optimizeReturnedParameter(Collection<AnalysisMethod> callees, NodeInputList<ValueNode> arguments, FixedNode invoke, SimplifierTool tool) {
            int returnedParameterIndex = -1;
            for (AnalysisMethod callee : callees) {
                if (callee.hasNeverInlineDirective()) {
                    return;
                }
                int returnedCalleeParameterIndex = PointsToAnalysis.assertPointsToAnalysisMethod(callee).getTypeFlow().getReturnedParameterIndex();
                if (returnedCalleeParameterIndex == -1) {
                    return;
                }
                if (returnedParameterIndex == -1) {
                    returnedParameterIndex = returnedCalleeParameterIndex;
                    continue;
                }
                if (returnedParameterIndex == returnedCalleeParameterIndex) continue;
                return;
            }
            assert (returnedParameterIndex != -1);
            ValueNode returnedActualParameter = (ValueNode)arguments.get(returnedParameterIndex);
            tool.addToWorkList((Iterable)invoke.usages());
            invoke.replaceAtUsages((Node)returnedActualParameter);
        }

        protected void invokeWithNullReceiver(Invoke invoke) {
            FixedNode replacement = StrengthenGraphs.this.createInvokeWithNullReceiverReplacement(this.graph);
            ((FixedWithNextNode)invoke.predecessor()).setNext(replacement);
            GraphUtil.killCFG((FixedNode)invoke.asFixedNode());
        }

        private void unreachableInvoke(Invoke invoke, SimplifierTool tool) {
            if (invoke.getInvokeKind() != CallTargetNode.InvokeKind.Static) {
                InliningUtil.nonNullReceiver((Invoke)invoke);
            }
            this.makeUnreachable(invoke.asFixedNode(), (CoreProviders)tool, () -> "method " + ((AnalysisMethod)this.graph.method()).getQualifiedName() + ", node " + invoke + ": empty list of callees for call to " + ((AnalysisMethod)invoke.callTarget().targetMethod()).getQualifiedName());
        }

        private void devirtualizeInvoke(AnalysisMethod singleCallee, Invoke invoke) {
            if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(this.graph.getOptions())).booleanValue()) {
                ImageBuildStatistics.counters().incDevirtualizedInvokeCounter();
            }
            ObjectStamp anchoredReceiverStamp = StampFactory.object((TypeReference)TypeReference.createWithoutAssumptions((ResolvedJavaType)singleCallee.getDeclaringClass()));
            ValueNode piReceiver = this.insertPi(invoke.getReceiver(), anchoredReceiverStamp, (FixedWithNextNode)invoke.asNode().predecessor());
            if (piReceiver != null) {
                invoke.callTarget().replaceFirstInput((Node)invoke.getReceiver(), (Node)piReceiver);
            }
            assert (invoke.getInvokeKind().isIndirect());
            invoke.callTarget().setInvokeKind(CallTargetNode.InvokeKind.Special);
            invoke.callTarget().setTargetMethod((ResolvedJavaMethod)singleCallee);
        }

        private boolean isUnreachable(Node branch) {
            PointsToAnalysis pta = StrengthenGraphs.this.getAnalysis();
            TypeFlow<?> branchFlow = this.getNodeFlow(branch);
            return branchFlow != null && !this.methodFlow.isSaturated(pta, branchFlow) && this.methodFlow.foldTypeFlow(pta, branchFlow).isEmpty();
        }

        private void updateStampInPlace(ValueNode node, Stamp newStamp, SimplifierTool tool) {
            Stamp computedStamp;
            Stamp oldStamp;
            if (newStamp != null && !(oldStamp = node.stamp(NodeView.DEFAULT)).equals(computedStamp = oldStamp.improveWith(newStamp))) {
                node.setStamp(newStamp);
                tool.addToWorkList((Iterable)node.usages());
            }
        }

        private void updateStampUsingPiNode(ValueNode node, Object newStampOrConstant, FixedWithNextNode anchorPoint, SimplifierTool tool) {
            ValueNode pi;
            if (newStampOrConstant != null && node.hasUsages() && !this.createdPiNodes.isMarked((Node)node) && (pi = this.insertPi(node, newStampOrConstant, anchorPoint)) != null) {
                this.createdPiNodes.mark((Node)node);
                if (pi.isConstant()) {
                    node.replaceAtUsages((Node)pi);
                } else {
                    FrameState anchorState = node instanceof StateSplit ? ((StateSplit)node).stateAfter() : this.graph.start().stateAfter();
                    node.replaceAtUsages((Node)pi, usage -> usage != pi && usage != anchorState);
                }
                tool.addToWorkList((Iterable)pi.usages());
            }
        }

        private ValueNode insertPi(ValueNode input, Object newStampOrConstant, FixedWithNextNode anchorPoint) {
            Stamp computedStamp;
            if (newStampOrConstant instanceof JavaConstant) {
                JavaConstant constant = (JavaConstant)newStampOrConstant;
                if (input.isConstant()) {
                    assert (StrengthenGraphs.this.bb.getConstantReflectionProvider().constantEquals(input.asConstant(), (Constant)constant).booleanValue());
                    return null;
                }
                return ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)StrengthenGraphs.this.bb.getMetaAccess(), (StructuredGraph)this.graph);
            }
            Stamp piStamp = (Stamp)newStampOrConstant;
            Stamp oldStamp = input.stamp(NodeView.DEFAULT);
            if (oldStamp.equals(computedStamp = oldStamp.improveWith(piStamp))) {
                return null;
            }
            ValueAnchorNode anchor = (ValueAnchorNode)this.graph.add((Node)new ValueAnchorNode(null));
            this.graph.addAfterFixed(anchorPoint, (FixedNode)anchor);
            return (ValueNode)this.graph.unique((Node)new PiNode(input, piStamp, (ValueNode)anchor));
        }

        private Object strengthenStampFromTypeFlow(ValueNode node, TypeFlow<?> nodeFlow, FixedWithNextNode anchorPoint, SimplifierTool tool) {
            PointsToAnalysis pta = StrengthenGraphs.this.getAnalysis();
            if (node.getStackKind() != JavaKind.Object) {
                return null;
            }
            if (this.methodFlow.isSaturated(pta, nodeFlow)) {
                return null;
            }
            if (this.unreachableValues.contains((Object)node)) {
                return null;
            }
            boolean hasUsages = node.usages().filter(n -> !(n instanceof FrameState)).isNotEmpty();
            TypeState nodeTypeState = this.methodFlow.foldTypeFlow(pta, nodeFlow);
            if (hasUsages && this.allowConstantFolding && !nodeTypeState.canBeNull()) {
                JavaConstant constantValue = nodeTypeState.asConstant();
                if (constantValue instanceof ImageHeapConstant) {
                    constantValue = ((ImageHeapConstant)constantValue).getHostedObject();
                }
                if (constantValue != null) {
                    return constantValue;
                }
            }
            node.inferStamp();
            ObjectStamp oldStamp = (ObjectStamp)node.stamp(NodeView.DEFAULT);
            AnalysisType oldType = (AnalysisType)oldStamp.type();
            boolean nonNull = oldStamp.nonNull() || !nodeTypeState.canBeNull();
            ArrayList<AnalysisType> typeStateTypes = new ArrayList<AnalysisType>(nodeTypeState.typesCount());
            for (AnalysisType typeStateType2 : nodeTypeState.types(pta)) {
                if (oldType != null && !(oldStamp.isExactType() ? oldType.equals(typeStateType2) : oldType.isJavaLangObject() || oldType.isAssignableFrom(typeStateType2))) continue;
                typeStateTypes.add(typeStateType2);
            }
            if (typeStateTypes.size() == 0) {
                if (nonNull) {
                    this.makeUnreachable(anchorPoint.next(), (CoreProviders)tool, () -> "method " + ((AnalysisMethod)this.graph.method()).getQualifiedName() + ", node " + node + ": empty stamp when strengthening oldStamp " + oldStamp);
                    this.unreachableValues.add((Object)node);
                    return null;
                }
                return hasUsages ? StampFactory.alwaysNull() : null;
            }
            if (!hasUsages) {
                return null;
            }
            if (typeStateTypes.size() == 1) {
                ResolvedJavaType targetType;
                AnalysisType exactType = (AnalysisType)typeStateTypes.get(0);
                assert (StrengthenGraphs.this.getSingleImplementorType(exactType) == null || exactType.equals(StrengthenGraphs.this.getSingleImplementorType(exactType))) : "exactType=" + exactType + ", singleImplementor=" + StrengthenGraphs.this.getSingleImplementorType(exactType);
                assert (exactType.equals(StrengthenGraphs.this.getStrengthenStampType(exactType)));
                if (!(oldStamp.isExactType() && exactType.equals(oldType) || (targetType = this.toTargetFunction.apply(exactType)) == null)) {
                    TypeReference typeRef = TypeReference.createExactTrusted((ResolvedJavaType)targetType);
                    return StampFactory.object((TypeReference)typeRef, (boolean)nonNull);
                }
            } else if (!oldStamp.isExactType()) {
                ResolvedJavaType targetType;
                assert (typeStateTypes.size() > 1);
                AnalysisType baseType = (AnalysisType)typeStateTypes.get(0);
                for (int i = 1; i < typeStateTypes.size() && !baseType.isJavaLangObject(); ++i) {
                    baseType = baseType.findLeastCommonAncestor((ResolvedJavaType)typeStateTypes.get(i));
                }
                if (oldType != null && !oldType.isAssignableFrom(baseType)) {
                    baseType = oldType;
                }
                assert (StrengthenGraphs.this.getSingleImplementorType(baseType) == null || baseType.equals(StrengthenGraphs.this.getSingleImplementorType(baseType))) : "baseType=" + baseType + ", singleImplementor=" + StrengthenGraphs.this.getSingleImplementorType(baseType);
                AnalysisType newType = StrengthenGraphs.this.getStrengthenStampType(baseType);
                assert (typeStateTypes.stream().map(typeStateType -> newType.isAssignableFrom((ResolvedJavaType)typeStateType)).reduce(Boolean::logicalAnd).get().booleanValue());
                if (!(newType.equals(oldType) || oldType == null && newType.isJavaLangObject() || (targetType = this.toTargetFunction.apply(newType)) == null)) {
                    TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)targetType);
                    return StampFactory.object((TypeReference)typeRef, (boolean)nonNull);
                }
            }
            if (nonNull != oldStamp.nonNull()) {
                assert (nonNull);
                return oldStamp.asNonNull();
            }
            return null;
        }

        private void makeUnreachable(FixedNode node, CoreProviders providers, Supplier<String> message) {
            FixedNode unreachableNode = StrengthenGraphs.this.createUnreachable(this.graph, providers, message);
            ((FixedWithNextNode)node.predecessor()).setNext(unreachableNode);
            GraphUtil.killCFG((FixedNode)node);
        }

        private Stamp strengthenStamp(Stamp s) {
            Stamp newStamp;
            ResolvedJavaType targetType;
            if (!(s instanceof AbstractObjectStamp)) {
                return null;
            }
            AbstractObjectStamp stamp = (AbstractObjectStamp)s;
            AnalysisType originalType = (AnalysisType)stamp.type();
            if (originalType == null) {
                return null;
            }
            if (!originalType.isReachable()) {
                if (stamp.nonNull()) {
                    return StampFactory.empty((JavaKind)JavaKind.Object);
                }
                return StampFactory.alwaysNull();
            }
            AnalysisType singleImplementorType = StrengthenGraphs.this.getSingleImplementorType(originalType);
            if (!(singleImplementorType == null || stamp.isExactType() && singleImplementorType.equals(originalType) || (targetType = this.toTargetFunction.apply(singleImplementorType)) == null)) {
                TypeReference typeRef = TypeReference.createExactTrusted((ResolvedJavaType)targetType);
                return StampFactory.object((TypeReference)typeRef, (boolean)stamp.nonNull());
            }
            AnalysisType strengthenType = StrengthenGraphs.this.getStrengthenStampType(originalType);
            if (originalType.equals(strengthenType)) {
                return null;
            }
            if (strengthenType == null) {
                newStamp = stamp.nonNull() ? StampFactory.empty((JavaKind)JavaKind.Object) : StampFactory.alwaysNull();
            } else if (stamp.isExactType()) {
                newStamp = StampFactory.empty((JavaKind)JavaKind.Object);
            } else {
                ResolvedJavaType targetType2 = this.toTargetFunction.apply(strengthenType);
                if (targetType2 == null) {
                    return null;
                }
                TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)targetType2);
                newStamp = StampFactory.object((TypeReference)typeRef, (boolean)stamp.nonNull());
            }
            return newStamp;
        }

        private /* synthetic */ String lambda$simplify$0(IfNode node) {
            return "method " + this.graph.method().format("%H.%n(%p)") + ", node " + node + ": both successors of IfNode are unreachable";
        }
    }
}

