/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.util.LightImmutableCollection;
import com.oracle.svm.common.meta.MultiMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.code.BytecodePosition;

public abstract class DirectInvokeTypeFlow
extends InvokeTypeFlow {
    private volatile Object callees;
    protected static final AtomicReferenceFieldUpdater<DirectInvokeTypeFlow, Object> CALLEES_ACCESSOR = AtomicReferenceFieldUpdater.newUpdater(DirectInvokeTypeFlow.class, Object.class, "callees");

    protected DirectInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
    }

    protected DirectInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, DirectInvokeTypeFlow original) {
        super(bb, methodFlows, original);
    }

    protected final void initializeCallees(PointsToAnalysis bb) {
        if (this.callees == null) {
            Collection<PointsToAnalysisMethod> calculatedCallees = bb.getHostVM().getMultiMethodAnalysisPolicy().determineCallees(bb, this.targetMethod, this.targetMethod, this.callerMultiMethodKey, this);
            LightImmutableCollection.initializeNonEmpty(this, CALLEES_ACCESSOR, calculatedCallees);
            this.allOriginalCallees = LightImmutableCollection.allMatch(this, CALLEES_ACCESSOR, callee -> callee.isOriginalMethod());
            if (this.originalInvoke != null) {
                ((DirectInvokeTypeFlow)this.originalInvoke).callees = this.callees;
                this.originalInvoke.allOriginalCallees = this.allOriginalCallees;
            }
        }
    }

    @Override
    public final boolean isDirectInvoke() {
        return true;
    }

    @Override
    public final Collection<AnalysisMethod> getAllCallees() {
        return this.getAllCalleesHelper(false);
    }

    @Override
    public final Collection<AnalysisMethod> getAllComputedCallees() {
        return this.getAllCalleesHelper(true);
    }

    private Collection<AnalysisMethod> getAllCalleesHelper(boolean allComputed) {
        if (allComputed || this.targetMethod.isImplementationInvoked()) {
            Collection<AnalysisMethod> result = LightImmutableCollection.toCollection(this, CALLEES_ACCESSOR);
            if (!allComputed) assert (result.stream().filter(m -> m.isOriginalMethod()).allMatch(AnalysisMethod::isImplementationInvoked));
            return result;
        }
        return Collections.emptyList();
    }
}

