/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.phases;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisInlineInvokePlugin;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.UnsafeAccessNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.replacements.nodes.MethodHandleWithExceptionNode;
import org.graalvm.compiler.replacements.nodes.ResolvedMethodHandleCallTargetNode;

public class InlineBeforeAnalysisGraphDecoder
extends PEGraphDecoder {
    private Field dmhStaticAccessorOffsetField;
    private Field dmhStaticAccessorBaseField;
    private AnalysisField dmhStaticAccessorOffsetAnalysisField;
    private AnalysisField dmhStaticAccessorBaseAnalysisField;
    protected final BigBang bb;
    protected final InlineBeforeAnalysisPolicy policy;

    public InlineBeforeAnalysisGraphDecoder(BigBang bb, InlineBeforeAnalysisPolicy policy, StructuredGraph graph, HostedProviders providers, LoopExplosionPlugin loopExplosionPlugin) {
        super(AnalysisParsedGraph.HOST_ARCHITECTURE, graph, (CoreProviders)providers, loopExplosionPlugin, providers.getGraphBuilderPlugins().getInvocationPlugins(), new InlineInvokePlugin[]{new InlineBeforeAnalysisInlineInvokePlugin(policy)}, null, policy.nodePlugins, null, null, new ConcurrentHashMap(), new ConcurrentHashMap(), policy.needsExplicitExceptions(), false);
        this.bb = bb;
        this.policy = policy;
        if (graph.getDebug().isLogEnabled()) {
            graph.getDebug().logv("InlineBeforeAnalysis: decoding " + graph.method().format("%H.%n(%p)"), new Object[0]);
        }
    }

    protected InvocationPlugin getInvocationPlugin(ResolvedJavaMethod targetMethod) {
        if (this.policy.tryInvocationPlugins()) {
            return super.getInvocationPlugin(targetMethod);
        }
        return null;
    }

    protected void cleanupGraph(GraphDecoder.MethodScope ms) {
        super.cleanupGraph(ms);
        InlineBeforeAnalysisMethodScope methodScope = this.cast(ms);
        methodScope.encodedGraphs.add((Object)methodScope.encodedGraph);
        for (EncodedGraph encodedGraph : methodScope.encodedGraphs) {
            super.recordGraphElements(encodedGraph);
        }
    }

    protected PEGraphDecoder.PEMethodScope createMethodScope(StructuredGraph targetGraph, PEGraphDecoder.PEMethodScope caller, GraphDecoder.LoopScope callerLoopScope, EncodedGraph encodedGraph, ResolvedJavaMethod method, GraphDecoder.InvokeData invokeData, int inliningDepth, ValueNode[] arguments) {
        return new InlineBeforeAnalysisMethodScope(targetGraph, caller, callerLoopScope, encodedGraph, method, invokeData, inliningDepth, arguments);
    }

    protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider) {
        AnalysisMethod aMethod = (AnalysisMethod)method;
        return aMethod.ensureGraphParsed(this.bb).getEncodedGraph();
    }

    protected Node addFloatingNode(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        assert (node.isUnregistered()) : "If node is already in the graph, we would count it twice";
        this.maybeAbortInlining(methodScope, loopScope, node);
        return super.addFloatingNode(methodScope, loopScope, node);
    }

    protected final Node canonicalizeFixedNode(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        Node canonical = node;
        if (node instanceof UnsafeAccessNode) {
            UnsafeAccessNode unsafeAccess = (UnsafeAccessNode)node;
            canonical = this.canonicalizeUnsafeAccess(unsafeAccess);
        }
        canonical = super.canonicalizeFixedNode(methodScope, loopScope, canonical);
        canonical = this.doCanonicalizeFixedNode(this.cast(methodScope), loopScope, canonical);
        if (canonical == node || canonical != null && canonical.isUnregistered()) {
            this.maybeAbortInlining(methodScope, loopScope, canonical);
        }
        return canonical;
    }

    protected boolean shouldOmitIntermediateMethodInStates(ResolvedJavaMethod method) {
        return this.policy.shouldOmitIntermediateMethodInState(method);
    }

    protected Node doCanonicalizeFixedNode(InlineBeforeAnalysisMethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        return node;
    }

    private Node canonicalizeUnsafeAccess(UnsafeAccessNode node) {
        Class clazz;
        long offset;
        LoadFieldNode offsetLoad;
        ValueNode valueNode;
        if (!(node.isCanonicalizable() && (valueNode = node.offset()) instanceof LoadFieldNode && (offsetLoad = (LoadFieldNode)valueNode).object() != null && offsetLoad.object().isJavaConstant())) {
            return node;
        }
        this.ensureDMHStaticAccessorFieldsInitialized();
        if (!offsetLoad.field().equals(this.dmhStaticAccessorOffsetAnalysisField)) {
            return node;
        }
        JavaConstant accessorConstant = offsetLoad.object().asJavaConstant();
        Object accessor = this.bb.getSnippetReflectionProvider().asObject(Object.class, accessorConstant);
        try {
            offset = this.dmhStaticAccessorOffsetField.getLong(accessor);
            clazz = (Class)this.dmhStaticAccessorBaseField.get(accessor);
        }
        catch (IllegalAccessException e) {
            throw AnalysisError.shouldNotReachHere(e);
        }
        if (clazz == null) {
            return node;
        }
        ResolvedJavaType type = GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType(clazz);
        ResolvedJavaField hostField = UnsafeAccessNode.findStaticFieldWithOffset((ResolvedJavaType)type, (long)offset, (JavaKind)node.accessKind());
        if (hostField == null) {
            return node;
        }
        AnalysisField field = this.bb.getUniverse().lookup((JavaField)hostField);
        if (field.isInternal() || field.getJavaKind() != node.accessKind()) {
            return node;
        }
        return node.cloneAsFieldAccess((ResolvedJavaField)field);
    }

    protected Node handleFloatingNodeAfterAdd(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, Node node) {
        Node canonical = node;
        if (canonical instanceof IsNullNode) {
            IsNullNode isNull = (IsNullNode)canonical;
            canonical = this.canonicalizeIsNull(isNull);
        }
        if (canonical != node) {
            canonical.setNodeSourcePosition(node.getNodeSourcePosition());
            node.replaceAtUsagesAndDelete(canonical);
        }
        return super.handleFloatingNodeAfterAdd(s, loopScope, canonical);
    }

    private Node canonicalizeIsNull(IsNullNode node) {
        LoadFieldNode fieldLoad;
        ValueNode valueNode = node.getValue();
        if (!(valueNode instanceof LoadFieldNode) || (fieldLoad = (LoadFieldNode)valueNode).object() == null || !fieldLoad.object().isJavaConstant()) {
            return node;
        }
        this.ensureDMHStaticAccessorFieldsInitialized();
        if (!fieldLoad.field().equals(this.dmhStaticAccessorBaseAnalysisField)) {
            return node;
        }
        return LogicConstantNode.contradiction((Graph)node.graph());
    }

    private void ensureDMHStaticAccessorFieldsInitialized() {
        if (this.dmhStaticAccessorOffsetField == null) {
            assert (this.dmhStaticAccessorBaseField == null && this.dmhStaticAccessorOffsetAnalysisField == null && this.dmhStaticAccessorBaseAnalysisField == null);
            Class staticAccessorClass = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.DirectMethodHandle$StaticAccessor");
            this.dmhStaticAccessorOffsetField = ReflectionUtil.lookupField((Class)staticAccessorClass, (String)"staticOffset");
            this.dmhStaticAccessorBaseField = ReflectionUtil.lookupField((Class)staticAccessorClass, (String)"staticBase");
            this.dmhStaticAccessorOffsetAnalysisField = this.bb.getMetaAccess().lookupJavaField(this.dmhStaticAccessorOffsetField);
            this.dmhStaticAccessorBaseAnalysisField = this.bb.getMetaAccess().lookupJavaField(this.dmhStaticAccessorBaseField);
        }
    }

    protected void handleNonInlinedInvoke(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData) {
        this.maybeAbortInlining(methodScope, loopScope, (Node)((Invoke)invokeData.invoke).asNode());
        super.handleNonInlinedInvoke(methodScope, loopScope, invokeData);
    }

    protected void maybeAbortInlining(GraphDecoder.MethodScope ms, GraphDecoder.LoopScope loopScope, Node node) {
        InlineBeforeAnalysisMethodScope methodScope = this.cast(ms);
        if (!methodScope.inliningAborted && methodScope.isInlinedMethod()) {
            if (this.graph.getDebug().isLogEnabled()) {
                this.graph.getDebug().logv("  ".repeat(methodScope.inliningDepth) + "  node " + node + ": " + methodScope.policyScope, new Object[0]);
            }
            if (!methodScope.policyScope.processNode(this.bb.getMetaAccess(), methodScope.method, node)) {
                this.abortInlining(methodScope);
            }
        }
    }

    protected void abortInlining(InlineBeforeAnalysisMethodScope methodScope) {
        if (!methodScope.inliningAborted) {
            if (this.graph.getDebug().isLogEnabled()) {
                this.graph.getDebug().logv("  ".repeat(methodScope.inliningDepth) + "    abort!", new Object[0]);
            }
            methodScope.inliningAborted = true;
        }
    }

    protected GraphDecoder.LoopScope processNextNode(GraphDecoder.MethodScope ms, GraphDecoder.LoopScope loopScope) {
        InlineBeforeAnalysisMethodScope methodScope = this.cast(ms);
        if (methodScope.inliningAborted) {
            loopScope.nodesToProcess.clear();
            return loopScope;
        }
        return super.processNextNode((GraphDecoder.MethodScope)methodScope, loopScope);
    }

    protected GraphDecoder.LoopScope handleMethodHandle(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokableData<MethodHandleWithExceptionNode> invokableData) {
        CallTargetNode callTarget;
        boolean intrinsifiedMethodHandle;
        MethodHandleWithExceptionNode node = (MethodHandleWithExceptionNode)invokableData.invoke;
        WithExceptionNode replacement = node.trySimplify(this.providers.getConstantReflection().getMethodHandleAccess());
        boolean bl = intrinsifiedMethodHandle = replacement != node;
        if (!intrinsifiedMethodHandle) {
            replacement = node.replaceWithInvoke().asNode();
        }
        InvokeWithExceptionNode invoke = (InvokeWithExceptionNode)replacement;
        this.registerNode(loopScope, invokableData.orderId, (Node)invoke, true, false);
        GraphDecoder.InvokeData invokeData = new GraphDecoder.InvokeData((Invoke)invoke, invokableData.contextType, invokableData.orderId, -1, intrinsifiedMethodHandle, invokableData.stateAfterOrderId, invokableData.nextOrderId, invokableData.exceptionOrderId, invokableData.exceptionStateOrderId, invokableData.exceptionNextOrderId);
        CallTargetNode callTargetNode = invoke.callTarget();
        if (callTargetNode instanceof ResolvedMethodHandleCallTargetNode) {
            ResolvedMethodHandleCallTargetNode t = (ResolvedMethodHandleCallTargetNode)callTargetNode;
            callTarget = new MethodCallTargetNode(t.invokeKind(), t.targetMethod(), (ValueNode[])t.arguments().toArray((Object[])ValueNode.EMPTY_ARRAY), t.returnStamp(), t.getTypeProfile());
        } else {
            callTarget = (CallTargetNode)invoke.callTarget().copyWithInputs(false);
        }
        invoke.callTarget().replaceAtUsagesAndDelete(null);
        invokeData.callTarget = callTarget;
        return this.handleInvokeWithCallTarget((PEGraphDecoder.PEMethodScope)s, loopScope, invokeData);
    }

    protected void recordGraphElements(EncodedGraph encodedGraph) {
    }

    protected void finishInlining(GraphDecoder.MethodScope is) {
        InlineBeforeAnalysisMethodScope inlineScope = this.cast(is);
        InlineBeforeAnalysisMethodScope callerScope = this.cast((GraphDecoder.MethodScope)inlineScope.caller);
        GraphDecoder.LoopScope callerLoopScope = inlineScope.callerLoopScope;
        GraphDecoder.InvokeData invokeData = inlineScope.invokeData;
        if (inlineScope.inliningAborted) {
            if (this.graph.getDebug().isLogEnabled()) {
                this.graph.getDebug().logv("  ".repeat(callerScope.inliningDepth) + "  aborted " + invokeData.callTarget.targetMethod().format("%H.%n(%p)") + ": " + inlineScope.policyScope, new Object[0]);
            }
            AnalysisError.guarantee(inlineScope.policyScope.allowAbort(), "Unexpected abort: %s", new Object[]{inlineScope});
            if (callerScope.policyScope != null) {
                callerScope.policyScope.abortCalleeScope(inlineScope.policyScope);
            }
            if (invokeData.invokePredecessor.next() != null) {
                this.killControlFlowNodes(inlineScope, invokeData.invokePredecessor.next());
                assert (invokeData.invokePredecessor.next() == null) : "Successor must have been a fixed node created in the aborted scope, which is deleted now";
            }
            invokeData.invokePredecessor.setNext(((Invoke)invokeData.invoke).asFixedNode());
            if (inlineScope.exceptionPlaceholderNode != null) {
                assert (invokeData.invoke instanceof InvokeWithExceptionNode);
                assert (this.lookupNode(callerLoopScope, invokeData.exceptionOrderId) == inlineScope.exceptionPlaceholderNode);
                this.registerNode(callerLoopScope, invokeData.exceptionOrderId, null, true, true);
                FixedNode exceptionReplacement = this.makeStubNode((GraphDecoder.MethodScope)callerScope, callerLoopScope, invokeData.exceptionOrderId);
                inlineScope.exceptionPlaceholderNode.replaceAtUsagesAndDelete((Node)exceptionReplacement);
            }
            this.handleNonInlinedInvoke((GraphDecoder.MethodScope)callerScope, callerLoopScope, invokeData);
            return;
        }
        if (this.graph.getDebug().isLogEnabled()) {
            this.graph.getDebug().logv("  ".repeat(callerScope.inliningDepth) + "  committed " + invokeData.callTarget.targetMethod().format("%H.%n(%p)") + ": " + inlineScope.policyScope, new Object[0]);
        }
        if (callerScope.policyScope != null) {
            callerScope.policyScope.commitCalleeScope(inlineScope.policyScope);
        }
        InlineBeforeAnalysisMethodScope.recordInlined(callerScope, inlineScope);
        NodeSourcePosition callerBytecodePosition = callerScope.getCallerNodeSourcePosition();
        NodeSourcePosition reason = callerBytecodePosition != null ? callerBytecodePosition : callerScope.method;
        reason = reason == null ? this.graph.method() : reason;
        ((AnalysisMethod)invokeData.callTarget.targetMethod()).registerAsInlined(reason);
        super.finishInlining((GraphDecoder.MethodScope)inlineScope);
    }

    private void killControlFlowNodes(PEGraphDecoder.PEMethodScope inlineScope, FixedNode start) {
        ArrayDeque<Node> workList = null;
        FixedNode cur = start;
        while (true) {
            assert (!cur.isDeleted());
            assert (this.graph.isNew(inlineScope.methodStartMark, (Node)cur));
            FixedNode next = null;
            if (cur instanceof FixedWithNextNode) {
                next = ((FixedWithNextNode)cur).next();
            } else if (cur instanceof ControlSplitNode) {
                for (Node successor : cur.successors()) {
                    if (next == null) {
                        next = successor;
                        continue;
                    }
                    if (workList == null) {
                        workList = new ArrayDeque<Node>();
                    }
                    workList.push(successor);
                }
            } else if (cur instanceof AbstractEndNode) {
                next = ((AbstractEndNode)cur).merge();
            } else if (!(cur instanceof ControlSinkNode)) {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)cur);
            }
            if (cur instanceof AbstractMergeNode) {
                for (ValueNode phi : ((AbstractMergeNode)cur).phis().snapshot()) {
                    phi.replaceAtUsages(null);
                    phi.safeDelete();
                }
            }
            cur.replaceAtPredecessor(null);
            cur.replaceAtUsages(null);
            cur.safeDelete();
            if (next != null) {
                cur = next;
                continue;
            }
            if (workList == null || workList.isEmpty()) break;
            cur = (Node)workList.pop();
        }
    }

    protected InlineBeforeAnalysisMethodScope cast(GraphDecoder.MethodScope methodScope) {
        return (InlineBeforeAnalysisMethodScope)methodScope;
    }

    protected FixedWithNextNode afterMethodScopeCreation(PEGraphDecoder.PEMethodScope is, FixedWithNextNode predecessor) {
        InlineBeforeAnalysisMethodScope inlineScope = this.cast((GraphDecoder.MethodScope)is);
        return this.policy.processInvokeArgs(inlineScope.method, predecessor, inlineScope.getArguments());
    }

    public class InlineBeforeAnalysisMethodScope
    extends PEGraphDecoder.PEMethodScope {
        public final InlineBeforeAnalysisPolicy.AbstractPolicyScope policyScope;
        private boolean inliningAborted;
        private final EconomicSet<EncodedGraph> encodedGraphs;

        InlineBeforeAnalysisMethodScope(StructuredGraph targetGraph, PEGraphDecoder.PEMethodScope caller, GraphDecoder.LoopScope callerLoopScope, EncodedGraph encodedGraph, ResolvedJavaMethod method, GraphDecoder.InvokeData invokeData, int inliningDepth, ValueNode[] arguments) {
            super((PEGraphDecoder)InlineBeforeAnalysisGraphDecoder.this, targetGraph, caller, callerLoopScope, encodedGraph, method, invokeData, inliningDepth, arguments);
            if (caller == null) {
                this.policyScope = InlineBeforeAnalysisGraphDecoder.this.policy.createRootScope();
                if (InlineBeforeAnalysisGraphDecoder.this.graph.getDebug().isLogEnabled()) {
                    InlineBeforeAnalysisGraphDecoder.this.graph.getDebug().logv("  ".repeat(inliningDepth) + "createRootScope for " + method.format("%H.%n(%p)") + ": " + this.policyScope, new Object[0]);
                }
            } else {
                boolean[] constArgsWithReceiver = new boolean[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    constArgsWithReceiver[i] = arguments[i].isConstant();
                }
                this.policyScope = InlineBeforeAnalysisGraphDecoder.this.policy.openCalleeScope(InlineBeforeAnalysisGraphDecoder.this.cast((GraphDecoder.MethodScope)caller).policyScope, InlineBeforeAnalysisGraphDecoder.this.bb.getMetaAccess(), method, constArgsWithReceiver, invokeData.intrinsifiedMethodHandle);
                if (InlineBeforeAnalysisGraphDecoder.this.graph.getDebug().isLogEnabled()) {
                    InlineBeforeAnalysisGraphDecoder.this.graph.getDebug().logv("  ".repeat(inliningDepth) + "openCalleeScope for " + method.format("%H.%n(%p)") + ": " + this.policyScope, new Object[0]);
                }
            }
            this.encodedGraphs = EconomicSet.create();
        }

        static void recordInlined(InlineBeforeAnalysisMethodScope callerScope, InlineBeforeAnalysisMethodScope calleeScope) {
            EconomicSet<EncodedGraph> callerEncodedGraphs = callerScope.encodedGraphs;
            callerEncodedGraphs.addAll(calleeScope.encodedGraphs);
            callerEncodedGraphs.add((Object)calleeScope.encodedGraph);
        }
    }
}

