/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;

public class ConstantTypeState
extends SingleTypeState {
    protected final JavaConstant constant;

    public ConstantTypeState(PointsToAnalysis bb, AnalysisType type, JavaConstant constant) {
        super(bb, false, type);
        assert (!bb.analysisPolicy().isContextSensitiveAnalysis()) : "The ConstantTypeState is indented to be used with a context insensitive analysis.";
        this.constant = constant;
    }

    protected ConstantTypeState(PointsToAnalysis bb, boolean canBeNull, ConstantTypeState other) {
        super(bb, canBeNull, other);
        this.constant = other.constant;
    }

    public JavaConstant getConstant() {
        return this.constant;
    }

    @Override
    public TypeState forCanBeNull(PointsToAnalysis bb, boolean stateCanBeNull) {
        if (stateCanBeNull == this.canBeNull()) {
            return this;
        }
        return new ConstantTypeState(bb, stateCanBeNull, this);
    }

    private AnalysisObject getAnalysisObject() {
        return this.type.getContextInsensitiveAnalysisObject();
    }

    @Override
    public Iterator<AnalysisObject> objectsIterator(BigBang bb) {
        return ConstantTypeState.singletonIterator(this.getAnalysisObject());
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(AnalysisType t) {
        return this.type.equals(t) ? ConstantTypeState.singletonIterator(this.getAnalysisObject()) : Collections.emptyIterator();
    }

    @Override
    public void noteMerge(PointsToAnalysis bb) {
        AnalysisError.shouldNotReachHere("ConstantTypeState doesn't support merging. It is indented to be used with a context insensitive analysis.");
    }

    @Override
    public JavaConstant asConstant() {
        return this.constant;
    }

    @Override
    public int hashCode() {
        return this.constant.hashCode() * 31;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConstantTypeState) {
            ConstantTypeState that = (ConstantTypeState)obj;
            return this.canBeNull == that.canBeNull && this.merged == that.merged && this.exactType().equals(that.exactType()) && Objects.equals(this.constant, that.constant);
        }
        return false;
    }

    @Override
    public String toString() {
        return "ConstantObject<" + this.constant.toString() + ">";
    }
}

