/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.constraints.UnresolvedElementException;
import com.oracle.graal.pointsto.infrastructure.ConstantPoolPatch;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.BootstrapMethodIntrospection;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class WrappedConstantPool
implements ConstantPool,
ConstantPoolPatch {
    protected final Universe universe;
    protected final ConstantPool wrapped;
    private final ResolvedJavaType defaultAccessingClass;
    private static final Method cpLookupBootstrapMethodInvocation = ReflectionUtil.lookupMethod((boolean)true, ConstantPool.class, (String)"lookupBootstrapMethodInvocation", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
    private static final Method lookupMethodWithCaller = ReflectionUtil.lookupMethod((boolean)true, ConstantPool.class, (String)"lookupMethod", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, ResolvedJavaMethod.class});
    private static final Class<?> bsmClass = ReflectionUtil.lookupClass((boolean)true, (String)"jdk.vm.ci.meta.ConstantPool$BootstrapMethodInvocation");
    private static final Method bsmGetMethod = bsmClass == null ? null : ReflectionUtil.lookupMethod(bsmClass, (String)"getMethod", (Class[])new Class[0]);
    private static final Method bsmIsInvokeDynamic = bsmClass == null ? null : ReflectionUtil.lookupMethod(bsmClass, (String)"isInvokeDynamic", (Class[])new Class[0]);
    private static final Method bsmGetName = bsmClass == null ? null : ReflectionUtil.lookupMethod(bsmClass, (String)"getName", (Class[])new Class[0]);
    private static final Method bsmGetType = bsmClass == null ? null : ReflectionUtil.lookupMethod(bsmClass, (String)"getType", (Class[])new Class[0]);
    private static final Method bsmGetStaticArguments = bsmClass == null ? null : ReflectionUtil.lookupMethod(bsmClass, (String)"getStaticArguments", (Class[])new Class[0]);

    public WrappedConstantPool(Universe universe, ConstantPool wrapped, ResolvedJavaType defaultAccessingClass) {
        this.universe = universe;
        this.wrapped = wrapped;
        this.defaultAccessingClass = defaultAccessingClass;
    }

    public int length() {
        return this.wrapped.length();
    }

    public void loadReferencedType(int cpi, int opcode, boolean initialize) {
        GraalError.guarantee((!initialize ? 1 : 0) != 0, (String)"Must not initialize classes");
        try {
            this.wrapped.loadReferencedType(cpi, opcode, initialize);
        }
        catch (Throwable ex) {
            Throwable cause = ex;
            if (cause instanceof BootstrapMethodError && cause.getCause() != null) {
                cause = cause.getCause();
            } else if (cause instanceof ExceptionInInitializerError && cause.getCause() != null) {
                cause = cause.getCause();
            }
            throw new UnresolvedElementException("Error loading a referenced type: " + cause.toString(), cause);
        }
    }

    public void loadReferencedType(int cpi, int opcode) {
        this.loadReferencedType(cpi, opcode, false);
    }

    public JavaField lookupField(int cpi, ResolvedJavaMethod method, int opcode) {
        ResolvedJavaMethod substMethod = this.universe.resolveSubstitution(((WrappedJavaMethod)method).getWrapped());
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupField(cpi, substMethod, opcode));
    }

    public JavaMethod lookupMethod(int cpi, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupMethod(cpi, opcode));
    }

    @Override
    public JavaMethod lookupMethod(int cpi, int opcode, ResolvedJavaMethod caller) {
        if (lookupMethodWithCaller == null) {
            return this.lookupMethod(cpi, opcode);
        }
        try {
            ResolvedJavaMethod substCaller = this.universe.resolveSubstitution(((WrappedJavaMethod)caller).getWrapped());
            return this.universe.lookupAllowUnresolved((JavaMethod)lookupMethodWithCaller.invoke((Object)this.wrapped, cpi, opcode, substCaller));
        }
        catch (Throwable ex) {
            Throwable cause = ex;
            if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                cause = ex.getCause();
            } else if (ex instanceof ExceptionInInitializerError && ex.getCause() != null) {
                cause = ex.getCause();
            }
            throw new UnresolvedElementException("Error loading a referenced type: " + cause.toString(), cause);
        }
    }

    public JavaType lookupType(int cpi, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupType(cpi, opcode));
    }

    public WrappedSignature lookupSignature(int cpi) {
        return this.universe.lookup(this.wrapped.lookupSignature(cpi), this.defaultAccessingClass);
    }

    public JavaConstant lookupAppendix(int cpi, int opcode) {
        return this.universe.lookup(this.wrapped.lookupAppendix(cpi, opcode));
    }

    public String lookupUtf8(int cpi) {
        return this.wrapped.lookupUtf8(cpi);
    }

    public Object lookupConstant(int cpi) {
        return this.lookupConstant(cpi, true);
    }

    @Override
    public Object lookupConstant(int cpi, boolean resolve) {
        Object con = GraalServices.lookupConstant((ConstantPool)this.wrapped, (int)cpi, (boolean)resolve);
        if (con instanceof JavaType) {
            if (con instanceof ResolvedJavaType) {
                return this.universe.lookup((JavaType)((ResolvedJavaType)con));
            }
            return con;
        }
        if (con instanceof JavaConstant) {
            return this.universe.lookup((JavaConstant)con);
        }
        if (con == null && !resolve) {
            return null;
        }
        throw JVMCIError.unimplemented();
    }

    public JavaType lookupReferencedType(int index, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupReferencedType(index, opcode));
    }

    public BootstrapMethodIntrospection lookupBootstrapMethodIntrospection(int cpi, int opcode) {
        if (cpLookupBootstrapMethodInvocation != null) {
            try {
                Object bootstrapMethodInvocation = cpLookupBootstrapMethodInvocation.invoke((Object)this.wrapped, cpi, opcode);
                return new WrappedBootstrapMethodInvocation(bootstrapMethodInvocation);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public class WrappedBootstrapMethodInvocation
    implements BootstrapMethodIntrospection {
        private final Object wrapped;

        public WrappedBootstrapMethodInvocation(Object wrapped) {
            this.wrapped = wrapped;
        }

        public ResolvedJavaMethod getMethod() {
            if (bsmGetMethod != null) {
                try {
                    return WrappedConstantPool.this.universe.lookup((JavaMethod)((ResolvedJavaMethod)bsmGetMethod.invoke(this.wrapped, new Object[0])));
                }
                catch (Throwable t) {
                    throw GraalError.shouldNotReachHere((Throwable)t);
                }
            }
            throw GraalError.shouldNotReachHere((String)"unexpected null");
        }

        public boolean isInvokeDynamic() {
            if (bsmIsInvokeDynamic != null) {
                try {
                    return (Boolean)bsmIsInvokeDynamic.invoke(this.wrapped, new Object[0]);
                }
                catch (Throwable t) {
                    throw GraalError.shouldNotReachHere((Throwable)t);
                }
            }
            throw GraalError.shouldNotReachHere((String)"unexpected null");
        }

        public String getName() {
            if (bsmGetName != null) {
                try {
                    return (String)bsmGetName.invoke(this.wrapped, new Object[0]);
                }
                catch (Throwable t) {
                    throw GraalError.shouldNotReachHere((Throwable)t);
                }
            }
            throw GraalError.shouldNotReachHere((String)"unexpected null");
        }

        public JavaConstant getType() {
            if (bsmGetType != null) {
                try {
                    return WrappedConstantPool.this.universe.lookup((JavaConstant)bsmGetType.invoke(this.wrapped, new Object[0]));
                }
                catch (Throwable t) {
                    throw GraalError.shouldNotReachHere((Throwable)t);
                }
            }
            throw GraalError.shouldNotReachHere((String)"unexpected null");
        }

        public List<JavaConstant> getStaticArguments() {
            if (bsmGetStaticArguments != null) {
                try {
                    List original = (List)bsmGetStaticArguments.invoke(this.wrapped, new Object[0]);
                    return original.stream().map(e -> WrappedConstantPool.this.universe.lookup((JavaConstant)e)).collect(Collectors.toList());
                }
                catch (Throwable t) {
                    throw GraalError.shouldNotReachHere((Throwable)t);
                }
            }
            throw GraalError.shouldNotReachHere((String)"unexpected null");
        }
    }
}

