/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.AtomicUtils;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class AnalysisMethod
extends AnalysisElement
implements WrappedJavaMethod,
GraphProvider,
OriginalMethodProvider,
MultiMethod {
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isVirtualRootMethodUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isVirtualRootMethod");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isDirectRootMethodUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isDirectRootMethod");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isInvokedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isInvoked");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isImplementationInvokedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isImplementationInvoked");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> implementationInvokedNotificationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "implementationInvokedNotifications");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isIntrinsicMethodUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isIntrinsicMethod");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isInlinedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isInlined");
    public final ResolvedJavaMethod wrapped;
    private final int id;
    private final boolean hasNeverInlineDirective;
    private final ExceptionHandler[] exceptionHandlers;
    private final LocalVariableTable localVariableTable;
    private final String name;
    private final String qualifiedName;
    protected final AnalysisType declaringClass;
    private final int parsingContextMaxDepth;
    private final MultiMethod.MultiMethodKey multiMethodKey;
    private volatile Map<MultiMethod.MultiMethodKey, MultiMethod> multiMethodMap;
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Map> MULTIMETHOD_MAP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Map.class, "multiMethodMap");
    private volatile Object isVirtualRootMethod;
    private volatile Object isDirectRootMethod;
    private Object entryPointData;
    private volatile Object isInvoked;
    private volatile Object isImplementationInvoked;
    private volatile Object implementationInvokedNotifications;
    private volatile Object isIntrinsicMethod;
    private volatile Object isInlined;
    private final AtomicReference<Object> parsedGraphCacheState = new AtomicReference<Object>(GRAPH_CACHE_UNPARSED);
    private static final Object GRAPH_CACHE_UNPARSED = "unparsed";
    private static final Object GRAPH_CACHE_CLEARED = "cleared by cleanupAfterAnalysis";
    private EncodedGraph analyzedGraph;
    protected AnalysisMethod[] implementations;
    private boolean returnsAllInstantiatedTypes;

    protected AnalysisMethod(AnalysisUniverse universe, ResolvedJavaMethod wrapped, MultiMethod.MultiMethodKey multiMethodKey, Map<MultiMethod.MultiMethodKey, MultiMethod> multiMethodMap) {
        this.wrapped = wrapped;
        this.id = universe.nextMethodId.getAndIncrement();
        this.declaringClass = universe.lookup((JavaType)wrapped.getDeclaringClass());
        this.hasNeverInlineDirective = universe.hostVM().hasNeverInlineDirective(wrapped);
        this.name = AnalysisMethod.createName(wrapped, multiMethodKey);
        this.qualifiedName = this.format("%H.%n(%P)");
        ExceptionHandler[] original = wrapped.getExceptionHandlers();
        this.exceptionHandlers = new ExceptionHandler[original.length];
        for (int i = 0; i < original.length; ++i) {
            ExceptionHandler h = original[i];
            JavaType catchType = AnalysisMethod.getCatchType(universe, wrapped, h);
            this.exceptionHandlers[i] = new ExceptionHandler(h.getStartBCI(), h.getEndBCI(), h.getHandlerBCI(), h.catchTypeCPI(), catchType);
        }
        LocalVariableTable analysisLocalVariableTable = null;
        if (wrapped.getLocalVariableTable() != null) {
            try {
                Local[] origLocals = wrapped.getLocalVariableTable().getLocals();
                Local[] newLocals = new Local[origLocals.length];
                ResolvedJavaType accessingClass = this.declaringClass.getWrapped();
                for (int i = 0; i < newLocals.length; ++i) {
                    Local origLocal = origLocals[i];
                    ResolvedJavaType origLocalType = origLocal.getType() instanceof ResolvedJavaType ? (ResolvedJavaType)origLocal.getType() : origLocal.getType().resolve(accessingClass);
                    AnalysisType type = universe.lookup((JavaType)origLocalType);
                    newLocals[i] = new Local(origLocal.getName(), (JavaType)type, origLocal.getStartBCI(), origLocal.getEndBCI(), origLocal.getSlot());
                }
                analysisLocalVariableTable = new LocalVariableTable(newLocals);
            }
            catch (UnsupportedFeatureException | LinkageError | BytecodeParser.BytecodeParserError throwable) {
                // empty catch block
            }
        }
        this.localVariableTable = analysisLocalVariableTable;
        this.multiMethodKey = multiMethodKey;
        this.multiMethodMap = multiMethodMap;
        if (((Boolean)PointstoOptions.TrackAccessChain.getValue(this.declaringClass.universe.hostVM().options())).booleanValue()) {
            this.startTrackInvocations();
        }
        this.registerSignatureTypes();
        this.parsingContextMaxDepth = (Integer)PointstoOptions.ParsingContextMaxDepth.getValue(this.declaringClass.universe.hostVM.options());
    }

    protected AnalysisMethod(AnalysisMethod original, MultiMethod.MultiMethodKey multiMethodKey) {
        this.wrapped = original.wrapped;
        this.id = original.id;
        this.declaringClass = original.declaringClass;
        this.hasNeverInlineDirective = original.hasNeverInlineDirective;
        this.exceptionHandlers = original.exceptionHandlers;
        this.localVariableTable = original.localVariableTable;
        this.parsingContextMaxDepth = original.parsingContextMaxDepth;
        this.name = AnalysisMethod.createName(this.wrapped, multiMethodKey);
        this.qualifiedName = this.format("%H.%n(%P)");
        this.multiMethodKey = multiMethodKey;
        assert (original.multiMethodMap != null);
        this.multiMethodMap = original.multiMethodMap;
        this.returnsAllInstantiatedTypes = original.returnsAllInstantiatedTypes;
        if (((Boolean)PointstoOptions.TrackAccessChain.getValue(this.declaringClass.universe.hostVM().options())).booleanValue()) {
            this.startTrackInvocations();
        }
    }

    private static String createName(ResolvedJavaMethod wrapped, MultiMethod.MultiMethodKey multiMethodKey) {
        Object aName = wrapped.getName();
        if (multiMethodKey != ORIGINAL_METHOD) {
            aName = (String)aName + "%%" + multiMethodKey;
        }
        return aName;
    }

    private void registerSignatureTypes() {
        int offset;
        boolean isStatic = Modifier.isStatic(this.getModifiers());
        int parameterCount = this.getSignature().getParameterCount(!isStatic);
        for (int i = offset = isStatic ? 0 : 1; i < parameterCount; ++i) {
            this.getSignature().getParameterType(i - offset, this.getDeclaringClass());
        }
        this.getSignature().getReturnType(this.getDeclaringClass());
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private static JavaType getCatchType(AnalysisUniverse universe, ResolvedJavaMethod wrapped, ExceptionHandler handler) {
        ResolvedJavaType resolvedCatchType;
        JavaType catchType = handler.getCatchType();
        if (catchType == null) {
            return null;
        }
        try {
            resolvedCatchType = catchType.resolve(wrapped.getDeclaringClass());
        }
        catch (LinkageError e) {
            return catchType;
        }
        return universe.lookup((JavaType)resolvedCatchType);
    }

    @Override
    protected AnalysisUniverse getUniverse() {
        return this.declaringClass.getUniverse();
    }

    public void cleanupAfterAnalysis() {
        if (this.parsedGraphCacheState.get() instanceof AnalysisParsedGraph) {
            this.parsedGraphCacheState.set(GRAPH_CACHE_CLEARED);
        }
    }

    public abstract void startTrackInvocations();

    public abstract Iterable<? extends InvokeInfo> getInvokes();

    public abstract Object getParsingReason();

    public final StackTraceElement[] getParsingContext() {
        ArrayList<StackTraceElement> trace = new ArrayList<StackTraceElement>();
        Object curr = this.getParsingReason();
        while (curr != null) {
            if (!(curr instanceof BytecodePosition)) {
                AnalysisError.guarantee(curr instanceof String, "Parsing reason should be a BytecodePosition or String: %s", curr);
                trace.add(ReportUtils.rootMethodSentinel((String)curr));
                break;
            }
            if (trace.size() > this.parsingContextMaxDepth) {
                trace.add(ReportUtils.truncatedStackTraceSentinel(this));
                break;
            }
            BytecodePosition position = (BytecodePosition)curr;
            AnalysisMethod caller = (AnalysisMethod)position.getMethod();
            trace.add(caller.asStackTraceElement(position.getBCI()));
            curr = caller.getParsingReason();
        }
        return trace.toArray(new StackTraceElement[0]);
    }

    public int getId() {
        return this.id;
    }

    public void registerAsIntrinsicMethod(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a method as intrinsic needs to provide a valid reason, found: " + reason;
        AtomicUtils.atomicSetAndRun(this, reason, isIntrinsicMethodUpdater, this::onImplementationInvoked);
    }

    public void registerAsEntryPoint(Object newEntryPointData) {
        assert (newEntryPointData != null);
        if (this.entryPointData != null && !this.entryPointData.equals(newEntryPointData)) {
            throw new UnsupportedFeatureException("Method is registered as entry point with conflicting entry point data: " + this.entryPointData + ", " + newEntryPointData);
        }
        this.entryPointData = newEntryPointData;
        this.startTrackInvocations();
    }

    public boolean registerAsInvoked(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a method as invoked needs to provide a valid reason, found: " + reason;
        return AtomicUtils.atomicSet(this, reason, isInvokedUpdater);
    }

    public boolean registerAsImplementationInvoked(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a method as implementation invoked needs to provide a valid reason, found: " + reason;
        assert (this.isImplementationInvokable());
        assert (!Modifier.isAbstract(this.getModifiers()));
        this.getDeclaringClass().registerAsReachable("declared method " + this.qualifiedName + " is registered as implementation invoked");
        return AtomicUtils.atomicSetAndRun(this, reason, isImplementationInvokedUpdater, this::onImplementationInvoked);
    }

    public void registerAsInlined(Object reason) {
        assert (reason instanceof NodeSourcePosition || reason instanceof ResolvedJavaMethod) : "Registering a method as inlined needs to provide the inline location as reason, found: " + reason;
        AtomicUtils.atomicSetAndRun(this, reason, isInlinedUpdater, this::onReachable);
    }

    public void registerImplementationInvokedCallback(Consumer<Feature.DuringAnalysisAccess> callback) {
        if (this.isImplementationInvoked()) {
            AnalysisMethod.execute(this.getUniverse(), () -> callback.accept(this.declaringClass.getUniverse().getConcurrentAnalysisAccess()));
        } else {
            AnalysisElement.ElementNotification notification = new AnalysisElement.ElementNotification(callback);
            ConcurrentLightHashSet.addElement(this, implementationInvokedNotificationsUpdater, notification);
            if (this.isImplementationInvoked()) {
                this.notifyImplementationInvokedCallback(notification);
            }
        }
    }

    private void notifyImplementationInvokedCallback(AnalysisElement.ElementNotification notification) {
        notification.notifyCallback(this.declaringClass.getUniverse(), this);
        ConcurrentLightHashSet.removeElement(this, implementationInvokedNotificationsUpdater, notification);
    }

    protected void notifyImplementationInvokedCallbacks() {
        ConcurrentLightHashSet.forEach(this, implementationInvokedNotificationsUpdater, c -> c.notifyCallback(this.declaringClass.getUniverse(), this));
        ConcurrentLightHashSet.removeElementIf(this, implementationInvokedNotificationsUpdater, AnalysisElement.ElementNotification::isNotified);
    }

    public Set<AnalysisMethod> getCallers() {
        return this.getInvokeLocations().stream().map(location -> (AnalysisMethod)location.getMethod()).collect(Collectors.toSet());
    }

    public abstract List<BytecodePosition> getInvokeLocations();

    public boolean isEntryPoint() {
        return this.entryPointData != null;
    }

    public Object getEntryPointData() {
        return this.entryPointData;
    }

    public boolean isIntrinsicMethod() {
        return AtomicUtils.isSet(this, isIntrinsicMethodUpdater);
    }

    public Object getIntrinsicMethodReason() {
        return this.isIntrinsicMethod;
    }

    public boolean registerAsVirtualRootMethod(Object reason) {
        this.getDeclaringClass().registerAsReachable("declared method " + this.qualifiedName + " is registered as virtual root");
        return AtomicUtils.atomicSet(this, reason, isVirtualRootMethodUpdater);
    }

    public boolean registerAsDirectRootMethod(Object reason) {
        this.getDeclaringClass().registerAsReachable("declared method " + this.qualifiedName + " is registered as direct root");
        return AtomicUtils.atomicSet(this, reason, isDirectRootMethodUpdater);
    }

    public boolean isVirtualRootMethod() {
        return AtomicUtils.isSet(this, isVirtualRootMethodUpdater);
    }

    public boolean isDirectRootMethod() {
        return AtomicUtils.isSet(this, isDirectRootMethodUpdater);
    }

    public boolean isSimplyImplementationInvoked() {
        return AtomicUtils.isSet(this, isImplementationInvokedUpdater);
    }

    public boolean isInvoked() {
        return this.isIntrinsicMethod() || this.isVirtualRootMethod() || this.isDirectRootMethod() || AtomicUtils.isSet(this, isInvokedUpdater);
    }

    protected Object getInvokedReason() {
        return this.isInvoked;
    }

    public boolean isImplementationInvoked() {
        return !Modifier.isAbstract(this.getModifiers()) && (this.isIntrinsicMethod() || AtomicUtils.isSet(this, isImplementationInvokedUpdater));
    }

    protected Object getImplementationInvokedReason() {
        return this.isImplementationInvoked;
    }

    public boolean isInlined() {
        return AtomicUtils.isSet(this, isInlinedUpdater);
    }

    protected Object getInlinedReason() {
        return this.isInlined;
    }

    @Override
    public boolean isReachable() {
        return this.isImplementationInvoked() || this.isInlined();
    }

    @Override
    public boolean isTriggered() {
        if (this.isReachable()) {
            return true;
        }
        return this.isClassInitializer() && this.getDeclaringClass().isInitialized();
    }

    public void onImplementationInvoked() {
        this.onReachable();
        this.notifyImplementationInvokedCallbacks();
    }

    @Override
    public void onReachable() {
        this.notifyReachabilityCallbacks(this.declaringClass.getUniverse(), new ArrayList<AnalysisFuture<Void>>());
        this.processMethodOverrides();
    }

    private void processMethodOverrides() {
        if (this.wrapped.canBeStaticallyBound() || this.isConstructor()) {
            this.notifyMethodOverride(this);
        } else if (this.declaringClass.isAnySubtypeInstantiated()) {
            this.declaringClass.forAllSuperTypes(superType -> {
                AnalysisMethod superMethod = this.findInType((AnalysisType)superType);
                if (superMethod != null) {
                    superMethod.notifyMethodOverride(this);
                }
            });
        }
    }

    private AnalysisMethod findInType(AnalysisType type) {
        try {
            return type.findMethod(this.wrapped.getName(), this.getSignature());
        }
        catch (UnsupportedFeatureException | LinkageError e) {
            return null;
        }
    }

    protected void notifyMethodOverride(AnalysisMethod override) {
        this.declaringClass.getOverrideReachabilityNotifications(this).forEach(n -> n.notifyCallback(this.getUniverse(), override));
    }

    public void registerOverrideReachabilityNotification(AnalysisElement.MethodOverrideReachableNotification notification) {
        this.declaringClass.registerOverrideReachabilityNotification(this, notification);
    }

    protected AnalysisMethod resolveInType(AnalysisType holder) {
        return this.resolveInType(holder, holder.isAnySubtypeInstantiated());
    }

    protected AnalysisMethod resolveInType(AnalysisType holder, boolean holderOrSubtypeInstantiated) {
        if (holderOrSubtypeInstantiated || this.isIntrinsicMethod()) {
            AnalysisMethod resolved;
            try {
                resolved = holder.resolveConcreteMethod(this, null);
            }
            catch (UnsupportedFeatureException e) {
                resolved = null;
            }
            return resolved;
        }
        return null;
    }

    @Override
    public ResolvedJavaMethod getWrapped() {
        return this.wrapped;
    }

    public String getName() {
        return this.name;
    }

    public WrappedSignature getSignature() {
        return this.getUniverse().lookup(this.wrapped.getSignature(), this.wrapped.getDeclaringClass());
    }

    @Override
    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        if (this.wrapped instanceof GraphProvider) {
            return ((GraphProvider)this.wrapped).buildGraph(debug, method, providers, purpose);
        }
        return null;
    }

    @Override
    public boolean allowRuntimeCompilation() {
        if (this.wrapped instanceof GraphProvider) {
            return ((GraphProvider)this.wrapped).allowRuntimeCompilation();
        }
        return true;
    }

    public byte[] getCode() {
        return this.wrapped.getCode();
    }

    public int getCodeSize() {
        return this.wrapped.getCodeSize();
    }

    public AnalysisType getDeclaringClass() {
        return this.declaringClass;
    }

    public int getMaxLocals() {
        return this.wrapped.getMaxLocals();
    }

    public int getMaxStackSize() {
        return this.wrapped.getMaxStackSize();
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.wrapped.getParameters();
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isVarArgs() {
        return this.wrapped.isVarArgs();
    }

    public boolean isBridge() {
        return this.wrapped.isBridge();
    }

    public boolean isClassInitializer() {
        return this.wrapped.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.wrapped.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        boolean result = this.wrapped.canBeStaticallyBound();
        assert (!this.isStatic() || result) : "static methods must always be statically bindable: " + this.format("%H.%n");
        return result;
    }

    public AnalysisMethod[] getImplementations() {
        assert (this.getUniverse().analysisDataValid);
        if (this.implementations == null) {
            return new AnalysisMethod[0];
        }
        return this.implementations;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.wrapped.asStackTraceElement(bci);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        return StaticAnalysisResults.NO_RESULTS;
    }

    public ConstantPool getConstantPool() {
        return this.getUniverse().lookup(this.wrapped.getConstantPool(), this.wrapped.getDeclaringClass());
    }

    public Annotation[][] getParameterAnnotations() {
        return this.wrapped.getParameterAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return this.wrapped.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        return !this.hasNeverInlineDirective();
    }

    public boolean hasNeverInlineDirective() {
        return this.hasNeverInlineDirective;
    }

    public boolean shouldBeInlined() {
        throw JVMCIError.unimplemented();
    }

    public LineNumberTable getLineNumberTable() {
        return this.wrapped.getLineNumberTable();
    }

    public String toString() {
        return "AnalysisMethod<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ", invoked: " + (this.isInvoked != null) + ", implInvoked: " + (this.isImplementationInvoked != null) + ", intrinsic: " + (this.isIntrinsicMethod != null) + ", inlined: " + (this.isInlined != null) + (this.isVirtualRootMethod() ? ", virtual root" : "") + (this.isDirectRootMethod() ? ", direct root" : "") + (this.isEntryPoint() ? ", entry point" : "") + ">";
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.localVariableTable;
    }

    public void reprofile() {
        throw JVMCIError.unimplemented();
    }

    public Constant getEncoding() {
        throw JVMCIError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        return false;
    }

    public boolean isDefault() {
        return this.wrapped.isDefault();
    }

    public SpeculationLog getSpeculationLog() {
        throw JVMCIError.shouldNotReachHere();
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public Executable getJavaMethod() {
        return OriginalMethodProvider.getJavaMethod(this.wrapped);
    }

    public AnalysisParsedGraph reparseGraph(BigBang bb) {
        return this.ensureGraphParsedHelper(bb, true);
    }

    public AnalysisParsedGraph ensureGraphParsed(BigBang bb) {
        return this.ensureGraphParsedHelper(bb, false);
    }

    private AnalysisParsedGraph ensureGraphParsedHelper(BigBang bb, boolean forceReparse) {
        Object curState;
        while (true) {
            if ((curState = this.parsedGraphCacheState.get()) == GRAPH_CACHE_UNPARSED || forceReparse && curState instanceof AnalysisParsedGraph) {
                AnalysisParsedGraph graph = this.parseGraph(bb, curState);
                if (graph == null) continue;
                return graph;
            }
            if (!(curState instanceof ReentrantLock)) break;
            this.waitOnLock((ReentrantLock)curState);
        }
        if (!forceReparse && curState instanceof AnalysisParsedGraph) {
            return (AnalysisParsedGraph)curState;
        }
        if (curState instanceof Throwable) {
            throw AnalysisError.shouldNotReachHere("parsing had failed in another thread", (Throwable)curState);
        }
        if (curState == GRAPH_CACHE_CLEARED) {
            return null;
        }
        throw AnalysisError.shouldNotReachHere("Unknown state: " + curState);
    }

    private AnalysisParsedGraph parseGraph(BigBang bb, Object expectedValue) {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            if (!this.parsedGraphCacheState.compareAndSet(expectedValue, lock)) {
                AnalysisParsedGraph analysisParsedGraph = null;
                return analysisParsedGraph;
            }
            AnalysisParsedGraph graph = AnalysisParsedGraph.parseBytecode(bb, this);
            boolean result = this.parsedGraphCacheState.compareAndSet(lock, graph);
            AnalysisError.guarantee(result, "State transition failed", new Object[0]);
            AnalysisParsedGraph analysisParsedGraph = graph;
            return analysisParsedGraph;
        }
        catch (Throwable ex) {
            this.parsedGraphCacheState.set(ex);
            throw ex;
        }
        finally {
            lock.unlock();
        }
    }

    private void waitOnLock(ReentrantLock lock) {
        AnalysisError.guarantee(!lock.isHeldByCurrentThread(), "Recursive parsing request, would lead to endless waiting loop", new Object[0]);
        lock.lock();
        try {
            AnalysisError.guarantee(this.parsedGraphCacheState.get() != lock, "Parsing must have finished in the thread that installed the lock", new Object[0]);
        }
        finally {
            lock.unlock();
        }
    }

    public StructuredGraph decodeAnalyzedGraph(DebugContext debug, Iterable<EncodedGraph.EncodedNodeReference> nodeReferences) {
        if (this.analyzedGraph == null) {
            return null;
        }
        StructuredGraph.AllowAssumptions allowAssumptions = this.getUniverse().hostVM().allowAssumptions(this);
        StructuredGraph result = new StructuredGraph.Builder(debug.getOptions(), debug, allowAssumptions).method((ResolvedJavaMethod)this).recordInlinedMethods(false).trackNodeSourcePosition(this.analyzedGraph.trackNodeSourcePosition()).build();
        GraphDecoder decoder = new GraphDecoder(AnalysisParsedGraph.HOST_ARCHITECTURE, result);
        decoder.decode(this.analyzedGraph, nodeReferences);
        switch (allowAssumptions) {
            case YES: {
                assert (this.analyzedGraph.getAssumptions().equals((Object)result.getAssumptions()));
                break;
            }
            case NO: {
                assert (this.analyzedGraph.getAssumptions() == null && result.getAssumptions() == null);
                break;
            }
        }
        return result;
    }

    public void setAnalyzedGraph(EncodedGraph analyzedGraph) {
        this.analyzedGraph = analyzedGraph;
    }

    public EncodedGraph getAnalyzedGraph() {
        return this.analyzedGraph;
    }

    public MultiMethod.MultiMethodKey getMultiMethodKey() {
        return this.multiMethodKey;
    }

    public AnalysisMethod getOrCreateMultiMethod(MultiMethod.MultiMethodKey key) {
        return this.getOrCreateMultiMethod(key, k -> {});
    }

    public AnalysisMethod getMultiMethod(MultiMethod.MultiMethodKey key) {
        if (key == this.multiMethodKey) {
            return this;
        }
        if (this.multiMethodMap == null) {
            return null;
        }
        return (AnalysisMethod)this.multiMethodMap.get(key);
    }

    public Collection<MultiMethod> getAllMultiMethods() {
        if (this.multiMethodMap == null) {
            return Collections.singleton(this);
        }
        return this.multiMethodMap.values();
    }

    public AnalysisMethod getOrCreateMultiMethod(MultiMethod.MultiMethodKey key, Consumer<AnalysisMethod> createAction) {
        if (key == this.multiMethodKey) {
            return this;
        }
        if (this.multiMethodMap == null) {
            ConcurrentHashMap<MultiMethod.MultiMethodKey, AnalysisMethod> newMultiMethodMap = new ConcurrentHashMap<MultiMethod.MultiMethodKey, AnalysisMethod>();
            newMultiMethodMap.put(this.multiMethodKey, this);
            MULTIMETHOD_MAP_UPDATER.compareAndSet(this, null, newMultiMethodMap);
        }
        return (AnalysisMethod)this.multiMethodMap.computeIfAbsent(key, k -> {
            AnalysisMethod newMethod = this.createMultiMethod(this, (MultiMethod.MultiMethodKey)k);
            createAction.accept(newMethod);
            return newMethod;
        });
    }

    public void setReturnsAllInstantiatedTypes() {
        this.returnsAllInstantiatedTypes = true;
    }

    public boolean getReturnsAllInstantiatedTypes() {
        return this.returnsAllInstantiatedTypes;
    }

    protected abstract AnalysisMethod createMultiMethod(AnalysisMethod var1, MultiMethod.MultiMethodKey var2);

    public abstract boolean isImplementationInvokable();

    public record Signature(String name, AnalysisType[] parameterTypes) {
    }
}

