/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.AnalysisReportsOptions;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.results.StaticAnalysisResultsBuilder;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.Consumer;
import org.graalvm.collections.MapCursor;

public final class StatisticsPrinter {
    private final BigBang bb;
    static final String INDENT = "   ";

    public static void print(BigBang bb, String reportsPath, String reportName) {
        StatisticsPrinter printer = new StatisticsPrinter(bb);
        Consumer<PrintWriter> consumer = printer::printStats;
        ReportUtils.report("analysis results stats", reportsPath, "analysis_stats_" + reportName, "json", consumer);
    }

    public StatisticsPrinter(BigBang bb) {
        this.bb = bb;
    }

    private void printStats(PrintWriter out) {
        int[] reachableTypes = StatisticsPrinter.getNumReachableTypes(this.bb);
        int[] reachableMethods = StatisticsPrinter.getNumReachableMethods(this.bb);
        int[] reachableFields = StatisticsPrinter.getNumReachableFields(this.bb);
        long[] typeChecksStats = StatisticsPrinter.getTypeCheckStats(this.bb);
        StatisticsPrinter.beginObject(out);
        if (((Boolean)AnalysisReportsOptions.PrintCallEdges.getValue(this.bb.getOptions())).booleanValue()) {
            int[] callEdges = StatisticsPrinter.getNumCallEdges(this.bb);
            StatisticsPrinter.print(out, "total_call_edges", callEdges[0]);
            StatisticsPrinter.print(out, "app_call_edges", callEdges[1]);
        }
        StatisticsPrinter.print(out, "total_reachable_types", reachableTypes[0]);
        StatisticsPrinter.print(out, "app_reachable_types", reachableTypes[1]);
        StatisticsPrinter.print(out, "total_reachable_methods", reachableMethods[0]);
        StatisticsPrinter.print(out, "app_reachable_methods", reachableMethods[1]);
        StatisticsPrinter.print(out, "total_reachable_fields", reachableFields[0]);
        StatisticsPrinter.print(out, "app_reachable_fields", reachableFields[1]);
        StatisticsPrinter.print(out, "total_type_checks", typeChecksStats[0]);
        StatisticsPrinter.print(out, "total_removable_type_checks", typeChecksStats[1]);
        StatisticsPrinter.print(out, "app_type_checks", typeChecksStats[2]);
        StatisticsPrinter.print(out, "app_removable_type_checks", typeChecksStats[3]);
        this.bb.printTimerStatistics(out);
        StatisticsPrinter.endObject(out);
    }

    private static PrintWriter endObject(PrintWriter out) {
        return out.format("}%n", new Object[0]);
    }

    private static PrintWriter beginObject(PrintWriter out) {
        return out.format("{%n", new Object[0]);
    }

    public static void print(PrintWriter out, String key, long value) {
        out.format("%s\"%s\": %d,%n", INDENT, key, value);
    }

    public static void print(PrintWriter out, String key, double value) {
        NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
        nf.setGroupingUsed(false);
        out.format("%s\"%s\": %s,%n", INDENT, key, nf.format(value));
    }

    public static void printLast(PrintWriter out, String key, long value) {
        out.format("%s\"%s\": %d%n", INDENT, key, value);
    }

    private static int[] getNumCallEdges(BigBang bb) {
        int callEdges = 0;
        int appCallEdges = 0;
        for (AnalysisMethod method : bb.getUniverse().getMethods()) {
            if (!method.isImplementationInvoked()) continue;
            int callers = method.getCallers().size();
            callEdges += callers;
            if (StatisticsPrinter.isRuntimeLibraryType(method.getDeclaringClass())) continue;
            appCallEdges += callers;
        }
        return new int[]{callEdges, appCallEdges};
    }

    private static int[] getNumReachableTypes(BigBang bb) {
        int reachable = 0;
        int appReachable = 0;
        for (AnalysisType type : bb.getUniverse().getTypes()) {
            if (!type.isReachable()) continue;
            ++reachable;
            if (StatisticsPrinter.isRuntimeLibraryType(type)) continue;
            ++appReachable;
        }
        return new int[]{reachable, appReachable};
    }

    private static int[] getNumReachableMethods(BigBang bb) {
        int reachable = 0;
        int appReachable = 0;
        for (AnalysisMethod method : bb.getUniverse().getMethods()) {
            if (!method.isReachable()) continue;
            ++reachable;
            if (StatisticsPrinter.isRuntimeLibraryType(method.getDeclaringClass())) continue;
            ++appReachable;
        }
        return new int[]{reachable, appReachable};
    }

    private static int[] getNumReachableFields(BigBang bb) {
        int reachable = 0;
        int appReachable = 0;
        for (AnalysisField field : bb.getUniverse().getFields()) {
            if (!field.isAccessed()) continue;
            ++reachable;
            if (StatisticsPrinter.isRuntimeLibraryType(field.getDeclaringClass())) continue;
            ++appReachable;
        }
        return new int[]{reachable, appReachable};
    }

    private static long[] getTypeCheckStats(BigBang bb) {
        if (!(bb instanceof PointsToAnalysis)) {
            return new long[4];
        }
        PointsToAnalysis pta = (PointsToAnalysis)bb;
        long totalFilters = 0L;
        long totalRemovableFilters = 0L;
        long appTotalFilters = 0L;
        long appTotalRemovableFilters = 0L;
        for (AnalysisMethod method : pta.getUniverse().getMethods()) {
            if (!method.isImplementationInvoked()) continue;
            boolean runtimeMethod = StatisticsPrinter.isRuntimeLibraryType(method.getDeclaringClass());
            MethodTypeFlow methodFlow = PointsToAnalysis.assertPointsToAnalysisMethod(method).getTypeFlow();
            if (!methodFlow.flowsGraphCreated()) continue;
            MethodFlowsGraph originalFlows = methodFlow.getMethodFlowsGraph();
            MapCursor cursor = originalFlows.getInstanceOfFlows().getEntries();
            while (cursor.advance()) {
                if (!StaticAnalysisResultsBuilder.isValidBci(cursor.getKey())) continue;
                ++totalFilters;
                InstanceOfTypeFlow originalInstanceOf = (InstanceOfTypeFlow)cursor.getValue();
                boolean isSaturated = methodFlow.isSaturated(pta, originalInstanceOf);
                TypeState instanceOfTypeState = methodFlow.foldTypeFlow(pta, originalInstanceOf);
                if (!isSaturated && instanceOfTypeState.typesCount() < 2) {
                    ++totalRemovableFilters;
                }
                if (runtimeMethod) continue;
                ++appTotalFilters;
                if (isSaturated || instanceOfTypeState.typesCount() >= 2) continue;
                ++appTotalRemovableFilters;
            }
        }
        return new long[]{totalFilters, totalRemovableFilters, appTotalFilters, appTotalRemovableFilters};
    }

    public static boolean isRuntimeLibraryType(AnalysisType type) {
        String name = type.getName();
        return name.startsWith("Ljava/") || name.startsWith("Ljavax/") || name.startsWith("Lsun/") || name.startsWith("Lcom/sun/") || name.startsWith("Lcom/oracle/") || name.startsWith("Lorg/graalvm/") || name.startsWith("Ljdk/");
    }
}

