/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import com.oracle.graal.pointsto.reports.StatisticsPrinter;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.util.ImageBuildStatistics;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;

public class TimerCollection
implements ImageBuildStatistics.TimerCollectionPrinter {
    private final Map<String, Timer> timers = new ConcurrentHashMap<String, Timer>();

    public static TimerCollection singleton() {
        return (TimerCollection)ImageSingletons.lookup(TimerCollection.class);
    }

    public Timer get(String name) {
        Timer timer = this.timers.get(name);
        GraalError.guarantee((timer != null ? 1 : 0) != 0, (String)"Timer with name %s not found.", (Object)name);
        return timer;
    }

    public Timer get(Registry type) {
        return this.timers.computeIfAbsent(type.name, name -> new Timer((String)name));
    }

    public static Timer.StopTimer createTimerAndStart(String name) {
        return TimerCollection.singleton().createTimer(name).start();
    }

    public static Timer.StopTimer createTimerAndStart(Registry type) {
        return TimerCollection.singleton().get(type).start();
    }

    public Timer createTimer(String name) {
        GraalError.guarantee((!this.timers.containsKey(name) ? 1 : 0) != 0, (String)"Name %s for a timer is already taken.", (Object)name);
        Timer timer = new Timer(name);
        this.timers.put(timer.getName(), timer);
        return timer;
    }

    public void printTimerStats(PrintWriter out) {
        Iterator<Timer> it = this.timers.values().iterator();
        while (it.hasNext()) {
            Timer timer = it.next();
            StatisticsPrinter.print(out, timer.getName() + "_time", (int)timer.getTotalTime());
            if (it.hasNext()) {
                StatisticsPrinter.print(out, timer.getName() + "_memory", timer.getTotalMemory());
                continue;
            }
            StatisticsPrinter.printLast(out, timer.getName() + "_memory", timer.getTotalMemory());
        }
    }

    public static enum Registry {
        TOTAL("total"),
        SETUP("setup"),
        CLASSLIST("classlist"),
        CLINIT("(clinit)"),
        FEATURES("(features)"),
        VERIFY_HEAP("(verify)"),
        ANALYSIS("analysis"),
        UNIVERSE("universe"),
        COMPILE_TOTAL("compile"),
        PARSE("(parse)"),
        INLINE("(inline)"),
        COMPILE("(compile)"),
        LAYOUT("layout"),
        DEBUG_INFO("dbginfo"),
        IMAGE("image"),
        WRITE("write");

        public final String name;

        private Registry(String name) {
            this.name = name;
        }
    }
}

