/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.phases;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.util.AnalysisError;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;

public abstract class InlineBeforeAnalysisPolicy {
    protected final NodePlugin[] nodePlugins;
    public static final InlineBeforeAnalysisPolicy NO_INLINING = new InlineBeforeAnalysisPolicy(new NodePlugin[0]){

        @Override
        protected boolean shouldInlineInvoke(GraphBuilderContext b, AbstractPolicyScope policyScope, ResolvedJavaMethod method, ValueNode[] args) {
            return false;
        }

        @Override
        protected InlineInvokePlugin.InlineInfo createInvokeInfo(ResolvedJavaMethod method) {
            throw AnalysisError.shouldNotReachHere("NO_INLINING policy should not try to inline");
        }

        @Override
        protected boolean needsExplicitExceptions() {
            return true;
        }

        @Override
        protected boolean tryInvocationPlugins() {
            return false;
        }

        @Override
        protected FixedWithNextNode processInvokeArgs(ResolvedJavaMethod targetMethod, FixedWithNextNode insertionPoint, ValueNode[] arguments) {
            throw AnalysisError.shouldNotReachHere("NO_INLINING policy should not try to inline");
        }

        @Override
        protected AbstractPolicyScope createRootScope() {
            return null;
        }

        @Override
        protected AbstractPolicyScope openCalleeScope(AbstractPolicyScope outer, ResolvedJavaMethod method) {
            throw AnalysisError.shouldNotReachHere("NO_INLINING policy should not try to inline");
        }
    };

    protected InlineBeforeAnalysisPolicy(NodePlugin[] nodePlugins) {
        this.nodePlugins = nodePlugins;
    }

    protected abstract boolean shouldInlineInvoke(GraphBuilderContext var1, AbstractPolicyScope var2, ResolvedJavaMethod var3, ValueNode[] var4);

    protected abstract InlineInvokePlugin.InlineInfo createInvokeInfo(ResolvedJavaMethod var1);

    protected abstract boolean needsExplicitExceptions();

    protected abstract boolean tryInvocationPlugins();

    protected abstract FixedWithNextNode processInvokeArgs(ResolvedJavaMethod var1, FixedWithNextNode var2, ValueNode[] var3);

    protected abstract AbstractPolicyScope createRootScope();

    protected abstract AbstractPolicyScope openCalleeScope(AbstractPolicyScope var1, ResolvedJavaMethod var2);

    protected boolean shouldOmitIntermediateMethodInState(ResolvedJavaMethod method) {
        return false;
    }

    public static abstract class AbstractPolicyScope {
        public final int inliningDepth;

        protected AbstractPolicyScope(int inliningDepth) {
            this.inliningDepth = inliningDepth;
        }

        public abstract boolean allowAbort();

        public abstract void commitCalleeScope(AbstractPolicyScope var1);

        public abstract void abortCalleeScope(AbstractPolicyScope var1);

        public abstract boolean processNode(AnalysisMetaAccess var1, ResolvedJavaMethod var2, Node var3);

        public abstract boolean processNonInlinedInvoke(CoreProviders var1, CallTargetNode var2);
    }
}

