/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.heap.TypeData;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.word.WordBase;

public abstract class ImageHeapScanner {
    protected final BigBang bb;
    protected final ImageHeap imageHeap;
    protected final AnalysisMetaAccess metaAccess;
    protected final AnalysisUniverse universe;
    protected final HostVM hostVM;
    protected final SnippetReflectionProvider snippetReflection;
    protected final ConstantReflectionProvider constantReflection;
    protected final ConstantReflectionProvider hostedConstantReflection;
    protected final SnippetReflectionProvider hostedSnippetReflection;
    protected ObjectScanningObserver scanningObserver;
    private static final ImageHeapConstant NULL_IMAGE_HEAP_OBJECT = new ImageHeapInstance(null, JavaConstant.NULL_POINTER, 0);

    public ImageHeapScanner(BigBang bb, ImageHeap heap, AnalysisMetaAccess aMetaAccess, SnippetReflectionProvider aSnippetReflection, ConstantReflectionProvider aConstantReflection, ObjectScanningObserver aScanningObserver) {
        this.bb = bb;
        this.imageHeap = heap;
        this.metaAccess = aMetaAccess;
        this.universe = aMetaAccess.getUniverse();
        this.hostVM = aMetaAccess.getUniverse().hostVM();
        this.snippetReflection = aSnippetReflection;
        this.constantReflection = aConstantReflection;
        this.scanningObserver = aScanningObserver;
        this.hostedConstantReflection = GraalAccess.getOriginalProviders().getConstantReflection();
        this.hostedSnippetReflection = GraalAccess.getOriginalProviders().getSnippetReflection();
    }

    public void scanEmbeddedRoot(JavaConstant root, BytecodePosition position) {
        if (this.isNonNullObjectConstant(root)) {
            ObjectScanner.EmbeddedRootScan reason = new ObjectScanner.EmbeddedRootScan(position, root);
            ImageHeapConstant value = this.getOrCreateImageHeapConstant(root, reason);
            this.markReachable(value, reason);
        }
    }

    public void onFieldRead(AnalysisField field) {
        assert (field.isRead());
        if (this.isValueAvailable(field)) {
            ObjectScanner.FieldScan reason = new ObjectScanner.FieldScan(field);
            AnalysisType declaringClass = field.getDeclaringClass();
            if (field.isStatic()) {
                JavaConstant fieldValue = declaringClass.getOrComputeData().readFieldValue(field);
                this.markReachable(fieldValue, reason);
                this.notifyAnalysis(field, null, fieldValue, reason);
            } else {
                this.postTask(() -> this.onInstanceFieldRead(field, declaringClass, reason));
            }
        }
    }

    private void onInstanceFieldRead(AnalysisField field, AnalysisType type, ObjectScanner.FieldScan reason) {
        for (AnalysisType subtype : type.getSubTypes()) {
            for (ImageHeapConstant imageHeapConstant : this.imageHeap.getReachableObjects(subtype)) {
                ImageHeapInstance imageHeapInstance = (ImageHeapInstance)imageHeapConstant;
                JavaConstant fieldValue = imageHeapInstance.readFieldValue(field);
                this.markReachable(fieldValue, reason);
                this.notifyAnalysis(field, imageHeapInstance, fieldValue, reason);
            }
            if (subtype.equals(type)) continue;
            this.onInstanceFieldRead(field, subtype, reason);
        }
    }

    public TypeData computeTypeData(AnalysisType type) {
        GraalError.guarantee((boolean)type.isReachable(), (String)"TypeData is only available for reachable types");
        ResolvedJavaField[] staticFields = type.getStaticFields();
        TypeData data = new TypeData(staticFields.length);
        for (ResolvedJavaField javaField : staticFields) {
            AnalysisField field = (AnalysisField)javaField;
            ValueSupplier<JavaConstant> rawFieldValue = this.readHostedFieldValue(field, null);
            data.setFieldTask(field, new AnalysisFuture<JavaConstant>(() -> {
                JavaConstant value = this.createFieldValue(field, rawFieldValue, new ObjectScanner.FieldScan(field));
                data.setFieldValue(field, value);
                return value;
            }));
        }
        return data;
    }

    void markTypeReachable(AnalysisType type, ObjectScanner.ScanReason reason) {
        if (this.universe.sealed() && !type.isReachable()) {
            throw AnalysisError.typeNotFound(type);
        }
        type.registerAsReachable(reason);
    }

    void markTypeInstantiated(AnalysisType type, ObjectScanner.ScanReason reason) {
        if (this.universe.sealed() && !type.isInstantiated()) {
            throw AnalysisError.typeNotFound(type);
        }
        this.universe.getBigbang().registerTypeAsInHeap(type, reason);
    }

    public JavaConstant createImageHeapConstant(JavaConstant constant, ObjectScanner.ScanReason reason) {
        if (this.isNonNullObjectConstant(constant)) {
            return this.getOrCreateImageHeapConstant(constant, reason);
        }
        return constant;
    }

    public ImageHeapConstant toImageHeapObject(JavaConstant constant, ObjectScanner.ScanReason reason) {
        assert (constant != null && this.isNonNullObjectConstant(constant));
        return this.markReachable(this.getOrCreateImageHeapConstant(constant, reason), reason, (Consumer<ObjectScanner.ScanReason>)null);
    }

    protected ImageHeapConstant getOrCreateImageHeapConstant(JavaConstant javaConstant, ObjectScanner.ScanReason reason) {
        ObjectScanner.ScanReason nonNullReason = Objects.requireNonNull(reason);
        Object existingTask = this.imageHeap.getSnapshot(javaConstant);
        if (existingTask == null) {
            if (this.universe.sealed()) {
                throw AnalysisError.shouldNotReachHere("Universe is sealed. New constant reachable: " + javaConstant.toValueString());
            }
            AnalysisFuture<ImageHeapConstant> newTask = new AnalysisFuture<ImageHeapConstant>(() -> {
                ImageHeapConstant imageHeapConstant = this.createImageHeapObject(javaConstant, nonNullReason);
                this.imageHeap.setValue(javaConstant, imageHeapConstant);
                return imageHeapConstant;
            });
            existingTask = this.imageHeap.setTask(javaConstant, newTask);
            if (existingTask == null) {
                return newTask.ensureDone();
            }
        }
        return existingTask instanceof ImageHeapConstant ? (ImageHeapConstant)existingTask : (ImageHeapConstant)((AnalysisFuture)existingTask).ensureDone();
    }

    protected ImageHeapConstant createImageHeapObject(JavaConstant constant, ObjectScanner.ScanReason reason) {
        ImageHeapConstant newImageHeapConstant;
        assert (constant.getJavaKind() == JavaKind.Object && !constant.isNull());
        Optional<JavaConstant> replaced = this.maybeReplace(constant, reason);
        if (replaced.isPresent()) {
            if (replaced.get().isNull()) {
                return NULL_IMAGE_HEAP_OBJECT;
            }
            return this.getOrCreateImageHeapConstant(replaced.get(), reason);
        }
        AnalysisType type = this.metaAccess.lookupJavaType(constant);
        if (type.isArray()) {
            Integer length = this.constantReflection.readArrayLength(constant);
            newImageHeapConstant = type.getComponentType().isPrimitive() ? new ImageHeapPrimitiveArray(type, constant, this.asObject(constant), length) : this.createImageHeapObjectArray(constant, type, length, reason);
        } else {
            newImageHeapConstant = this.createImageHeapInstance(constant, type, reason);
            AnalysisType typeFromClassConstant = (AnalysisType)this.constantReflection.asJavaType((Constant)constant);
            if (typeFromClassConstant != null) {
                this.markTypeReachable(typeFromClassConstant, reason);
            }
        }
        return newImageHeapConstant;
    }

    private ImageHeapArray createImageHeapObjectArray(JavaConstant constant, AnalysisType type, int length, ObjectScanner.ScanReason reason) {
        ImageHeapObjectArray array = new ImageHeapObjectArray((ResolvedJavaType)type, constant, length);
        ObjectScanner.ArrayScan arrayReason = new ObjectScanner.ArrayScan(type, constant, reason);
        for (int idx = 0; idx < length; ++idx) {
            JavaConstant rawElementValue = this.constantReflection.readArrayElement(constant, idx);
            int finalIdx = idx;
            array.setElementTask(idx, new AnalysisFuture<JavaConstant>(() -> {
                JavaConstant arrayElement = this.createImageHeapConstant(rawElementValue, arrayReason);
                array.setElement(finalIdx, arrayElement);
                return arrayElement;
            }));
        }
        return array;
    }

    private ImageHeapInstance createImageHeapInstance(JavaConstant constant, AnalysisType type, ObjectScanner.ScanReason reason) {
        type.registerAsReachable(reason);
        ResolvedJavaField[] instanceFields = type.getInstanceFields(true);
        ImageHeapInstance instance = new ImageHeapInstance(type, constant, instanceFields.length);
        for (ResolvedJavaField javaField : instanceFields) {
            ValueSupplier<JavaConstant> rawFieldValue;
            AnalysisField field = (AnalysisField)javaField;
            try {
                rawFieldValue = this.readHostedFieldValue(field, this.universe.toHosted(constant));
            }
            catch (InternalError | LinkageError | TypeNotPresentException e) {
                continue;
            }
            instance.setFieldTask(field, new AnalysisFuture<JavaConstant>(() -> {
                ObjectScanner.FieldScan fieldReason = new ObjectScanner.FieldScan(field, constant, reason);
                JavaConstant value = this.createFieldValue(field, instance, rawFieldValue, fieldReason);
                instance.setFieldValue(field, value);
                return value;
            }));
        }
        return instance;
    }

    private Optional<JavaConstant> maybeReplace(JavaConstant constant, ObjectScanner.ScanReason reason) {
        Object unwrapped = this.snippetReflection.asObject(Object.class, constant);
        if (unwrapped == null) {
            throw GraalError.shouldNotReachHere((String)this.formatReason("Could not unwrap constant", reason));
        }
        if (unwrapped instanceof ImageHeapConstant) {
            throw GraalError.shouldNotReachHere((String)this.formatReason("Double wrapping of constant. Most likely, the reachability analysis code itself is seen as reachable.", reason));
        }
        if (constant.getJavaKind() == JavaKind.Object) {
            try {
                Object replaced = this.universe.replaceObject(unwrapped);
                if (replaced != unwrapped) {
                    JavaConstant replacedConstant = this.universe.getSnippetReflection().forObject(replaced);
                    return Optional.of(replacedConstant);
                }
            }
            catch (UnsupportedFeatureException e) {
                ObjectScanner.unsupportedFeatureDuringConstantScan(this.universe.getBigbang(), constant, e, reason);
                return Optional.of(JavaConstant.NULL_POINTER);
            }
        }
        return Optional.empty();
    }

    JavaConstant onFieldValueReachable(AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        return this.onFieldValueReachable(field, null, ValueSupplier.eagerValue(fieldValue), reason, onAnalysisModified);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, ImageHeapInstance receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        return this.onFieldValueReachable(field, receiver, ValueSupplier.eagerValue(fieldValue), reason, onAnalysisModified);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, ImageHeapInstance receiver, ValueSupplier<JavaConstant> rawValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisError.guarantee(field.isReachable(), "Field value is only reachable when field is reachable: %s", field);
        JavaConstant fieldValue = this.createFieldValue(field, receiver, rawValue, reason);
        this.markReachable(fieldValue, reason, onAnalysisModified);
        this.notifyAnalysis(field, receiver, fieldValue, reason, onAnalysisModified);
        return fieldValue;
    }

    protected JavaConstant createFieldValue(AnalysisField field, ValueSupplier<JavaConstant> rawValue, ObjectScanner.ScanReason reason) {
        return this.createFieldValue(field, null, rawValue, reason);
    }

    protected JavaConstant createFieldValue(AnalysisField field, ImageHeapInstance receiver, ValueSupplier<JavaConstant> rawValue, ObjectScanner.ScanReason reason) {
        JavaConstant transformedValue;
        AnalysisError.guarantee(rawValue.isAvailable(), "Value not yet available for %s", field);
        try {
            transformedValue = this.transformFieldValue(field, receiver, rawValue.get());
        }
        catch (UnsupportedFeatureException e) {
            ObjectScanner.unsupportedFeatureDuringFieldScan(this.universe.getBigbang(), field, receiver, e, reason);
            transformedValue = JavaConstant.NULL_POINTER;
        }
        assert (transformedValue != null) : field.getDeclaringClass().toJavaName() + "::" + field.getName();
        return this.createImageHeapConstant(transformedValue, reason);
    }

    private void notifyAnalysis(AnalysisField field, ImageHeapInstance receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        this.notifyAnalysis(field, receiver, fieldValue, reason, null);
    }

    private void notifyAnalysis(AnalysisField field, ImageHeapInstance receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        boolean analysisModified;
        if (this.scanningObserver != null && (analysisModified = this.doNotifyAnalysis(field, receiver, fieldValue, reason)) && onAnalysisModified != null) {
            onAnalysisModified.accept(reason);
        }
    }

    private boolean doNotifyAnalysis(AnalysisField field, JavaConstant receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        boolean analysisModified = false;
        if (fieldValue.getJavaKind() == JavaKind.Object && this.hostVM.isRelocatedPointer(this.metaAccess, fieldValue)) {
            analysisModified = this.scanningObserver.forRelocatedPointerFieldValue(receiver, field, fieldValue, reason);
        } else if (fieldValue.isNull()) {
            analysisModified = this.scanningObserver.forNullFieldValue(receiver, field, reason);
        } else if (fieldValue.getJavaKind() == JavaKind.Object) {
            analysisModified = this.scanningObserver.forNonNullFieldValue(receiver, field, fieldValue, reason);
        }
        return analysisModified;
    }

    protected JavaConstant transformFieldValue(AnalysisField field, JavaConstant receiverConstant, JavaConstant originalValueConstant) {
        return originalValueConstant;
    }

    protected JavaConstant onArrayElementReachable(ImageHeapArray array, AnalysisType arrayType, JavaConstant rawElementValue, int elementIndex, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        JavaConstant elementValue = this.createImageHeapConstant(rawElementValue, reason);
        this.markReachable(elementValue, reason, onAnalysisModified);
        this.notifyAnalysis(array, arrayType, elementIndex, reason, onAnalysisModified, elementValue);
        return elementValue;
    }

    private void notifyAnalysis(ImageHeapArray array, AnalysisType arrayType, int elementIndex, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified, JavaConstant elementValue) {
        boolean analysisModified;
        if (this.scanningObserver != null && arrayType.getComponentType().getJavaKind() == JavaKind.Object && (analysisModified = this.notifyAnalysis(array, arrayType, elementValue, elementIndex, reason)) && onAnalysisModified != null) {
            onAnalysisModified.accept(reason);
        }
    }

    private boolean isNonNullObjectConstant(JavaConstant constant) {
        return constant.getJavaKind() == JavaKind.Object && constant.isNonNull() && !ImageHeapScanner.isWordType(constant, this.metaAccess);
    }

    public static boolean isWordType(JavaConstant rawElementValue, UniverseMetaAccess metaAccess) {
        return metaAccess.isInstanceOf(rawElementValue, WordBase.class);
    }

    private boolean notifyAnalysis(JavaConstant array, AnalysisType arrayType, JavaConstant elementValue, int elementIndex, ObjectScanner.ScanReason reason) {
        boolean analysisModified;
        if (elementValue.isNull()) {
            analysisModified = this.scanningObserver.forNullArrayElement(array, arrayType, elementIndex, reason);
        } else {
            if (ImageHeapScanner.isWordType(elementValue, this.metaAccess)) {
                return false;
            }
            AnalysisType elementType = this.metaAccess.lookupJavaType(elementValue);
            analysisModified = this.scanningObserver.forNonNullArrayElement(array, arrayType, elementValue, elementType, elementIndex, reason);
        }
        return analysisModified;
    }

    private JavaConstant markReachable(JavaConstant constant, ObjectScanner.ScanReason reason) {
        return this.markReachable(constant, reason, null);
    }

    private JavaConstant markReachable(JavaConstant constant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        if (this.isNonNullObjectConstant(constant)) {
            return this.markReachable((ImageHeapConstant)constant, reason, onAnalysisModified);
        }
        return constant;
    }

    private ImageHeapConstant markReachable(ImageHeapConstant imageHeapConstant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        if (imageHeapConstant.markReachable(reason)) {
            this.postTask(() -> this.onObjectReachable(imageHeapConstant, reason, onAnalysisModified));
        }
        return imageHeapConstant;
    }

    protected void onObjectReachable(ImageHeapConstant imageHeapConstant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        block3: {
            AnalysisType objectType;
            block2: {
                objectType = this.metaAccess.lookupJavaType(imageHeapConstant);
                this.imageHeap.addReachableObject(objectType, imageHeapConstant);
                this.markTypeInstantiated(objectType, reason);
                if (!(imageHeapConstant instanceof ImageHeapObjectArray)) break block2;
                ImageHeapObjectArray imageHeapArray = (ImageHeapObjectArray)imageHeapConstant;
                for (int idx = 0; idx < imageHeapArray.getLength(); ++idx) {
                    JavaConstant elementValue = imageHeapArray.readElementValue(idx);
                    this.markReachable(elementValue, reason, onAnalysisModified);
                    this.notifyAnalysis(imageHeapArray, (AnalysisType)imageHeapArray.getType(this.metaAccess), idx, reason, onAnalysisModified, elementValue);
                }
                break block3;
            }
            if (!(imageHeapConstant instanceof ImageHeapInstance)) break block3;
            ImageHeapInstance imageHeapInstance = (ImageHeapInstance)imageHeapConstant;
            for (ResolvedJavaField javaField : objectType.getInstanceFields(true)) {
                AnalysisField field = (AnalysisField)javaField;
                if (!field.isRead() || !this.isValueAvailable(field)) continue;
                JavaConstant fieldValue = imageHeapInstance.readFieldValue(field);
                this.markReachable(fieldValue, reason, onAnalysisModified);
                this.notifyAnalysis(field, imageHeapInstance, fieldValue, reason, onAnalysisModified);
            }
        }
    }

    public boolean isValueAvailable(AnalysisField field) {
        return true;
    }

    protected String formatReason(String message, ObjectScanner.ScanReason reason) {
        return message + " " + reason;
    }

    protected ValueSupplier<JavaConstant> readHostedFieldValue(AnalysisField field, JavaConstant receiver) {
        JavaConstant value = this.universe.lookup(this.hostedConstantReflection.readFieldValue(field.wrapped, receiver));
        return ValueSupplier.eagerValue(value);
    }

    public JavaConstant readFieldValue(AnalysisField field, JavaConstant receiver) {
        return this.constantReflection.readFieldValue((ResolvedJavaField)field, receiver);
    }

    protected boolean skipScanning() {
        return false;
    }

    private void maybeRunInExecutor(CompletionExecutor.DebugContextRunnable task) {
        if (this.bb.executorIsStarted()) {
            this.bb.postTask(task);
        } else {
            task.run(null);
        }
    }

    public void rescanRoot(Field reflectionField) {
        if (this.skipScanning()) {
            return;
        }
        this.maybeRunInExecutor(unused -> {
            ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)reflectionField.getDeclaringClass());
            if (type.isReachable()) {
                AnalysisField field = this.metaAccess.lookupJavaField(reflectionField);
                JavaConstant fieldValue = this.readHostedFieldValue(field, null).get();
                TypeData typeData = field.getDeclaringClass().getOrComputeData();
                AnalysisFuture<JavaConstant> fieldTask = this.patchStaticField(typeData, field, fieldValue, ObjectScanner.OtherReason.RESCAN, null);
                if (field.isRead() || field.isFolded()) {
                    this.rescanCollectionElements(fieldTask.ensureDone());
                }
            }
        });
    }

    public void rescanField(Object receiver, Field reflectionField) {
        if (this.skipScanning()) {
            return;
        }
        this.maybeRunInExecutor(unused -> {
            ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)reflectionField.getDeclaringClass());
            if (type.isReachable()) {
                JavaConstant fieldValue;
                AnalysisField field = this.metaAccess.lookupJavaField(reflectionField);
                assert (!field.isStatic());
                JavaConstant receiverConstant = this.asConstant(receiver);
                Optional<JavaConstant> replaced = this.maybeReplace(receiverConstant, ObjectScanner.OtherReason.RESCAN);
                if (replaced.isPresent()) {
                    if (replaced.get().isNull()) {
                        return;
                    }
                    receiverConstant = replaced.get();
                }
                if ((fieldValue = this.readHostedFieldValue(field, this.universe.toHosted(receiverConstant)).get()) != null) {
                    ImageHeapInstance receiverObject = (ImageHeapInstance)this.toImageHeapObject(receiverConstant, ObjectScanner.OtherReason.RESCAN);
                    AnalysisFuture<JavaConstant> fieldTask = this.patchInstanceField(receiverObject, field, fieldValue, ObjectScanner.OtherReason.RESCAN, null);
                    if (field.isRead() || field.isFolded()) {
                        this.rescanCollectionElements(fieldTask.ensureDone());
                    }
                }
            }
        });
    }

    protected AnalysisFuture<JavaConstant> patchStaticField(TypeData typeData, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisFuture<JavaConstant> task = new AnalysisFuture<JavaConstant>(() -> {
            JavaConstant value = this.onFieldValueReachable(field, fieldValue, reason, onAnalysisModified);
            typeData.setFieldValue(field, value);
            return value;
        });
        typeData.setFieldTask(field, task);
        return task;
    }

    protected AnalysisFuture<JavaConstant> patchInstanceField(ImageHeapInstance receiverObject, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisFuture<JavaConstant> task = new AnalysisFuture<JavaConstant>(() -> {
            JavaConstant value = this.onFieldValueReachable(field, receiverObject, fieldValue, reason, onAnalysisModified);
            receiverObject.setFieldValue(field, value);
            return value;
        });
        receiverObject.setFieldTask(field, task);
        return task;
    }

    protected AnalysisFuture<JavaConstant> patchArrayElement(ImageHeapObjectArray arrayObject, int index, JavaConstant elementValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisFuture<JavaConstant> task = new AnalysisFuture<JavaConstant>(() -> {
            JavaConstant value = this.onArrayElementReachable(arrayObject, (AnalysisType)arrayObject.getType(this.metaAccess), elementValue, index, reason, onAnalysisModified);
            arrayObject.setElement(index, value);
            return value;
        });
        arrayObject.setElementTask(index, task);
        return task;
    }

    public void rescanObject(Object object) {
        this.rescanObject(object, ObjectScanner.OtherReason.RESCAN);
    }

    public void rescanObject(Object object, ObjectScanner.ScanReason reason) {
        if (this.skipScanning()) {
            return;
        }
        if (object == null) {
            return;
        }
        this.maybeRunInExecutor(unused -> {
            this.doScan(this.asConstant(object), reason);
            this.rescanCollectionElements(object);
        });
    }

    private void rescanCollectionElements(JavaConstant constant) {
        if (this.isNonNullObjectConstant(constant)) {
            this.rescanCollectionElements(this.asObject(((ImageHeapConstant)constant).getHostedObject()));
        }
    }

    private void rescanCollectionElements(Object object) {
        if (object instanceof Object[]) {
            Object[] array;
            for (Object element : array = (Object[])object) {
                this.doScan(this.asConstant(element));
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            collection.forEach(e -> this.doScan(this.asConstant(e)));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            map.forEach((k, v) -> {
                this.doScan(this.asConstant(k));
                this.doScan(this.asConstant(v));
            });
        } else if (object instanceof EconomicMap) {
            this.rescanEconomicMap((EconomicMap)object);
        }
    }

    protected void rescanEconomicMap(EconomicMap<?, ?> object) {
        MapCursor cursor = object.getEntries();
        while (cursor.advance()) {
            this.doScan(this.asConstant(cursor.getKey()));
            this.doScan(this.asConstant(cursor.getValue()));
        }
    }

    void doScan(JavaConstant constant) {
        this.doScan(constant, ObjectScanner.OtherReason.RESCAN);
    }

    void doScan(JavaConstant constant, ObjectScanner.ScanReason reason) {
        JavaConstant value = this.createImageHeapConstant(constant, reason);
        this.markReachable(value, reason, null);
    }

    protected Object asObject(JavaConstant constant) {
        return this.snippetReflection.asObject(Object.class, constant);
    }

    public JavaConstant asConstant(Object object) {
        return this.snippetReflection.forObject(object);
    }

    public void cleanupAfterAnalysis() {
        this.scanningObserver = null;
    }

    public ObjectScanningObserver getScanningObserver() {
        return this.scanningObserver;
    }

    protected abstract Class<?> getClass(String var1);

    protected AnalysisType lookupJavaType(String className) {
        return this.metaAccess.lookupJavaType((Class)this.getClass(className));
    }

    protected AnalysisField lookupJavaField(String className, String fieldName) {
        return this.metaAccess.lookupJavaField(ReflectionUtil.lookupField(this.getClass(className), (String)fieldName));
    }

    public void postTask(Runnable task) {
        this.universe.getBigbang().postTask((DebugContext debug) -> task.run());
    }
}

