/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.phases.SubstrateIntrinsicGraphBuilder;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.util.ClassUtil;
import jdk.graal.compiler.api.runtime.GraalJVMCICompiler;
import jdk.graal.compiler.bytecode.Bytecode;
import jdk.graal.compiler.bytecode.ResolvedJavaMethodBytecode;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.runtime.RuntimeProvider;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.runtime.JVMCI;

public final class AnalysisParsedGraph {
    public static final Architecture HOST_ARCHITECTURE;
    private static final AnalysisParsedGraph EMPTY;
    private final EncodedGraph encodedGraph;
    private final boolean isIntrinsic;

    private AnalysisParsedGraph(EncodedGraph encodedGraph, boolean isIntrinsic) {
        this.isIntrinsic = isIntrinsic;
        this.encodedGraph = encodedGraph;
    }

    public EncodedGraph getEncodedGraph() {
        return this.encodedGraph;
    }

    public boolean isIntrinsic() {
        return this.isIntrinsic;
    }

    /*
     * Loose catch block
     */
    public static AnalysisParsedGraph parseBytecode(BigBang bb, AnalysisMethod method) {
        if (bb == null) {
            throw AnalysisError.shouldNotReachHere("BigBang object required for parsing method " + method.format("%H.%p(%n)"));
        }
        OptionValues options = bb.getOptions();
        DebugContext.Description description = new DebugContext.Description((Object)method, ClassUtil.getUnqualifiedName(method.getClass()) + ":" + method.getId());
        DebugContext debug = new DebugContext.Builder(options, (DebugHandlersFactory)new GraalDebugHandlersFactory(bb.getSnippetReflectionProvider())).description(description).build();
        try (Indent indent = debug.logAndIndent("parse graph %s", (Object)method);){
            StructuredGraph graph;
            block40: {
                AnalysisParsedGraph code;
                Object result = bb.getHostVM().parseGraph(bb, debug, method);
                if (result != HostVM.PARSING_UNHANDLED) {
                    if (result instanceof StructuredGraph) {
                        AnalysisParsedGraph analysisParsedGraph = AnalysisParsedGraph.optimizeAndEncode(bb, method, (StructuredGraph)result, false);
                        return analysisParsedGraph;
                    }
                    assert (result == HostVM.PARSING_FAILED) : result;
                    AnalysisParsedGraph analysisParsedGraph = EMPTY;
                    return analysisParsedGraph;
                }
                graph = method.buildGraph(debug, method, bb.getProviders(method), GraphProvider.Purpose.ANALYSIS);
                if (graph != null) {
                    AnalysisParsedGraph analysisParsedGraph = AnalysisParsedGraph.optimizeAndEncode(bb, method, graph, false);
                    return analysisParsedGraph;
                }
                InvocationPlugin plugin = bb.getProviders(method).getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation((ResolvedJavaMethod)method, options);
                if (plugin != null && !plugin.inlineOnly()) {
                    code = new ResolvedJavaMethodBytecode((ResolvedJavaMethod)method);
                    graph = new SubstrateIntrinsicGraphBuilder(options, debug, (CoreProviders)bb.getProviders(method), (Bytecode)code).buildGraph(plugin);
                    if (graph != null) {
                        AnalysisParsedGraph analysisParsedGraph = AnalysisParsedGraph.optimizeAndEncode(bb, method, graph, true);
                        return analysisParsedGraph;
                    }
                }
                if (method.getCode() == null) {
                    code = EMPTY;
                    return code;
                }
                graph = new StructuredGraph.Builder(options, debug).method((ResolvedJavaMethod)method).recordInlinedMethods(false).build();
                DebugContext.Scope s = debug.scope((Object)"ClosedWorldAnalysis", (Object)graph, (Object)method);
                try (Indent indent2 = debug.logAndIndent("parse graph phases");){
                    GraphBuilderConfiguration config = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)bb.getProviders(method).getGraphBuilderPlugins()).withEagerResolving(true).withUnresolvedIsError(false).withNodeSourcePosition(true).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.CheckAll).withRetainLocalVariables(true);
                    config = bb.getHostVM().updateGraphBuilderConfiguration(config, method);
                    bb.getHostVM().createGraphBuilderPhase(bb.getProviders(method), config, OptimisticOptimizations.NONE, null).apply(graph);
                }
                catch (PermanentBailoutException ex) {
                    bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, ex.getLocalizedMessage(), null, ex);
                    AnalysisParsedGraph analysisParsedGraph = EMPTY;
                    if (s != null) {
                        s.close();
                    }
                    if (indent != null) {
                        indent.close();
                    }
                    return analysisParsedGraph;
                }
                try {
                    if (s != null) {
                        s.close();
                    }
                    break block40;
                    {
                        catch (Throwable throwable) {
                            if (s != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                catch (Throwable e) {
                    throw debug.handle(e);
                }
            }
            AnalysisParsedGraph analysisParsedGraph = AnalysisParsedGraph.optimizeAndEncode(bb, method, graph, false);
            return analysisParsedGraph;
        }
    }

    private static AnalysisParsedGraph optimizeAndEncode(BigBang bb, AnalysisMethod method, StructuredGraph graph, boolean isIntrinsic) {
        AnalysisParsedGraph analysisParsedGraph;
        block8: {
            DebugContext.Scope s = graph.getDebug().scope((Object)"ClosedWorldAnalysis", (Object)graph, (Object)method);
            try {
                bb.getHostVM().methodAfterParsingHook(bb, method, graph);
                EncodedGraph encodedGraph = GraphEncoder.encodeSingleGraph((StructuredGraph)graph, (Architecture)HOST_ARCHITECTURE);
                analysisParsedGraph = new AnalysisParsedGraph(encodedGraph, isIntrinsic);
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw graph.getDebug().handle(e);
                }
            }
            s.close();
        }
        return analysisParsedGraph;
    }

    static {
        GraalJVMCICompiler compiler = (GraalJVMCICompiler)JVMCI.getRuntime().getCompiler();
        HOST_ARCHITECTURE = ((RuntimeProvider)compiler.getGraalRuntime().getCapability(RuntimeProvider.class)).getHostBackend().getTarget().arch;
        EMPTY = new AnalysisParsedGraph(null, false);
    }
}

