/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.graal.compiler.core.common.type.TypedConstant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public abstract class ImageHeapConstant
implements JavaConstant,
TypedConstant,
CompressibleConstant,
VMConstant {
    public static final VarHandle isReachableHandle = ReflectionUtil.unreflectField(ConstantData.class, (String)"isReachable", (MethodHandles.Lookup)MethodHandles.lookup());
    protected final ConstantData constantData;
    protected final boolean compressed;

    ImageHeapConstant(ConstantData constantData, boolean compressed) {
        this.constantData = constantData;
        this.compressed = compressed;
    }

    public ConstantData getConstantData() {
        return this.constantData;
    }

    public void ensureReaderInstalled() {
        if (this.constantData.hostedValuesReader != null) {
            this.constantData.hostedValuesReader.ensureDone();
        }
    }

    protected boolean isReaderInstalled() {
        return this.constantData.hostedValuesReader == null || this.constantData.hostedValuesReader.isDone();
    }

    public boolean markReachable(ObjectScanner.ScanReason reason) {
        this.ensureReaderInstalled();
        return isReachableHandle.compareAndSet(this.constantData, null, reason);
    }

    public boolean isReachable() {
        return isReachableHandle.get(this.constantData) != null;
    }

    public Object getReachableReason() {
        return this.constantData.isReachable;
    }

    static int createIdentityHashCode(JavaConstant object) {
        if (object == null) {
            return System.identityHashCode(new Object());
        }
        return -1;
    }

    public int getIdentityHashCode() {
        if (this.constantData.hostedObject != null) {
            if (this.constantData.hostedObject.isNull()) {
                return 0;
            }
            return ((TypedConstant)this.constantData.hostedObject).getIdentityHashCode();
        }
        assert (this.constantData.identityHashCode > 0) : "The Java HotSpot VM only returns positive numbers for the identity hash code, so we want to have the same restriction on Substrate VM in order to not surprise users";
        return this.constantData.identityHashCode;
    }

    public JavaConstant getHostedObject() {
        AnalysisError.guarantee(!CompressibleConstant.isCompressed((JavaConstant)this.constantData.hostedObject), "References to hosted objects should never be compressed.", new Object[0]);
        return this.constantData.hostedObject;
    }

    public boolean isBackedByHostedObject() {
        return this.constantData.hostedObject != null;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        return false;
    }

    public AnalysisType getType(MetaAccessProvider provider) {
        return this.constantData.type;
    }

    public Object asBoxedPrimitive() {
        return null;
    }

    public int asInt() {
        return 0;
    }

    public boolean asBoolean() {
        return false;
    }

    public long asLong() {
        return 0L;
    }

    public float asFloat() {
        return 0.0f;
    }

    public double asDouble() {
        return 0.0;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public String toValueString() {
        return this.constantData.type.getName();
    }

    public abstract ImageHeapConstant forObjectClone();

    public boolean equals(Object o) {
        if (o instanceof ImageHeapConstant) {
            ImageHeapConstant other = (ImageHeapConstant)o;
            return this.constantData == other.constantData && this.compressed == other.compressed;
        }
        return false;
    }

    public int hashCode() {
        return this.constantData.hashCode() + (this.compressed ? 1 : 0);
    }

    public String toString() {
        return "ImageHeapConstant<" + this.constantData.type.toJavaName() + ", reachable: " + this.isReachable() + ", reader installed: " + this.isReaderInstalled() + ", compressed: " + this.compressed + ">";
    }

    public static abstract class ConstantData {
        protected final AnalysisType type;
        private final JavaConstant hostedObject;
        private final int identityHashCode;
        AnalysisFuture<Void> hostedValuesReader;
        private volatile Object isReachable;

        ConstantData(AnalysisType type, JavaConstant object, int identityHashCode) {
            Objects.requireNonNull(type);
            this.type = type;
            this.hostedObject = CompressibleConstant.uncompress((JavaConstant)object);
            this.identityHashCode = identityHashCode;
        }

        public int hashCode() {
            return this.hostedObject != null ? this.hostedObject.hashCode() : super.hashCode();
        }
    }
}

