/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.AnnotationAccess;

public abstract class ClassInclusionPolicy {
    protected BigBang bb;
    protected final Object reason;

    public ClassInclusionPolicy(Object reason) {
        this.reason = reason;
    }

    public void setBigBang(BigBang bb) {
        this.bb = bb;
    }

    public abstract boolean isClassIncluded(Class<?> var1);

    public boolean isMethodIncluded(Executable method) {
        return !AnnotationAccess.isAnnotationPresent((AnnotatedElement)this.bb.getMetaAccess().lookupJavaMethod(method), Fold.class);
    }

    public boolean isFieldIncluded(Field field) {
        if (!this.bb.getHostVM().platformSupported(field)) {
            return false;
        }
        return this.bb.getHostVM().isFieldIncluded(this.bb, field);
    }

    public void includeClass(Class<?> cls) {
        if (Modifier.isAbstract(cls.getModifiers()) || cls.isInterface() || cls.isPrimitive()) {
            this.bb.getMetaAccess().lookupJavaType((Class)cls).registerAsReachable(this.reason);
        } else {
            this.bb.getMetaAccess().lookupJavaType((Class)cls).registerAsInstantiated(this.reason);
        }
    }

    public abstract void includeMethod(Executable var1);

    public void includeField(Field field) {
        this.bb.postTask(debug -> this.bb.addRootField(field));
    }

    protected boolean isAccessible(Member member) {
        Class<?> cls = member.getDeclaringClass();
        int modifiers = member.getModifiers();
        return this.isAccessible(cls, modifiers);
    }

    protected boolean isAccessible(Class<?> cls, int modifiers) {
        return Modifier.isPublic(modifiers) || !Modifier.isFinal(cls.getModifiers()) && !cls.isSealed() && Modifier.isProtected(modifiers);
    }

    public static class DefaultAllInclusionPolicy
    extends ClassInclusionPolicy {
        public DefaultAllInclusionPolicy(Object reason) {
            super(reason);
        }

        @Override
        public boolean isClassIncluded(Class<?> cls) {
            return true;
        }

        @Override
        public void includeMethod(Executable method) {
            this.bb.postTask(debug -> this.bb.addRootMethod(method, false, this.reason, new MultiMethod.MultiMethodKey[0]));
        }
    }

    public static class LayeredBaseImageInclusionPolicy
    extends ClassInclusionPolicy {
        public LayeredBaseImageInclusionPolicy(Object reason) {
            super(reason);
        }

        @Override
        public boolean isClassIncluded(Class<?> cls) {
            Class<?> enclosingClass = cls.getEnclosingClass();
            int classModifiers = cls.getModifiers();
            if (enclosingClass != null) {
                return this.isAccessible(enclosingClass, classModifiers) && this.isClassIncluded(enclosingClass);
            }
            return Modifier.isPublic(classModifiers);
        }

        @Override
        public boolean isMethodIncluded(Executable method) {
            return !Modifier.isAbstract(method.getModifiers()) && this.isAccessible(method) && super.isMethodIncluded(method);
        }

        @Override
        public void includeMethod(Executable method) {
            this.bb.postTask(debug -> {
                Class<?> declaringClass = method.getDeclaringClass();
                if (!Modifier.isAbstract(method.getModifiers()) && (declaringClass.isInterface() || Modifier.isAbstract(declaringClass.getModifiers()))) {
                    AnalysisMethod analysisMethod = this.bb.getMetaAccess().lookupJavaMethod(method);
                    analysisMethod.registerAsDirectRootMethod(this.reason);
                    analysisMethod.registerAsImplementationInvoked(this.reason);
                }
                this.bb.forcedAddRootMethod(method, false, this.reason, new MultiMethod.MultiMethodKey[0]);
            });
        }
    }
}

