/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.heap.ImageLayerSnapshotUtil;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.util.FileDumpingUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.spi.IdentityHashCodeProvider;
import jdk.graal.compiler.util.json.JsonWriter;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.collections.EconomicMap;

public class ImageLayerWriter {
    public static final String TYPE_SWITCH_SUBSTRING = "$$TypeSwitch";
    private final ImageLayerSnapshotUtil imageLayerSnapshotUtil;
    private ImageHeap imageHeap;
    private String[] imageInternedStrings;
    protected EconomicMap<String, Object> jsonMap = EconomicMap.create();
    protected List<Integer> constantsToRelink;
    FileInfo fileInfo;

    public ImageLayerWriter() {
        this.imageLayerSnapshotUtil = new ImageLayerSnapshotUtil();
    }

    public ImageLayerWriter(ImageLayerSnapshotUtil imageLayerSnapshotUtil) {
        this.imageLayerSnapshotUtil = imageLayerSnapshotUtil;
        this.constantsToRelink = new ArrayList<Integer>();
    }

    public void setImageInternedStrings(String[] imageInternedStrings) {
        this.imageInternedStrings = imageInternedStrings;
    }

    public void setImageHeap(ImageHeap heap) {
        this.imageHeap = heap;
    }

    protected static boolean isTypeSwitch(AnalysisType type) {
        return type.toJavaName().contains(TYPE_SWITCH_SUBSTRING);
    }

    public void setFileInfo(Path layerSnapshotPath, String fileName, String suffix) {
        this.fileInfo = new FileInfo(layerSnapshotPath, fileName, suffix);
    }

    public void dumpFile() {
        FileDumpingUtil.dumpFile((Path)this.fileInfo.layerSnapshotPath, (String)this.fileInfo.fileName, (String)this.fileInfo.suffix, writer -> {
            try (JsonWriter jw = new JsonWriter((Writer)writer);){
                jw.print(this.jsonMap);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void persistImageHeapSize(long imageHeapSize) {
        this.jsonMap.put((Object)"image heap size", (Object)String.valueOf(imageHeapSize));
    }

    public void persistAnalysisInfo(Universe hostedUniverse, AnalysisUniverse analysisUniverse) {
        this.persistHook(hostedUniverse, analysisUniverse);
        this.jsonMap.put((Object)"next type id", (Object)analysisUniverse.getNextTypeId());
        this.jsonMap.put((Object)"next method id", (Object)analysisUniverse.getNextMethodId());
        this.jsonMap.put((Object)"next field id", (Object)analysisUniverse.getNextFieldId());
        EconomicMap typesMap = EconomicMap.create();
        for (AnalysisType analysisType : analysisUniverse.getTypes().stream().filter(t -> t.isReachable() && !ImageLayerWriter.isTypeSwitch(t)).toList()) {
            this.checkTypeStability(analysisType);
            this.persistType((EconomicMap<String, Object>)typesMap, analysisType, analysisUniverse);
        }
        this.jsonMap.put((Object)"types", (Object)typesMap);
        EconomicMap methodsMap = EconomicMap.create();
        for (AnalysisMethod analysisMethod : analysisUniverse.getMethods().stream().filter(m -> m.isReachable() && !ImageLayerWriter.isTypeSwitch(m.getDeclaringClass())).toList()) {
            this.persistMethod((EconomicMap<String, Object>)methodsMap, analysisMethod);
        }
        this.jsonMap.put((Object)"methods", (Object)methodsMap);
        EconomicMap economicMap = EconomicMap.create();
        for (AnalysisField field : analysisUniverse.getFields().stream().filter(AnalysisField::isReachable).toList()) {
            this.persistField((EconomicMap<String, EconomicMap<String, Object>>)economicMap, field, hostedUniverse);
        }
        this.jsonMap.put((Object)"fields", (Object)economicMap);
        EconomicMap economicMap2 = EconomicMap.create();
        for (Map.Entry<AnalysisType, Set<ImageHeapConstant>> entry : this.imageHeap.getReachableObjects().entrySet()) {
            for (ImageHeapConstant imageHeapConstant : entry.getValue()) {
                this.persistConstant(analysisUniverse, imageHeapConstant, (EconomicMap<String, Object>)economicMap2);
            }
        }
        this.jsonMap.put((Object)"constants", (Object)economicMap2);
        this.jsonMap.put((Object)"constants to relink", this.constantsToRelink);
    }

    protected void persistHook(Universe hostedUniverse, AnalysisUniverse analysisUniverse) {
    }

    private void persistType(EconomicMap<String, Object> typesMap, AnalysisType type, AnalysisUniverse analysisUniverse) {
        String typeIdentifier = this.imageLayerSnapshotUtil.getTypeIdentifier(type);
        EconomicMap typeMap = EconomicMap.create();
        this.persistType(type, analysisUniverse, (EconomicMap<String, Object>)typeMap);
        if (typesMap.containsKey((Object)typeIdentifier)) {
            throw GraalError.shouldNotReachHere((String)("The type identifier should be unique, but " + typeIdentifier + " got added twice."));
        }
        typesMap.put((Object)typeIdentifier, (Object)typeMap);
    }

    protected void persistType(AnalysisType type, AnalysisUniverse analysisUniverse, EconomicMap<String, Object> typeMap) {
        typeMap.put((Object)"id", (Object)type.getId());
        ArrayList<Integer> fields = new ArrayList<Integer>();
        for (ResolvedJavaField field : type.getInstanceFields(true)) {
            fields.add(((AnalysisField)field).getId());
        }
        typeMap.put((Object)"fields", fields);
        typeMap.put((Object)"class java name", (Object)type.toJavaName());
        typeMap.put((Object)"class name", (Object)type.getName());
        typeMap.put((Object)"modifiers", (Object)type.getModifiers());
        typeMap.put((Object)"is interface", (Object)type.isInterface());
        typeMap.put((Object)"is enum", (Object)type.isEnum());
        typeMap.put((Object)"is initialized", (Object)type.isInitialized());
        typeMap.put((Object)"is linked", (Object)type.isLinked());
        typeMap.put((Object)"source file name", (Object)type.getSourceFileName());
        if (type.getEnclosingType() != null) {
            typeMap.put((Object)"enclosing type", (Object)type.getEnclosingType().getId());
        }
        if (type.isArray()) {
            typeMap.put((Object)"component type", (Object)type.getComponentType().getId());
        }
        if (type.getSuperclass() != null) {
            typeMap.put((Object)"super class", (Object)type.getSuperclass().getId());
        }
        typeMap.put((Object)"interfaces", Arrays.stream(type.getInterfaces()).map(AnalysisType::getId).toList());
    }

    public void checkTypeStability(AnalysisType type) {
    }

    public void persistMethod(EconomicMap<String, Object> methodsMap, AnalysisMethod method) {
        EconomicMap methodMap = EconomicMap.create();
        methodMap.put((Object)"id", (Object)method.getId());
        String name = this.imageLayerSnapshotUtil.getMethodIdentifier(method);
        if (methodsMap.containsKey((Object)name)) {
            throw GraalError.shouldNotReachHere((String)("The method identifier should be unique, but " + name + " got added twice."));
        }
        methodsMap.put((Object)name, (Object)methodMap);
    }

    private void persistField(EconomicMap<String, EconomicMap<String, Object>> fieldsMap, AnalysisField field, Universe hostedUniverse) {
        EconomicMap fieldMap = EconomicMap.create();
        this.persistField(field, hostedUniverse, (EconomicMap<String, Object>)fieldMap);
        String tid = String.valueOf(field.getDeclaringClass().getId());
        if (fieldsMap.containsKey((Object)tid)) {
            ((EconomicMap)fieldsMap.get((Object)tid)).put((Object)field.getName(), (Object)fieldMap);
        } else {
            EconomicMap typeFieldsMap = EconomicMap.create();
            typeFieldsMap.put((Object)field.getName(), (Object)fieldMap);
            fieldsMap.put((Object)tid, (Object)typeFieldsMap);
        }
    }

    protected void persistField(AnalysisField field, Universe hostedUniverse, EconomicMap<String, Object> fieldMap) {
        fieldMap.put((Object)"id", (Object)field.getId());
        fieldMap.put((Object)"accessed", (Object)(field.getAccessedReason() != null ? 1 : 0));
        fieldMap.put((Object)"read", (Object)(field.getReadReason() != null ? 1 : 0));
        fieldMap.put((Object)"written", (Object)(field.getWrittenReason() != null ? 1 : 0));
        fieldMap.put((Object)"folded", (Object)(field.getFoldedReason() != null ? 1 : 0));
    }

    private void persistConstant(AnalysisUniverse analysisUniverse, ImageHeapConstant imageHeapConstant, EconomicMap<String, Object> constantsMap) {
        if (imageHeapConstant.isReaderInstalled() && !constantsMap.containsKey((Object)Integer.toString(this.getConstantId(imageHeapConstant)))) {
            EconomicMap constantMap = EconomicMap.create();
            this.persistConstant(analysisUniverse, imageHeapConstant, (EconomicMap<String, Object>)constantMap, constantsMap);
        }
    }

    protected void persistConstant(AnalysisUniverse analysisUniverse, ImageHeapConstant imageHeapConstant, EconomicMap<String, Object> constantMap, EconomicMap<String, Object> constantsMap) {
        constantsMap.put((Object)Integer.toString(this.getConstantId(imageHeapConstant)), constantMap);
        constantMap.put((Object)"tid", (Object)imageHeapConstant.getType().getId());
        IdentityHashCodeProvider identityHashCodeProvider = (IdentityHashCodeProvider)analysisUniverse.getBigbang().getConstantReflectionProvider();
        int identityHashCode = identityHashCodeProvider.identityHashCode((JavaConstant)imageHeapConstant);
        constantMap.put((Object)"identityHashCode", (Object)identityHashCode);
        ImageHeapConstant imageHeapConstant2 = imageHeapConstant;
        Objects.requireNonNull(imageHeapConstant2);
        ImageHeapConstant imageHeapConstant3 = imageHeapConstant2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImageHeapInstance.class, ImageHeapObjectArray.class, ImageHeapPrimitiveArray.class}, (Object)imageHeapConstant3, n)) {
            case 0: {
                ImageHeapInstance imageHeapInstance = (ImageHeapInstance)imageHeapConstant3;
                this.persistConstant(analysisUniverse, constantsMap, constantMap, "instance", imageHeapInstance.getFieldValues());
                this.persistConstantRelinkingInfo(constantMap, imageHeapConstant, analysisUniverse.getBigbang());
                break;
            }
            case 1: {
                ImageHeapObjectArray imageHeapObjectArray = (ImageHeapObjectArray)imageHeapConstant3;
                this.persistConstant(analysisUniverse, constantsMap, constantMap, "array", imageHeapObjectArray.getElementValues());
                break;
            }
            case 2: {
                ImageHeapPrimitiveArray imageHeapPrimitiveArray = (ImageHeapPrimitiveArray)imageHeapConstant3;
                constantMap.put((Object)"constant type", (Object)"primitive array");
                constantMap.put((Object)"data", ImageLayerWriter.getString(imageHeapPrimitiveArray.getType().getComponentType().getJavaKind(), imageHeapPrimitiveArray.getArray()));
                break;
            }
            default: {
                throw AnalysisError.shouldNotReachHere("Unexpected constant type " + String.valueOf(imageHeapConstant));
            }
        }
    }

    protected int getConstantId(ImageHeapConstant imageHeapConstant) {
        return imageHeapConstant.constantData.id;
    }

    public void persistConstantRelinkingInfo(EconomicMap<String, Object> constantMap, ImageHeapConstant imageHeapConstant, BigBang bb) {
        Class<?> clazz = imageHeapConstant.getType().getJavaClass();
        JavaConstant hostedObject = imageHeapConstant.getHostedObject();
        boolean simulated = hostedObject == null;
        constantMap.put((Object)"simulated", (Object)simulated);
        if (!simulated) {
            this.persistConstantRelinkingInfo(constantMap, bb, clazz, hostedObject, imageHeapConstant.constantData.id);
        }
    }

    @SuppressFBWarnings(value={"ES"}, justification="Reference equality check needed to detect intern status")
    public void persistConstantRelinkingInfo(EconomicMap<String, Object> constantMap, BigBang bb, Class<?> clazz, JavaConstant hostedObject, int id) {
        if (clazz.equals(String.class)) {
            String value = (String)bb.getSnippetReflectionProvider().asObject(String.class, hostedObject);
            int stringIndex = Arrays.binarySearch(this.imageInternedStrings, value);
            if (stringIndex >= 0 && this.imageInternedStrings[stringIndex] == value) {
                constantMap.put((Object)"value", (Object)value);
                this.constantsToRelink.add(id);
            }
        } else if (Enum.class.isAssignableFrom(clazz)) {
            Enum value = (Enum)bb.getSnippetReflectionProvider().asObject(Enum.class, hostedObject);
            constantMap.put((Object)"enum class", (Object)value.getDeclaringClass().getName());
            constantMap.put((Object)"enum name", (Object)value.name());
            this.constantsToRelink.add(id);
        }
    }

    private static List<?> getString(JavaKind kind, Object arrayObject) {
        return switch (kind) {
            case JavaKind.Boolean -> IntStream.range(0, ((boolean[])arrayObject).length).mapToObj(idx -> ((boolean[])arrayObject)[idx]).toList();
            case JavaKind.Byte -> IntStream.range(0, ((byte[])arrayObject).length).mapToObj(idx -> ((byte[])arrayObject)[idx]).toList();
            case JavaKind.Short -> IntStream.range(0, ((short[])arrayObject).length).mapToObj(idx -> ((short[])arrayObject)[idx]).toList();
            case JavaKind.Char -> new String((char[])arrayObject).chars().boxed().toList();
            case JavaKind.Int -> Arrays.stream((int[])arrayObject).boxed().toList();
            case JavaKind.Long -> Arrays.stream((long[])arrayObject).mapToObj(String::valueOf).toList();
            case JavaKind.Float -> IntStream.range(0, ((float[])arrayObject).length).mapToObj(idx -> String.valueOf(((float[])arrayObject)[idx])).toList();
            case JavaKind.Double -> Arrays.stream((double[])arrayObject).mapToObj(String::valueOf).toList();
            default -> throw new IllegalArgumentException("Unsupported kind: " + String.valueOf(kind));
        };
    }

    protected void persistConstant(AnalysisUniverse analysisUniverse, EconomicMap<String, Object> constantsMap, EconomicMap<String, Object> constantMap, String constantType, Object[] values) {
        constantMap.put((Object)"constant type", (Object)constantType);
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        for (Object object : values) {
            if (this.delegateProcessing(data, object)) continue;
            if (object instanceof ImageHeapConstant) {
                ImageHeapConstant imageHeapConstant = (ImageHeapConstant)object;
                data.add(List.of("A", Integer.valueOf(this.getConstantId(imageHeapConstant))));
                this.persistConstant(analysisUniverse, imageHeapConstant, constantsMap);
                continue;
            }
            if (object == JavaConstant.NULL_POINTER) {
                data.add(List.of("A", Integer.valueOf(-1)));
                continue;
            }
            if (object instanceof PrimitiveConstant) {
                PrimitiveConstant primitiveConstant = (PrimitiveConstant)object;
                JavaKind kind = primitiveConstant.getJavaKind();
                data.add(List.of(Character.valueOf(kind.getTypeChar()), ImageLayerWriter.getPrimitiveConstantValue(primitiveConstant, kind)));
                continue;
            }
            AnalysisError.guarantee(object instanceof AnalysisFuture, "Unexpected constant %s", object);
            data.add(List.of("A", Integer.valueOf(-2)));
        }
        constantMap.put((Object)"data", data);
    }

    private static Object getPrimitiveConstantValue(PrimitiveConstant primitiveConstant, JavaKind kind) {
        return switch (kind) {
            case JavaKind.Boolean, JavaKind.Byte, JavaKind.Short, JavaKind.Int, JavaKind.Double -> primitiveConstant.getRawValue();
            case JavaKind.Char, JavaKind.Long, JavaKind.Float -> String.valueOf(primitiveConstant.getRawValue());
            default -> throw new IllegalArgumentException("Unsupported kind: " + String.valueOf(kind));
        };
    }

    protected boolean delegateProcessing(List<List<Object>> data, Object constant) {
        return false;
    }

    private record FileInfo(Path layerSnapshotPath, String fileName, String suffix) {
    }
}

