/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedMetaAccess;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;

public abstract class UniverseMetaAccess
implements WrappedMetaAccess {
    private final Function<Class<?>, ResolvedJavaType> computeJavaType = new Function<Class<?>, ResolvedJavaType>(){

        @Override
        public ResolvedJavaType apply(Class<?> clazz) {
            return UniverseMetaAccess.this.universe.lookup((JavaType)UniverseMetaAccess.this.wrapped.lookupJavaType(clazz));
        }
    };
    protected final Universe universe;
    protected final MetaAccessProvider wrapped;
    private final ConcurrentHashMap<Class<?>, ResolvedJavaType> typeCache = new ConcurrentHashMap(2000);

    public UniverseMetaAccess(Universe universe, MetaAccessProvider wrapped) {
        this.universe = universe;
        this.wrapped = wrapped;
    }

    @Override
    public MetaAccessProvider getWrapped() {
        return this.wrapped;
    }

    public Universe getUniverse() {
        return this.universe;
    }

    public ResolvedJavaType lookupJavaType(Class<?> clazz) {
        return this.typeCache.computeIfAbsent(clazz, this.computeJavaType);
    }

    public boolean isInstanceOf(JavaConstant constant, Class<?> clazz) {
        if (constant == null || constant.isNull() || constant.getJavaKind().isPrimitive()) {
            return false;
        }
        return this.lookupJavaType(clazz).isAssignableFrom(this.lookupJavaType(constant));
    }

    public boolean isInstanceOf(JavaConstant constant, ResolvedJavaType type) {
        if (constant == null || constant.isNull()) {
            return false;
        }
        return type.isAssignableFrom(this.lookupJavaType(constant));
    }

    protected ResolvedJavaType getTypeCacheEntry(Class<?> clazz) {
        return this.typeCache.get(clazz);
    }

    public ResolvedJavaMethod lookupJavaMethod(Executable reflectionMethod) {
        return this.universe.lookup((JavaMethod)this.wrapped.lookupJavaMethod(reflectionMethod));
    }

    public ResolvedJavaField lookupJavaField(Field reflectionField) {
        return this.universe.lookup((JavaField)this.wrapped.lookupJavaField(reflectionField));
    }

    public Signature parseMethodDescriptor(String methodDescriptor) {
        throw JVMCIError.unimplemented();
    }

    public JavaConstant encodeDeoptActionAndReason(DeoptimizationAction action, DeoptimizationReason reason, int speculationId) {
        throw JVMCIError.unimplemented();
    }

    public DeoptimizationAction decodeDeoptAction(JavaConstant constant) {
        throw JVMCIError.unimplemented();
    }

    public DeoptimizationReason decodeDeoptReason(JavaConstant constant) {
        throw JVMCIError.unimplemented();
    }

    public int decodeDebugId(JavaConstant constant) {
        throw JVMCIError.unimplemented();
    }

    public long getMemorySize(JavaConstant constant) {
        throw JVMCIError.unimplemented();
    }

    public JavaConstant encodeSpeculation(SpeculationLog.Speculation speculation) {
        throw JVMCIError.unimplemented();
    }

    public SpeculationLog.Speculation decodeSpeculation(JavaConstant constant, SpeculationLog speculationLog) {
        throw JVMCIError.unimplemented();
    }
}

