/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.Consumer;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class ReportUtils {
    public static final String CONNECTING_INDENT = "\u2502   ";
    public static final String EMPTY_INDENT = "    ";
    public static final String CHILD = "\u251c\u2500\u2500 ";
    public static final String LAST_CHILD = "\u2514\u2500\u2500 ";
    public static final Comparator<ResolvedJavaMethod> methodComparator = Comparator.comparing(m -> m.format("%H.%n(%P):%R"));
    static final Comparator<AnalysisField> fieldComparator = Comparator.comparing(f -> f.format("%H.%n"));
    static final Comparator<InvokeInfo> invokeInfoBCIComparator = Comparator.comparing(i -> i.getPosition().getBCI());
    static final Comparator<InvokeInfo> invokeInfoComparator = invokeInfoBCIComparator.thenComparing(i -> ReportUtils.comparingMethodNames(i.getTargetMethod()));
    static final Comparator<BytecodePosition> positionMethodComparator = Comparator.comparing(pos -> pos.getMethod().format("%H.%n(%P):%R"));
    static final Comparator<BytecodePosition> positionComparator = positionMethodComparator.thenComparing(pos -> pos.getBCI());
    static final Comparator<Object> reasonComparator = (o1, o2) -> {
        if (o1 instanceof BytecodePosition) {
            BytecodePosition p1 = (BytecodePosition)o1;
            if (o2 instanceof BytecodePosition) {
                BytecodePosition p2 = (BytecodePosition)o2;
                return positionComparator.compare(p1, p2);
            }
        }
        return o1.toString().compareTo(o2.toString());
    };
    private static final String stackTraceTruncationSentinel = "Warning: Parsing context is truncated because its depth exceeds a reasonable limit for ";

    private static String comparingMethodNames(AnalysisMethod method) {
        String methodName = method.format("%H.%n(%P):%R");
        return methodName.contains("$$Lambda$") ? methodName.replaceAll("/[0-9a-fA-Fx]*\\.", ".") : methodName;
    }

    public static Path report(String description, String path, String name, String extension, Consumer<PrintWriter> reporter) {
        return ReportUtils.report(description, path, name, extension, reporter, true);
    }

    public static Path report(String description, String path, String name, String extension, Consumer<PrintWriter> reporter, boolean enablePrint) {
        return ReportUtils.report(description, path, name, extension, reporter, enablePrint, ReportUtils.getTimeStampString());
    }

    public static Path report(String description, String path, String name, String extension, Consumer<PrintWriter> reporter, boolean enablePrint, String timeStamp) {
        String fileName = ReportUtils.timeStampedFileName(name, extension, timeStamp);
        Path reportDir = Paths.get(path, new String[0]);
        return ReportUtils.reportImpl(enablePrint, description, reportDir, fileName, reporter);
    }

    public static String timeStampedFileName(String name, String extension) {
        return ReportUtils.timeStampedFileName(name, extension, ReportUtils.getTimeStampString());
    }

    public static String timeStampedFileName(String name, String extension, String timeStamp) {
        String fileName = name + "_" + timeStamp;
        return extension.isEmpty() ? fileName : fileName + "." + extension;
    }

    public static String getTimeStampString() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        String timeStamp = LocalDateTime.now().format(formatter);
        return timeStamp;
    }

    public static File reportFile(String path, String name, String extension) {
        try {
            String fileName = ReportUtils.timeStampedFileName(name, extension);
            Path reportDir = Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
            Path filePath = reportDir.resolve(fileName);
            Files.deleteIfExists(filePath);
            return Files.createFile(filePath, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void report(String description, Path file, Consumer<PrintWriter> reporter) {
        ReportUtils.report(description, file, reporter, true);
    }

    public static Path report(String description, Path file, Consumer<PrintWriter> reporter, boolean enablePrint) {
        Path folder = file.getParent();
        Path fileName = file.getFileName();
        if (folder == null || fileName == null) {
            throw new IllegalArgumentException("File parameter must be a file, got: " + String.valueOf(file));
        }
        return ReportUtils.reportImpl(enablePrint, description, folder, fileName.toString(), reporter);
    }

    private static Path reportImpl(boolean enablePrint, String description, Path folder, String fileName, Consumer<PrintWriter> reporter) {
        try {
            Path reportDir = Files.createDirectories(folder, new FileAttribute[0]);
            Path file = reportDir.resolve(fileName);
            Files.deleteIfExists(file);
            try (FileWriter fw = new FileWriter(Files.createFile(file, new FileAttribute[0]).toFile());
                 PrintWriter writer = new PrintWriter(fw);){
                if (enablePrint) {
                    System.out.println("# Printing " + description + " to: " + String.valueOf(file));
                }
                reporter.accept(writer);
            }
            return file;
        }
        catch (IOException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    public static Path getCWDRelativePath(Path path) {
        Path cwd = Paths.get("", new String[0]).toAbsolutePath();
        try {
            return cwd.relativize(path);
        }
        catch (IllegalArgumentException e) {
            return path;
        }
    }

    public static String extractImageName(String imageName) {
        return imageName.substring(imageName.lastIndexOf(File.separatorChar) + 1);
    }

    public static void report(String description, Path file, boolean append, Consumer<OutputStream> reporter) {
        Path folder = file.getParent();
        Path fileName = file.getFileName();
        if (folder == null || fileName == null) {
            throw new IllegalArgumentException("File parameter must be a file, got: " + String.valueOf(file));
        }
        ReportUtils.reportImpl(description, folder, fileName.toString(), reporter, append);
    }

    private static void reportImpl(String description, Path folder, String fileName, Consumer<OutputStream> reporter, boolean append) {
        try {
            Path reportDir = Files.createDirectories(folder, new FileAttribute[0]);
            Path file = reportDir.resolve(fileName);
            try (OutputStream fos = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);){
                System.out.println("# Printing " + description + " to: " + String.valueOf(file));
                reporter.accept(fos);
                fos.flush();
            }
        }
        catch (IOException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    public static String parsingContext(AnalysisMethod method) {
        return ReportUtils.parsingContext(method, 0, "   ", false);
    }

    public static String parsingContext(AnalysisMethod method, String indent) {
        return ReportUtils.parsingContext(method, 0, indent, false);
    }

    public static String parsingContext(BytecodePosition context) {
        return ReportUtils.parsingContext((AnalysisMethod)context.getMethod(), context.getBCI(), "   ", true);
    }

    public static String parsingContext(AnalysisMethod method, int bci, String indent, boolean includeTarget) {
        StringBuilder msg = new StringBuilder();
        StackTraceElement[] parsingContext = method.getParsingContext();
        if (parsingContext.length > 0) {
            if (includeTarget) {
                msg.append(String.format("%n%sat %s", indent, method.asStackTraceElement(bci)));
            }
            ReportUtils.formatParsingContext(parsingContext, indent, msg);
        } else {
            msg.append(String.format(" <no parsing context available> %n", new Object[0]));
        }
        return msg.toString();
    }

    public static void formatParsingContext(StackTraceElement[] parsingContext, String indent, StringBuilder msg) {
        for (int i = 0; i < parsingContext.length; ++i) {
            StackTraceElement e = parsingContext[i];
            if (ReportUtils.isStackTraceTruncationSentinel(e)) {
                msg.append(String.format("%n%s", e.getClassName()));
                assert (i == parsingContext.length - 1) : parsingContext;
                continue;
            }
            msg.append(String.format("%n%sat %s", indent, e));
        }
        msg.append(String.format("%n", new Object[0]));
    }

    private static boolean isStackTraceTruncationSentinel(StackTraceElement element) {
        return element.getClassName().startsWith(stackTraceTruncationSentinel);
    }

    public static StackTraceElement truncatedStackTraceSentinel(AnalysisMethod method) {
        return new StackTraceElement(stackTraceTruncationSentinel + method.format("%H.%n(%p)"), "", null, -1);
    }

    public static StackTraceElement rootMethodSentinel(String reason) {
        return new StackTraceElement(reason, "", null, -1);
    }

    public static String typePropagationTrace(PointsToAnalysis bb, TypeFlow<?> flow, AnalysisType type) {
        return ReportUtils.typePropagationTrace(bb, flow, type, "   ");
    }

    public static String typePropagationTrace(PointsToAnalysis bb, TypeFlow<?> flow, AnalysisType type, String indent) {
        if (bb.trackTypeFlowInputs()) {
            StringBuilder msg = new StringBuilder(String.format("Propagation trace through type flows for type %s: %n", type.toJavaName()));
            ReportUtils.followInput(flow, type, indent, new HashSet(), msg);
            return msg.toString();
        }
        return String.format("To print the propagation trace through type flows for type %s set the -H:+TrackInputFlows option. %n", type.toJavaName());
    }

    private static void followInput(TypeFlow<?> flow, AnalysisType type, String indent, HashSet<TypeFlow<?>> seen, StringBuilder msg) {
        seen.add(flow);
        if (flow instanceof AllInstantiatedTypeFlow) {
            msg.append(String.format("AllInstantiated(%s)%n", flow.getDeclaredType().toJavaName(true)));
        } else {
            msg.append(String.format("%sat %s: %s%n", indent, flow.formatSource(), flow.format(false, false)));
            for (TypeFlow<?> input : flow.getInputs()) {
                if (seen.contains(input) || !input.getState().containsType(type)) continue;
                ReportUtils.followInput(input, type, indent, seen, msg);
                break;
            }
        }
    }
}

