/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;

public final class ImageHeapInstance
extends ImageHeapConstant {
    private static final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(Object[].class);
    public static final VarHandle valuesHandle = ReflectionUtil.unreflectField(InstanceData.class, (String)"fieldValues", (MethodHandles.Lookup)MethodHandles.lookup());

    ImageHeapInstance(AnalysisType type, JavaConstant hostedObject) {
        this(type, hostedObject, -1);
    }

    ImageHeapInstance(AnalysisType type, JavaConstant hostedObject, int identityHashCode) {
        super(new InstanceData(type, hostedObject, null, identityHashCode), false);
    }

    public ImageHeapInstance(AnalysisType type) {
        super(new InstanceData(type, null, new Object[type.getInstanceFields(true).length], -1), false);
    }

    private ImageHeapInstance(ImageHeapConstant.ConstantData data, boolean compressed) {
        super(data, compressed);
    }

    @Override
    public InstanceData getConstantData() {
        return (InstanceData)super.getConstantData();
    }

    void setFieldValues(Object[] fieldValues) {
        boolean success = valuesHandle.compareAndSet(this.constantData, null, fieldValues);
        AnalysisError.guarantee(success, "Unexpected field values reference for constant %s", this);
    }

    Object[] getFieldValues() {
        AnalysisError.guarantee(this.isReaderInstalled());
        Object[] fieldValues = this.getConstantData().fieldValues;
        AnalysisError.guarantee(fieldValues != null);
        return fieldValues;
    }

    void setFieldTask(AnalysisField field, AnalysisFuture<JavaConstant> task) {
        arrayHandle.setVolatile(this.getFieldValues(), field.getPosition(), task);
    }

    public void setFieldValue(AnalysisField field, JavaConstant value) {
        arrayHandle.setVolatile(this.getFieldValues(), field.getPosition(), value);
    }

    public Object getFieldValue(AnalysisField field) {
        if (this.isInBaseLayer()) {
            field.getType().getInstanceFields(true);
        }
        return arrayHandle.getVolatile(this.getFieldValues(), field.getPosition());
    }

    public JavaConstant readFieldValue(AnalysisField field) {
        Object value = this.getFieldValue(field);
        return value instanceof JavaConstant ? (JavaConstant)value : (JavaConstant)((AnalysisFuture)value).ensureDone();
    }

    public JavaConstant compress() {
        assert (!this.compressed) : this;
        return new ImageHeapInstance(this.constantData, true);
    }

    public JavaConstant uncompress() {
        assert (this.compressed) : this;
        return new ImageHeapInstance(this.constantData, false);
    }

    @Override
    public ImageHeapConstant forObjectClone() {
        if (!this.constantData.type.isCloneableWithAllocation()) {
            return null;
        }
        Object[] fieldValues = this.getFieldValues();
        Objects.requireNonNull(fieldValues, "Cannot clone an instance before the field values are set.");
        Object[] newFieldValues = Arrays.copyOf(fieldValues, fieldValues.length);
        return new ImageHeapInstance(new InstanceData(this.constantData.type, null, newFieldValues, -1), this.compressed);
    }

    private static final class InstanceData
    extends ImageHeapConstant.ConstantData {
        private Object[] fieldValues;

        private InstanceData(AnalysisType type, JavaConstant hostedObject, Object[] fieldValues, int identityHashCode) {
            super(type, hostedObject, identityHashCode);
            this.fieldValues = fieldValues;
            assert (!type.isArray()) : type;
        }
    }
}

