/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AtomicUtils;
import java.util.concurrent.atomic.AtomicReference;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

public class PointsToAnalysisType
extends AnalysisType {
    private final AtomicReference<OffsetStoreTypeFlow.UnsafeStoreTypeFlow> contextInsensitiveUnsafeStore = new AtomicReference();
    private final AtomicReference<OffsetStoreTypeFlow.StoreIndexedTypeFlow> contextInsensitiveIndexedStore = new AtomicReference();

    PointsToAnalysisType(AnalysisUniverse universe, ResolvedJavaType javaType, JavaKind storageKind, AnalysisType objectType, AnalysisType cloneableType) {
        super(universe, javaType, storageKind, objectType, cloneableType);
    }

    @Override
    public void registerAsAssignable(BigBang bb) {
        TypeState typeState = TypeState.forType((PointsToAnalysis)bb, this, true);
        this.forAllSuperTypes(t -> t.addAssignableType(bb, typeState), false);
        this.addAssignableType(bb, typeState);
    }

    public OffsetStoreTypeFlow.UnsafeStoreTypeFlow initAndGetContextInsensitiveUnsafeStore(PointsToAnalysis bb, BytecodePosition originalLocation) {
        return AtomicUtils.produceAndSetValue(this.contextInsensitiveUnsafeStore, () -> this.createContextInsensitiveUnsafeStore(bb, originalLocation), t -> PointsToAnalysisType.initContextInsensitiveUnsafeStore(bb, t));
    }

    private OffsetStoreTypeFlow.UnsafeStoreTypeFlow createContextInsensitiveUnsafeStore(PointsToAnalysis bb, BytecodePosition originalLocation) {
        TypeFlow<?> objectFlow = this.getTypeFlow(bb, false);
        AnalysisType componentType = bb.getObjectType();
        OffsetStoreTypeFlow.UnsafeStoreTypeFlow store = new OffsetStoreTypeFlow.UnsafeStoreTypeFlow(originalLocation, this, componentType, objectFlow, null);
        store.markAsContextInsensitive();
        return store;
    }

    private static void initContextInsensitiveUnsafeStore(PointsToAnalysis bb, OffsetStoreTypeFlow.UnsafeStoreTypeFlow store) {
        store.receiver().addObserver(bb, store);
    }

    public OffsetStoreTypeFlow.StoreIndexedTypeFlow initAndGetContextInsensitiveIndexedStore(PointsToAnalysis bb, BytecodePosition originalLocation) {
        return AtomicUtils.produceAndSetValue(this.contextInsensitiveIndexedStore, () -> this.createContextInsensitiveIndexedStore(bb, originalLocation), t -> PointsToAnalysisType.initContextInsensitiveIndexedStore(bb, t));
    }

    private OffsetStoreTypeFlow.StoreIndexedTypeFlow createContextInsensitiveIndexedStore(PointsToAnalysis bb, BytecodePosition originalLocation) {
        assert (this.isArray()) : this;
        TypeFlow<?> objectFlow = this.getTypeFlow(bb, false);
        OffsetStoreTypeFlow.StoreIndexedTypeFlow store = new OffsetStoreTypeFlow.StoreIndexedTypeFlow(originalLocation, this, objectFlow, null);
        store.markAsContextInsensitive();
        return store;
    }

    private static void initContextInsensitiveIndexedStore(PointsToAnalysis bb, OffsetStoreTypeFlow.StoreIndexedTypeFlow store) {
        store.receiver().addObserver(bb, store);
    }

    @Override
    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.contextInsensitiveUnsafeStore.set(null);
        this.contextInsensitiveIndexedStore.set(null);
    }
}

