/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.results;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.results.StrengthenGraphsCounters;
import com.oracle.graal.pointsto.typestate.PrimitiveConstantTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.util.ImageBuildStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.AnchoringNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.FieldOffsetProvider;
import jdk.graal.compiler.nodes.extended.ValueAnchorNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LimitedValueProxy;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;

public abstract class StrengthenGraphs {
    protected final BigBang bb;
    protected final Universe converter;
    private final Map<JavaTypeProfile, JavaTypeProfile> cachedTypeProfiles = new ConcurrentHashMap<JavaTypeProfile, JavaTypeProfile>();
    private final Map<JavaMethodProfile, JavaMethodProfile> cachedMethodProfiles = new ConcurrentHashMap<JavaMethodProfile, JavaMethodProfile>();
    private final int analysisSizeCutoff;
    private final boolean strengthenGraphWithConstants;
    private final StrengthenGraphsCounters beforeCounters;
    private final StrengthenGraphsCounters afterCounters;

    public StrengthenGraphs(BigBang bb, Universe converter) {
        this.bb = bb;
        this.converter = converter;
        this.analysisSizeCutoff = (Integer)PointstoOptions.AnalysisSizeCutoff.getValue(bb.getOptions());
        this.strengthenGraphWithConstants = (Boolean)Options.StrengthenGraphWithConstants.getValue(bb.getOptions());
        if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(bb.getOptions())).booleanValue()) {
            this.beforeCounters = new StrengthenGraphsCounters(ImageBuildStatistics.CheckCountLocation.BEFORE_STRENGTHEN_GRAPHS);
            this.afterCounters = new StrengthenGraphsCounters(ImageBuildStatistics.CheckCountLocation.AFTER_STRENGTHEN_GRAPHS);
        } else {
            this.beforeCounters = null;
            this.afterCounters = null;
        }
    }

    public final void applyResults(AnalysisMethod method) {
        PointsToAnalysisMethod ptaMethod;
        Iterable nodeReferences = method instanceof PointsToAnalysisMethod && (ptaMethod = (PointsToAnalysisMethod)method).getTypeFlow().flowsGraphCreated() ? ptaMethod.getTypeFlow().getMethodFlowsGraph().getNodeFlows().getKeys() : null;
        DebugContext debug = new DebugContext.Builder(this.bb.getOptions(), (DebugHandlersFactory)new GraalDebugHandlersFactory(this.bb.getSnippetReflectionProvider())).build();
        StructuredGraph graph = method.decodeAnalyzedGraph(debug, nodeReferences);
        if (graph == null) {
            return;
        }
        graph.resetDebug(debug);
        if (this.beforeCounters != null) {
            this.beforeCounters.collect(graph);
        }
        try (DebugContext.Scope s = debug.scope((Object)"StrengthenGraphs", (Object)graph);
             DebugContext.Activation a = debug.activate();){
            new AnalysisStrengthenGraphsPhase(this, method, graph).apply(graph, (Object)this.bb.getProviders(method));
        }
        catch (Throwable ex) {
            debug.handle(ex);
        }
        if (this.afterCounters != null) {
            this.afterCounters.collect(graph);
        }
        method.setAnalyzedGraph(GraphEncoder.encodeSingleGraph((StructuredGraph)graph, (Architecture)AnalysisParsedGraph.HOST_ARCHITECTURE));
        if (nodeReferences != null) {
            for (EncodedGraph.EncodedNodeReference nodeReference : nodeReferences) {
                nodeReference.clear();
            }
        }
    }

    protected abstract AnalysisType getSingleImplementorType(AnalysisType var1);

    protected abstract AnalysisType getStrengthenStampType(AnalysisType var1);

    protected abstract FixedNode createUnreachable(StructuredGraph var1, CoreProviders var2, Supplier<String> var3);

    protected abstract FixedNode createInvokeWithNullReceiverReplacement(StructuredGraph var1);

    protected abstract void setInvokeProfiles(Invoke var1, JavaTypeProfile var2, JavaMethodProfile var3);

    protected abstract String getTypeName(AnalysisType var1);

    protected abstract boolean simplifyDelegate(Node var1, SimplifierTool var2);

    protected JavaTypeProfile makeTypeProfile(TypeState typeState) {
        if (typeState == null || this.analysisSizeCutoff != -1 && typeState.typesCount() > this.analysisSizeCutoff) {
            return null;
        }
        JavaTypeProfile created = this.createTypeProfile(typeState);
        JavaTypeProfile existing = this.cachedTypeProfiles.putIfAbsent(created, created);
        return existing != null ? existing : created;
    }

    private JavaTypeProfile createTypeProfile(TypeState typeState) {
        double probability = 1.0 / (double)typeState.typesCount();
        Stream<AnalysisType> stream = typeState.typesStream(this.bb);
        if (this.converter != null) {
            stream = stream.map(this.converter::lookup).sorted(this.converter.hostVM().getTypeComparator());
        }
        JavaTypeProfile.ProfiledType[] pitems = (JavaTypeProfile.ProfiledType[])stream.map(type -> new JavaTypeProfile.ProfiledType(type, probability)).toArray(JavaTypeProfile.ProfiledType[]::new);
        return new JavaTypeProfile(TriState.get((boolean)typeState.canBeNull()), 0.0, pitems);
    }

    protected JavaMethodProfile makeMethodProfile(Collection<AnalysisMethod> callees) {
        if (this.analysisSizeCutoff != -1 && callees.size() > this.analysisSizeCutoff) {
            return null;
        }
        JavaMethodProfile created = this.createMethodProfile(callees);
        JavaMethodProfile existing = this.cachedMethodProfiles.putIfAbsent(created, created);
        return existing != null ? existing : created;
    }

    private JavaMethodProfile createMethodProfile(Collection<AnalysisMethod> callees) {
        JavaMethodProfile.ProfiledMethod[] pitems = new JavaMethodProfile.ProfiledMethod[callees.size()];
        double probability = 1.0 / (double)pitems.length;
        int idx = 0;
        for (AnalysisMethod aMethod : callees) {
            AnalysisMethod convertedMethod = this.converter == null ? aMethod : this.converter.lookup((JavaMethod)aMethod);
            pitems[idx++] = new JavaMethodProfile.ProfiledMethod((ResolvedJavaMethod)convertedMethod, probability);
        }
        return new JavaMethodProfile(0.0, pitems);
    }

    public static class Options {
        public static final OptionKey<Boolean> StrengthenGraphWithConstants = new OptionKey((Object)true);
    }

    class AnalysisStrengthenGraphsPhase
    extends BasePhase<CoreProviders> {
        final CanonicalizerPhase phase;

        AnalysisStrengthenGraphsPhase(StrengthenGraphs this$0, AnalysisMethod method, StructuredGraph graph) {
            this.phase = CanonicalizerPhase.create().copyWithCustomSimplification((CanonicalizerPhase.CustomSimplification)this$0.new StrengthenSimplifier(method, graph));
        }

        public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
            return this.phase.notApplicableTo(graphState);
        }

        protected void run(StructuredGraph graph, CoreProviders context) {
            this.phase.apply(graph, (Object)context);
        }

        public CharSequence getName() {
            return "AnalysisStrengthenGraphs";
        }
    }

    class StrengthenSimplifier
    implements CanonicalizerPhase.CustomSimplification {
        private final StructuredGraph graph;
        private final MethodTypeFlow methodFlow;
        private final NodeBitMap createdPiNodes;
        private final TypeFlow<?>[] parameterFlows;
        private final NodeMap<TypeFlow<?>> nodeFlows;
        private final boolean allowConstantFolding;
        private final boolean allowOptimizeReturnParameter;
        private final EconomicSet<ValueNode> unreachableValues = EconomicSet.create();
        private final Function<AnalysisType, ResolvedJavaType> toTargetFunction;

        StrengthenSimplifier(AnalysisMethod method, StructuredGraph graph) {
            PointsToAnalysisMethod ptaMethod;
            this.graph = graph;
            this.createdPiNodes = new NodeBitMap((Graph)graph);
            if (method instanceof PointsToAnalysisMethod && (ptaMethod = (PointsToAnalysisMethod)method).getTypeFlow().flowsGraphCreated()) {
                this.methodFlow = ptaMethod.getTypeFlow();
                MethodFlowsGraph originalFlows = this.methodFlow.getMethodFlowsGraph();
                this.parameterFlows = originalFlows.getParameters();
                this.nodeFlows = new NodeMap((Graph)graph);
                MapCursor cursor = originalFlows.getNodeFlows().getEntries();
                while (cursor.advance()) {
                    Node node = ((EncodedGraph.EncodedNodeReference)cursor.getKey()).getNode();
                    assert (this.nodeFlows.get(node) == null) : "overwriting existing entry for " + String.valueOf(node);
                    this.nodeFlows.put(node, (Object)((TypeFlow)cursor.getValue()));
                }
                this.allowConstantFolding = StrengthenGraphs.this.strengthenGraphWithConstants && StrengthenGraphs.this.bb.getHostVM().allowConstantFolding(method);
                this.allowOptimizeReturnParameter = method.isOriginalMethod() && ((PointsToAnalysis)StrengthenGraphs.this.bb).optimizeReturnedParameter();
            } else {
                this.methodFlow = null;
                this.parameterFlows = null;
                this.nodeFlows = null;
                this.allowConstantFolding = false;
                this.allowOptimizeReturnParameter = false;
            }
            this.toTargetFunction = StrengthenGraphs.this.bb.getHostVM().getStrengthenGraphsToTargetFunction(method.getMultiMethodKey());
        }

        private TypeFlow<?> getNodeFlow(Node node) {
            return this.nodeFlows == null || this.nodeFlows.isNew(node) ? null : (TypeFlow)this.nodeFlows.get(node);
        }

        public void simplify(Node n, SimplifierTool tool) {
            ValueNode node;
            if (n instanceof ValueNode && !(n instanceof LimitedValueProxy) && !(n instanceof PhiNode)) {
                node = (ValueNode)n;
                node.inferStamp();
                this.updateStampInPlace(node, this.strengthenStamp(node.stamp(NodeView.DEFAULT)), tool);
            }
            if (!StrengthenGraphs.this.simplifyDelegate(n, tool)) {
                PiNode node2;
                Stamp oldStamp;
                Stamp newStamp;
                if (n instanceof ParameterNode && this.parameterFlows != null) {
                    ParameterNode node3 = (ParameterNode)n;
                    StartNode anchorPoint = this.graph.start();
                    Object newStampOrConstant = this.strengthenStampFromTypeFlow((ValueNode)node3, this.parameterFlows[node3.index()], (FixedWithNextNode)anchorPoint, tool);
                    this.updateStampUsingPiNode((ValueNode)node3, newStampOrConstant, (FixedWithNextNode)anchorPoint, tool);
                } else if (n instanceof LoadFieldNode) {
                    AnalysisField field = (AnalysisField)(node = (LoadFieldNode)n).field();
                    FieldTypeFlow fieldTypeFlow = field.isStatic() ? field.getStaticFieldFlow() : field.getInstanceFieldFlow();
                    Object fieldNewStampOrConstant = this.strengthenStampFromTypeFlow(node, fieldTypeFlow, (FixedWithNextNode)node, tool);
                    if (fieldNewStampOrConstant instanceof JavaConstant) {
                        ConstantNode replacement = ConstantNode.forConstant((JavaConstant)((JavaConstant)fieldNewStampOrConstant), (MetaAccessProvider)StrengthenGraphs.this.bb.getMetaAccess(), (StructuredGraph)this.graph);
                        this.graph.replaceFixedWithFloating((FixedWithNextNode)node, (ValueNode)replacement);
                        tool.addToWorkList((Node)replacement);
                    } else {
                        this.updateStampInPlace(node, (Stamp)fieldNewStampOrConstant, tool);
                        Object nodeNewStampOrConstant = this.strengthenStampFromTypeFlow(node, this.getNodeFlow((Node)node), (FixedWithNextNode)node, tool);
                        this.updateStampUsingPiNode(node, nodeNewStampOrConstant, (FixedWithNextNode)node, tool);
                    }
                } else if (n instanceof LoadIndexedNode) {
                    LoadIndexedNode node4 = (LoadIndexedNode)n;
                    Object newStampOrConstant = this.strengthenStampFromTypeFlow((ValueNode)node4, this.getNodeFlow((Node)node4), (FixedWithNextNode)node4, tool);
                    this.updateStampUsingPiNode((ValueNode)node4, newStampOrConstant, (FixedWithNextNode)node4, tool);
                } else if (n instanceof Invoke) {
                    Invoke invoke = (Invoke)n;
                    if (invoke.callTarget() instanceof MethodCallTargetNode) {
                        this.handleInvoke(invoke, tool);
                    }
                } else if (n instanceof IfNode) {
                    IfNode node5 = (IfNode)n;
                    boolean trueUnreachable = this.isUnreachable((Node)node5.trueSuccessor());
                    boolean falseUnreachable = this.isUnreachable((Node)node5.falseSuccessor());
                    if (trueUnreachable && falseUnreachable) {
                        this.makeUnreachable((FixedNode)node5, (CoreProviders)tool, () -> "method " + this.graph.method().format("%H.%n(%p)") + ", node " + String.valueOf(node5) + ": both successors of IfNode are unreachable");
                    } else if (trueUnreachable || falseUnreachable) {
                        AbstractBeginNode killedBegin = node5.successor(trueUnreachable);
                        AbstractBeginNode survivingBegin = node5.successor(!trueUnreachable);
                        if (survivingBegin.hasUsages()) {
                            ValueAnchorNode anchor = (ValueAnchorNode)this.graph.add((Node)new ValueAnchorNode());
                            this.graph.addAfterFixed((FixedWithNextNode)survivingBegin, (FixedNode)anchor);
                            survivingBegin.replaceAtUsages((Node)anchor, new InputType[]{InputType.Guard, InputType.Anchor});
                        }
                        this.graph.removeSplit((ControlSplitNode)node5, survivingBegin);
                        GraphUtil.killCFG((FixedNode)killedBegin);
                    }
                } else if (n instanceof FixedGuardNode) {
                    FixedGuardNode node6 = (FixedGuardNode)n;
                    if (this.isUnreachable((Node)node6)) {
                        node6.setCondition((LogicNode)LogicConstantNode.tautology((Graph)this.graph), true);
                        tool.addToWorkList((Node)node6);
                    }
                } else if (n instanceof InstanceOfNode) {
                    InstanceOfNode node7 = (InstanceOfNode)n;
                    ObjectStamp oldStamp2 = node7.getCheckedStamp();
                    Stamp newStamp2 = this.strengthenStamp((Stamp)oldStamp2);
                    if (newStamp2 != null) {
                        LogicNode replacement = (LogicNode)this.graph.addOrUniqueWithInputs((Node)InstanceOfNode.createHelper((ObjectStamp)((ObjectStamp)oldStamp2.improveWith(newStamp2)), (ValueNode)node7.getValue(), (JavaTypeProfile)node7.profile(), (AnchoringNode)node7.getAnchor()));
                        node7.replaceAndDelete((Node)replacement);
                        tool.addToWorkList((Node)replacement);
                    }
                } else if (n instanceof ClassIsAssignableFromNode) {
                    ClassIsAssignableFromNode node8 = (ClassIsAssignableFromNode)n;
                    AnalysisType nonReachableType = this.asConstantNonReachableType(node8.getThisClass(), (CoreProviders)tool);
                    if (nonReachableType != null) {
                        node8.replaceAndDelete((Node)LogicConstantNode.contradiction((Graph)this.graph));
                    }
                } else if (n instanceof BytecodeExceptionNode) {
                    AnalysisType nonReachableType;
                    BytecodeExceptionNode node9 = (BytecodeExceptionNode)n;
                    if (node9.getExceptionKind() == BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST && (nonReachableType = this.asConstantNonReachableType((ValueNode)node9.getArguments().get(1), (CoreProviders)tool)) != null) {
                        node9.getArguments().set(1, (Object)ConstantNode.forConstant((JavaConstant)tool.getConstantReflection().forString(StrengthenGraphs.this.getTypeName(nonReachableType)), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph));
                    }
                } else if (n instanceof FrameState) {
                    FrameState node10 = (FrameState)n;
                    for (int i = 0; i < node10.values().size(); ++i) {
                        FieldOffsetProvider fieldOffsetProvider;
                        Node node11;
                        ImageHeapConstant imageHeapConstant;
                        ConstantNode constantNode;
                        Node node12 = node10.values().get(i);
                        if (node12 instanceof ConstantNode && (node12 = (constantNode = (ConstantNode)node12).getValue()) instanceof ImageHeapConstant && !(imageHeapConstant = (ImageHeapConstant)node12).isReachable()) {
                            node10.values().set(i, (Object)ConstantNode.defaultForKind((JavaKind)JavaKind.Object, (StructuredGraph)this.graph));
                        }
                        if (!((node11 = node10.values().get(i)) instanceof FieldOffsetProvider) || ((AnalysisField)(fieldOffsetProvider = (FieldOffsetProvider)node11).getField()).isUnsafeAccessed()) continue;
                        node10.values().set(i, (Object)ConstantNode.forIntegerKind((JavaKind)fieldOffsetProvider.asNode().getStackKind(), (long)-559607546L, (StructuredGraph)this.graph));
                    }
                } else if (n instanceof PiNode && (newStamp = this.strengthenStamp(oldStamp = (node2 = (PiNode)n).piStamp())) != null) {
                    node2.strengthenPiStamp(oldStamp.improveWith(newStamp));
                    tool.addToWorkList((Node)node2);
                }
            }
        }

        private AnalysisType asConstantNonReachableType(ValueNode value, CoreProviders providers) {
            AnalysisType expectedType;
            if (value != null && value.isConstant() && (expectedType = (AnalysisType)providers.getConstantReflection().asJavaType(value.asConstant())) != null && !expectedType.isReachable()) {
                return expectedType;
            }
            return null;
        }

        private void handleInvoke(Invoke invoke, SimplifierTool tool) {
            FixedNode node = invoke.asFixedNode();
            MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
            if (callTarget.invokeKind().isDirect() && !((AnalysisMethod)callTarget.targetMethod()).isSimplyImplementationInvoked()) {
                this.unreachableInvoke(invoke, tool);
                return;
            }
            InvokeTypeFlow invokeFlow = (InvokeTypeFlow)this.getNodeFlow((Node)node);
            if (invokeFlow == null) {
                return;
            }
            Collection<AnalysisMethod> callees = invokeFlow.getOriginalCallees();
            if (callees.isEmpty()) {
                this.unreachableInvoke(invoke, tool);
                return;
            }
            FixedWithNextNode beforeInvoke = (FixedWithNextNode)invoke.predecessor();
            NodeInputList arguments = callTarget.arguments();
            for (int i = 0; i < arguments.size(); ++i) {
                ValueNode pi;
                ValueNode argument = (ValueNode)arguments.get(i);
                Object newStampOrConstant = this.strengthenStampFromTypeFlow(argument, invokeFlow.getActualParameters()[i], beforeInvoke, tool);
                if (node.isDeleted()) {
                    return;
                }
                if (i == 0 && invoke.getInvokeKind() != CallTargetNode.InvokeKind.Static) {
                    boolean nullReceiver = false;
                    if (argument instanceof ConstantNode) {
                        ConstantNode constantNode = (ConstantNode)argument;
                        nullReceiver = constantNode.getValue().isDefaultForKind();
                    }
                    if (!nullReceiver && newStampOrConstant instanceof ObjectStamp) {
                        ObjectStamp stamp = (ObjectStamp)newStampOrConstant;
                        nullReceiver = stamp.alwaysNull();
                    }
                    if (!nullReceiver && newStampOrConstant instanceof Constant) {
                        Constant constantValue = (Constant)newStampOrConstant;
                        nullReceiver = constantValue.isDefaultForKind();
                    }
                    if (nullReceiver) {
                        this.invokeWithNullReceiver(invoke);
                        return;
                    }
                }
                if (newStampOrConstant == null || (pi = this.insertPi(argument, newStampOrConstant, beforeInvoke)) == null || pi == argument) continue;
                callTarget.replaceAllInputs((Node)argument, (Node)pi);
            }
            if (callees.size() == 1) {
                AnalysisMethod singleCallee = callees.iterator().next();
                if (callTarget.invokeKind().isDirect()) {
                    assert (callTarget.targetMethod().equals((Object)singleCallee)) : "Direct invoke target mismatch: " + String.valueOf(callTarget.targetMethod()) + " != " + String.valueOf(singleCallee);
                } else {
                    this.devirtualizeInvoke(singleCallee, invoke);
                }
            } else {
                TypeState receiverTypeState = null;
                if (invokeFlow.getTargetMethod().hasReceiver() && !this.methodFlow.isSaturated((PointsToAnalysis)StrengthenGraphs.this.bb, invokeFlow.getReceiver())) {
                    receiverTypeState = this.methodFlow.foldTypeFlow((PointsToAnalysis)StrengthenGraphs.this.bb, invokeFlow.getReceiver());
                }
                JavaTypeProfile typeProfile = StrengthenGraphs.this.makeTypeProfile(receiverTypeState);
                JavaMethodProfile methodProfile = StrengthenGraphs.this.makeMethodProfile(callees);
                assert (typeProfile == null || typeProfile.getTypes().length > 1) : "Should devirtualize with typeProfile=" + String.valueOf(typeProfile) + " and methodProfile=" + String.valueOf(methodProfile);
                assert (methodProfile == null || methodProfile.getMethods().length > 1) : "Should devirtualize with typeProfile=" + String.valueOf(typeProfile) + " and methodProfile=" + String.valueOf(methodProfile);
                StrengthenGraphs.this.setInvokeProfiles(invoke, typeProfile, methodProfile);
            }
            if (this.allowOptimizeReturnParameter) {
                this.optimizeReturnedParameter(callees, (NodeInputList<ValueNode>)arguments, node, tool);
            }
            FixedWithNextNode anchorPointAfterInvoke = (FixedWithNextNode)(invoke instanceof InvokeWithExceptionNode ? invoke.next() : invoke);
            Object newStampOrConstant = this.strengthenStampFromTypeFlow((ValueNode)node, invokeFlow.getResult(), anchorPointAfterInvoke, tool);
            this.updateStampUsingPiNode((ValueNode)node, newStampOrConstant, anchorPointAfterInvoke, tool);
        }

        private void optimizeReturnedParameter(Collection<AnalysisMethod> callees, NodeInputList<ValueNode> arguments, FixedNode invoke, SimplifierTool tool) {
            int returnedParameterIndex = -1;
            for (AnalysisMethod callee : callees) {
                if (callee.hasNeverInlineDirective()) {
                    return;
                }
                int returnedCalleeParameterIndex = PointsToAnalysis.assertPointsToAnalysisMethod(callee).getTypeFlow().getReturnedParameterIndex();
                if (returnedCalleeParameterIndex == -1) {
                    return;
                }
                if (returnedParameterIndex == -1) {
                    returnedParameterIndex = returnedCalleeParameterIndex;
                    continue;
                }
                if (returnedParameterIndex == returnedCalleeParameterIndex) continue;
                return;
            }
            assert (returnedParameterIndex != -1) : callees;
            ValueNode returnedActualParameter = (ValueNode)arguments.get(returnedParameterIndex);
            tool.addToWorkList((Iterable)invoke.usages());
            invoke.replaceAtUsages((Node)returnedActualParameter);
        }

        protected void invokeWithNullReceiver(Invoke invoke) {
            FixedNode replacement = StrengthenGraphs.this.createInvokeWithNullReceiverReplacement(this.graph);
            ((FixedWithNextNode)invoke.predecessor()).setNext(replacement);
            GraphUtil.killCFG((FixedNode)invoke.asFixedNode());
        }

        private void unreachableInvoke(Invoke invoke, SimplifierTool tool) {
            if (invoke.getInvokeKind() != CallTargetNode.InvokeKind.Static) {
                InliningUtil.nonNullReceiver((Invoke)invoke);
            }
            this.makeUnreachable(invoke.asFixedNode(), (CoreProviders)tool, () -> "method " + ((AnalysisMethod)this.graph.method()).getQualifiedName() + ", node " + String.valueOf(invoke) + ": empty list of callees for call to " + ((AnalysisMethod)invoke.callTarget().targetMethod()).getQualifiedName());
        }

        private void devirtualizeInvoke(AnalysisMethod singleCallee, Invoke invoke) {
            if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(this.graph.getOptions())).booleanValue()) {
                ImageBuildStatistics.counters().incDevirtualizedInvokeCounter();
            }
            ObjectStamp anchoredReceiverStamp = StampFactory.object((TypeReference)TypeReference.createWithoutAssumptions((ResolvedJavaType)singleCallee.getDeclaringClass()));
            ValueNode piReceiver = this.insertPi(invoke.getReceiver(), anchoredReceiverStamp, (FixedWithNextNode)invoke.asNode().predecessor());
            if (piReceiver != null) {
                invoke.callTarget().replaceFirstInput((Node)invoke.getReceiver(), (Node)piReceiver);
            }
            assert (invoke.getInvokeKind().isIndirect()) : invoke;
            invoke.callTarget().setInvokeKind(CallTargetNode.InvokeKind.Special);
            invoke.callTarget().setTargetMethod((ResolvedJavaMethod)singleCallee);
        }

        private boolean isUnreachable(Node branch) {
            TypeFlow<?> branchFlow = this.getNodeFlow(branch);
            return branchFlow != null && !this.methodFlow.isSaturated((PointsToAnalysis)StrengthenGraphs.this.bb, branchFlow) && this.methodFlow.foldTypeFlow((PointsToAnalysis)StrengthenGraphs.this.bb, branchFlow).isEmpty();
        }

        private void updateStampInPlace(ValueNode node, Stamp newStamp, SimplifierTool tool) {
            Stamp computedStamp;
            Stamp oldStamp;
            if (newStamp != null && !(oldStamp = node.stamp(NodeView.DEFAULT)).equals(computedStamp = oldStamp.improveWith(newStamp))) {
                node.setStamp(newStamp);
                tool.addToWorkList((Iterable)node.usages());
            }
        }

        private void updateStampUsingPiNode(ValueNode node, Object newStampOrConstant, FixedWithNextNode anchorPoint, SimplifierTool tool) {
            ValueNode pi;
            if (newStampOrConstant != null && node.hasUsages() && !this.createdPiNodes.isMarked((Node)node) && (pi = this.insertPi(node, newStampOrConstant, anchorPoint)) != null) {
                this.createdPiNodes.mark((Node)node);
                if (pi.isConstant()) {
                    node.replaceAtUsages((Node)pi);
                } else {
                    FrameState anchorState = node instanceof StateSplit ? ((StateSplit)node).stateAfter() : this.graph.start().stateAfter();
                    node.replaceAtUsages((Node)pi, usage -> usage != pi && usage != anchorState);
                }
                tool.addToWorkList((Iterable)pi.usages());
            }
        }

        private ValueNode insertPi(ValueNode input, Object newStampOrConstant, FixedWithNextNode anchorPoint) {
            Stamp computedStamp;
            if (newStampOrConstant instanceof JavaConstant) {
                JavaConstant constant = (JavaConstant)newStampOrConstant;
                if (input.isConstant()) {
                    assert (StrengthenGraphs.this.bb.getConstantReflectionProvider().constantEquals(input.asConstant(), (Constant)constant).booleanValue()) : String.valueOf(input.asConstant()) + ", " + String.valueOf(constant);
                    return null;
                }
                return ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)StrengthenGraphs.this.bb.getMetaAccess(), (StructuredGraph)this.graph);
            }
            Stamp piStamp = (Stamp)newStampOrConstant;
            Stamp oldStamp = input.stamp(NodeView.DEFAULT);
            if (oldStamp.equals(computedStamp = oldStamp.improveWith(piStamp))) {
                return null;
            }
            ValueAnchorNode anchor = (ValueAnchorNode)this.graph.add((Node)new ValueAnchorNode());
            this.graph.addAfterFixed(anchorPoint, (FixedNode)anchor);
            return (ValueNode)this.graph.unique((Node)new PiNode(input, piStamp, (ValueNode)anchor));
        }

        private Object strengthenStampFromTypeFlow(ValueNode node, TypeFlow<?> nodeFlow, FixedWithNextNode anchorPoint, SimplifierTool tool) {
            JavaConstant constantValue;
            if (nodeFlow == null || !((PointsToAnalysis)StrengthenGraphs.this.bb).isSupportedJavaKind(node.getStackKind())) {
                return null;
            }
            if (this.methodFlow.isSaturated((PointsToAnalysis)StrengthenGraphs.this.bb, nodeFlow)) {
                return null;
            }
            if (this.unreachableValues.contains((Object)node)) {
                return null;
            }
            boolean hasUsages = node.usages().filter(n -> !(n instanceof FrameState)).isNotEmpty();
            TypeState nodeTypeState = this.methodFlow.foldTypeFlow((PointsToAnalysis)StrengthenGraphs.this.bb, nodeFlow);
            if (hasUsages && this.allowConstantFolding && !nodeTypeState.canBeNull() && (constantValue = nodeTypeState.asConstant()) != null) {
                return constantValue;
            }
            node.inferStamp();
            Stamp s = node.stamp(NodeView.DEFAULT);
            if (s.isIntegerStamp() || nodeTypeState.isPrimitive()) {
                return this.getIntegerStamp(node, s, nodeTypeState);
            }
            ObjectStamp oldStamp = (ObjectStamp)s;
            AnalysisType oldType = (AnalysisType)oldStamp.type();
            boolean nonNull = oldStamp.nonNull() || !nodeTypeState.canBeNull();
            ArrayList<AnalysisType> typeStateTypes = new ArrayList<AnalysisType>(nodeTypeState.typesCount());
            for (AnalysisType typeStateType2 : nodeTypeState.types(StrengthenGraphs.this.bb)) {
                if (oldType != null && !(oldStamp.isExactType() ? oldType.equals(typeStateType2) : oldType.isJavaLangObject() || oldType.isAssignableFrom(typeStateType2))) continue;
                typeStateTypes.add(typeStateType2);
            }
            if (typeStateTypes.size() == 0) {
                if (nonNull) {
                    this.makeUnreachable(anchorPoint.next(), (CoreProviders)tool, () -> "method " + ((AnalysisMethod)this.graph.method()).getQualifiedName() + ", node " + String.valueOf(node) + ": empty stamp when strengthening oldStamp " + String.valueOf(oldStamp));
                    this.unreachableValues.add((Object)node);
                    return null;
                }
                return hasUsages ? StampFactory.alwaysNull() : null;
            }
            if (!hasUsages) {
                return null;
            }
            if (typeStateTypes.size() == 1) {
                ResolvedJavaType targetType;
                AnalysisType exactType = (AnalysisType)typeStateTypes.get(0);
                assert (StrengthenGraphs.this.getSingleImplementorType(exactType) == null || exactType.equals(StrengthenGraphs.this.getSingleImplementorType(exactType))) : "exactType=" + String.valueOf(exactType) + ", singleImplementor=" + String.valueOf(StrengthenGraphs.this.getSingleImplementorType(exactType));
                assert (exactType.equals(StrengthenGraphs.this.getStrengthenStampType(exactType))) : exactType;
                if (!(oldStamp.isExactType() && exactType.equals(oldType) || (targetType = this.toTargetFunction.apply(exactType)) == null)) {
                    TypeReference typeRef = TypeReference.createExactTrusted((ResolvedJavaType)targetType);
                    return StampFactory.object((TypeReference)typeRef, (boolean)nonNull);
                }
            } else if (!oldStamp.isExactType()) {
                ResolvedJavaType targetType;
                assert (typeStateTypes.size() > 1) : typeStateTypes;
                AnalysisType baseType = (AnalysisType)typeStateTypes.get(0);
                for (int i = 1; i < typeStateTypes.size() && !baseType.isJavaLangObject(); ++i) {
                    baseType = baseType.findLeastCommonAncestor((ResolvedJavaType)typeStateTypes.get(i));
                }
                if (oldType != null && !oldType.isAssignableFrom(baseType)) {
                    baseType = oldType;
                }
                assert (StrengthenGraphs.this.getSingleImplementorType(baseType) == null || baseType.equals(StrengthenGraphs.this.getSingleImplementorType(baseType))) : "baseType=" + String.valueOf(baseType) + ", singleImplementor=" + String.valueOf(StrengthenGraphs.this.getSingleImplementorType(baseType));
                AnalysisType newType = StrengthenGraphs.this.getStrengthenStampType(baseType);
                assert (typeStateTypes.stream().map(typeStateType -> newType.isAssignableFrom((ResolvedJavaType)typeStateType)).reduce(Boolean::logicalAnd).get().booleanValue()) : typeStateTypes;
                if (!(newType.equals(oldType) || oldType == null && newType.isJavaLangObject() || (targetType = this.toTargetFunction.apply(newType)) == null)) {
                    TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)targetType);
                    return StampFactory.object((TypeReference)typeRef, (boolean)nonNull);
                }
            }
            if (nonNull != oldStamp.nonNull()) {
                assert (nonNull) : oldStamp;
                return oldStamp.asNonNull();
            }
            return null;
        }

        private IntegerStamp getIntegerStamp(ValueNode node, Stamp stamp, TypeState nodeTypeState) {
            assert (StrengthenGraphs.this.bb.trackPrimitiveValues()) : String.valueOf(nodeTypeState) + "," + String.valueOf(node) + " in " + String.valueOf(node.graph());
            assert (nodeTypeState != null && (nodeTypeState.isEmpty() || nodeTypeState.isPrimitive())) : String.valueOf(nodeTypeState) + "," + String.valueOf(node) + " in " + String.valueOf(node.graph());
            if (nodeTypeState instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState constantTypeState = (PrimitiveConstantTypeState)nodeTypeState;
                long constantValue = constantTypeState.getValue();
                if (node instanceof ConstantNode) {
                    ConstantNode constant = (ConstantNode)node;
                    Constant value = constant.getValue();
                    assert (value instanceof PrimitiveConstant) : "Node " + String.valueOf(value) + " should be a primitive constant when extracting an integer stamp, method " + String.valueOf(node.graph().method());
                    assert (((PrimitiveConstant)value).asLong() == constantValue) : "The actual value of node: " + String.valueOf(value) + " is different than the value " + constantValue + " computed by points-to analysis, method in " + String.valueOf(node.graph().method());
                } else {
                    return IntegerStamp.createConstant((int)((IntegerStamp)stamp).getBits(), (long)constantValue);
                }
            }
            return null;
        }

        private void makeUnreachable(FixedNode node, CoreProviders providers, Supplier<String> message) {
            FixedNode unreachableNode = StrengthenGraphs.this.createUnreachable(this.graph, providers, message);
            ((FixedWithNextNode)node.predecessor()).setNext(unreachableNode);
            GraphUtil.killCFG((FixedNode)node);
        }

        private Stamp strengthenStamp(Stamp s) {
            Stamp newStamp;
            ResolvedJavaType targetType;
            if (!(s instanceof AbstractObjectStamp)) {
                return null;
            }
            AbstractObjectStamp stamp = (AbstractObjectStamp)s;
            AnalysisType originalType = (AnalysisType)stamp.type();
            if (originalType == null) {
                return null;
            }
            if (!originalType.isReachable()) {
                if (stamp.nonNull()) {
                    return StampFactory.empty((JavaKind)JavaKind.Object);
                }
                return StampFactory.alwaysNull();
            }
            AnalysisType singleImplementorType = StrengthenGraphs.this.getSingleImplementorType(originalType);
            if (!(singleImplementorType == null || stamp.isExactType() && singleImplementorType.equals(originalType) || (targetType = this.toTargetFunction.apply(singleImplementorType)) == null)) {
                TypeReference typeRef = TypeReference.createExactTrusted((ResolvedJavaType)targetType);
                return StampFactory.object((TypeReference)typeRef, (boolean)stamp.nonNull());
            }
            AnalysisType strengthenType = StrengthenGraphs.this.getStrengthenStampType(originalType);
            if (originalType.equals(strengthenType)) {
                return null;
            }
            if (strengthenType == null) {
                newStamp = stamp.nonNull() ? StampFactory.empty((JavaKind)JavaKind.Object) : StampFactory.alwaysNull();
            } else if (stamp.isExactType()) {
                newStamp = StampFactory.empty((JavaKind)JavaKind.Object);
            } else {
                ResolvedJavaType targetType2 = this.toTargetFunction.apply(strengthenType);
                if (targetType2 == null) {
                    return null;
                }
                TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)targetType2);
                newStamp = StampFactory.object((TypeReference)typeRef, (boolean)stamp.nonNull());
            }
            return newStamp;
        }
    }
}

