/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.typestate.AnyPrimitiveTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.Objects;

public final class PrimitiveConstantTypeState
extends AnyPrimitiveTypeState {
    private static final int CACHE_SIZE = 16;
    private static final PrimitiveConstantTypeState[] CACHE = new PrimitiveConstantTypeState[16];
    private final long value;

    public static TypeState forValue(long value) {
        if (value >= 0L && value < 16L) {
            return CACHE[(int)value];
        }
        return new PrimitiveConstantTypeState(value);
    }

    private PrimitiveConstantTypeState(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveConstantTypeState that = (PrimitiveConstantTypeState)o;
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String toString() {
        return "PrimitiveConstantTypeState(" + this.value + ")";
    }

    static {
        for (int i = 0; i < 16; ++i) {
            PrimitiveConstantTypeState.CACHE[i] = new PrimitiveConstantTypeState(i);
        }
    }
}

