/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.TypedConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.GraalAccess;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class AnalysisMetaAccessExtensionProvider
implements MetaAccessExtensionProvider {
    private final AnalysisUniverse aUniverse;

    public AnalysisMetaAccessExtensionProvider(AnalysisUniverse aUniverse) {
        this.aUniverse = aUniverse;
    }

    public JavaKind getStorageKind(JavaType type) {
        return ((AnalysisType)type).getStorageKind();
    }

    public boolean canConstantFoldDynamicAllocation(ResolvedJavaType t) {
        AnalysisType type = (AnalysisType)t;
        if (this.aUniverse.sealed()) {
            return type.isInstantiated();
        }
        return true;
    }

    public boolean isGuaranteedSafepoint(ResolvedJavaMethod method, boolean isDirect) {
        throw GraalError.unimplementedOverride();
    }

    public boolean canVirtualize(ResolvedJavaType instanceType) {
        return true;
    }

    public ResolvedJavaField getStaticFieldForAccess(JavaConstant base, long offset, JavaKind accessKind) {
        JavaConstant hostedObject;
        if (base instanceof ImageHeapConstant) {
            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)base;
            hostedObject = imageHeapConstant.getHostedObject();
            if (hostedObject == null) {
                return null;
            }
            assert (!(hostedObject instanceof ImageHeapConstant));
        } else if (!(base instanceof TypedConstant)) {
            hostedObject = base;
        } else {
            return null;
        }
        MetaAccessExtensionProvider original = GraalAccess.getOriginalProviders().getMetaAccessExtensionProvider();
        return this.aUniverse.lookup((JavaField)original.getStaticFieldForAccess(hostedObject, offset, accessKind));
    }
}

