/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.phases;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.bytecode.Bytecode;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.replacements.IntrinsicGraphBuilder;
import jdk.vm.ci.meta.JavaKind;

public class SubstrateIntrinsicGraphBuilder
extends IntrinsicGraphBuilder {
    private int bci;

    public SubstrateIntrinsicGraphBuilder(OptionValues options, DebugContext debug, CoreProviders providers, Bytecode code) {
        super(options, debug, providers, code, -1, StructuredGraph.AllowAssumptions.NO);
        this.setStateAfter((StateSplit)this.getGraph().start());
    }

    public void setStateAfter(StateSplit sideEffect) {
        FrameState stateAfter = this.getFrameState(this.returnValue);
        sideEffect.setStateAfter(stateAfter);
    }

    private FrameState getFrameState(ValueNode returnVal) {
        ValueNode[] locals = this.arguments;
        JavaKind[] pushedSlotKinds = null;
        ValueNode[] pushedValues = null;
        ValueNode[] locks = ValueNode.EMPTY_ARRAY;
        ValueNode[] stack = returnVal != null ? (this.method.getSignature().getReturnKind().needsTwoSlots() ? new ValueNode[]{returnVal, null} : new ValueNode[]{returnVal}) : ValueNode.EMPTY_ARRAY;
        FrameState stateAfter = (FrameState)this.getGraph().add((Node)new FrameState(null, this.code, this.bci, locals, stack, stack.length, pushedSlotKinds, pushedValues, locks, null, FrameState.StackState.BeforePop));
        ++this.bci;
        return stateAfter;
    }

    public FrameState getInvocationPluginReturnState(JavaKind retKind, ValueNode retVal) {
        return this.getFrameState(retVal);
    }

    protected void setExceptionState(StateSplit exceptionObject) {
        ValueNode[] locals = this.arguments;
        ValueNode[] stack = new ValueNode[]{exceptionObject.asNode()};
        JavaKind[] pushedSlotKinds = null;
        ValueNode[] pushedValues = null;
        ValueNode[] locks = ValueNode.EMPTY_ARRAY;
        List monitorIds = null;
        FrameState stateAfter = (FrameState)this.getGraph().add((Node)new FrameState(null, this.code, this.bci, locals, stack, 1, pushedSlotKinds, pushedValues, locks, monitorIds, FrameState.StackState.Rethrow));
        exceptionObject.setStateAfter(stateAfter);
        ++this.bci;
    }

    protected void mergeUnwinds() {
        ArrayList<UnwindNode> unwinds = new ArrayList<UnwindNode>();
        for (Node node : this.getGraph().getNodes()) {
            if (!(node instanceof UnwindNode)) continue;
            unwinds.add((UnwindNode)node);
        }
        if (unwinds.size() > 1) {
            MergeNode unwindMergeNode = (MergeNode)this.getGraph().add((Node)new MergeNode());
            ValueNode exceptionValue = InliningUtil.mergeUnwindExceptions((AbstractMergeNode)unwindMergeNode, unwinds);
            UnwindNode unwindReplacement = (UnwindNode)this.getGraph().add((Node)new UnwindNode(exceptionValue));
            unwindMergeNode.setNext((FixedNode)unwindReplacement);
            ValueNode[] locals = this.arguments;
            ValueNode[] stack = new ValueNode[]{exceptionValue};
            JavaKind[] pushedSlotKinds = null;
            ValueNode[] pushedValues = null;
            ValueNode[] locks = ValueNode.EMPTY_ARRAY;
            List monitorIds = null;
            FrameState stateAfter = (FrameState)this.getGraph().add((Node)new FrameState(null, this.code, this.bci, locals, stack, 1, pushedSlotKinds, pushedValues, locks, monitorIds, FrameState.StackState.Rethrow));
            unwindMergeNode.setStateAfter(stateAfter);
            ++this.bci;
        }
    }

    public int bci() {
        return this.bci;
    }

    public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
        return plugin.isGeneratedFromFoldOrNodeIntrinsic();
    }

    public boolean needsExplicitException() {
        return true;
    }
}

