/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.PrimitiveComparison;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.AnyPrimitiveTypeState;
import com.oracle.graal.pointsto.typestate.PrimitiveConstantTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.Iterator;

public abstract sealed class PrimitiveTypeState
extends TypeState
permits PrimitiveConstantTypeState, AnyPrimitiveTypeState {
    protected PrimitiveTypeState() {
    }

    @Override
    public final boolean isPrimitive() {
        return true;
    }

    @Override
    public final boolean canBeNull() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean isAnyPrimitive() {
        return this instanceof AnyPrimitiveTypeState;
    }

    public TypeState forUnion(PrimitiveTypeState right) {
        if (this instanceof AnyPrimitiveTypeState || right instanceof AnyPrimitiveTypeState) {
            return AnyPrimitiveTypeState.SINGLETON;
        }
        PrimitiveTypeState primitiveTypeState = this;
        if (primitiveTypeState instanceof PrimitiveConstantTypeState) {
            PrimitiveConstantTypeState c1 = (PrimitiveConstantTypeState)primitiveTypeState;
            if (right instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState c2 = (PrimitiveConstantTypeState)right;
                if (c1.getValue() == c2.getValue()) {
                    return this;
                }
            }
        }
        return AnyPrimitiveTypeState.SINGLETON;
    }

    public TypeState filter(PrimitiveComparison comparison, PrimitiveTypeState right) {
        return switch (comparison) {
            default -> throw new MatchException(null, null);
            case PrimitiveComparison.EQ -> this.forEquals(right);
            case PrimitiveComparison.NEQ -> this.forNotEquals(right);
            case PrimitiveComparison.LT -> this.forLessThan(right);
            case PrimitiveComparison.GE -> this.forGreaterOrEqual(right);
            case PrimitiveComparison.GT -> this.forGreaterThan(right);
            case PrimitiveComparison.LE -> this.forLessOrEqual(right);
        };
    }

    public TypeState forEquals(PrimitiveTypeState right) {
        PrimitiveTypeState primitiveTypeState = this;
        if (primitiveTypeState instanceof PrimitiveConstantTypeState) {
            PrimitiveConstantTypeState thisConstant = (PrimitiveConstantTypeState)primitiveTypeState;
            if (right instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState rightConstant = (PrimitiveConstantTypeState)right;
                if (thisConstant.getValue() != rightConstant.getValue()) {
                    return PrimitiveTypeState.forEmpty();
                }
            }
            return this;
        }
        if (this instanceof AnyPrimitiveTypeState) {
            if (right instanceof PrimitiveConstantTypeState) {
                return right;
            }
            return this;
        }
        throw AnalysisError.shouldNotReachHere("Combination not covered, this=" + String.valueOf(this) + ". right=" + String.valueOf(right));
    }

    public TypeState forNotEquals(PrimitiveTypeState right) {
        PrimitiveTypeState primitiveTypeState = this;
        if (primitiveTypeState instanceof PrimitiveConstantTypeState) {
            PrimitiveConstantTypeState thisConstant = (PrimitiveConstantTypeState)primitiveTypeState;
            if (right instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState rightConstant = (PrimitiveConstantTypeState)right;
                if (thisConstant.getValue() == rightConstant.getValue()) {
                    return PrimitiveTypeState.forEmpty();
                }
            }
        }
        return this;
    }

    public TypeState forLessThan(PrimitiveTypeState right) {
        PrimitiveTypeState primitiveTypeState = this;
        if (primitiveTypeState instanceof PrimitiveConstantTypeState) {
            PrimitiveConstantTypeState thisConstant = (PrimitiveConstantTypeState)primitiveTypeState;
            if (right instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState rightConstant = (PrimitiveConstantTypeState)right;
                if (thisConstant.getValue() >= rightConstant.getValue()) {
                    return PrimitiveTypeState.forEmpty();
                }
            }
        }
        return this;
    }

    public TypeState forGreaterOrEqual(PrimitiveTypeState right) {
        PrimitiveTypeState primitiveTypeState = this;
        if (primitiveTypeState instanceof PrimitiveConstantTypeState) {
            PrimitiveConstantTypeState thisConstant = (PrimitiveConstantTypeState)primitiveTypeState;
            if (right instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState rightConstant = (PrimitiveConstantTypeState)right;
                if (thisConstant.getValue() < rightConstant.getValue()) {
                    return PrimitiveTypeState.forEmpty();
                }
            }
        }
        return this;
    }

    public TypeState forLessOrEqual(PrimitiveTypeState right) {
        PrimitiveTypeState primitiveTypeState = this;
        if (primitiveTypeState instanceof PrimitiveConstantTypeState) {
            PrimitiveConstantTypeState thisConstant = (PrimitiveConstantTypeState)primitiveTypeState;
            if (right instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState rightConstant = (PrimitiveConstantTypeState)right;
                if (thisConstant.getValue() > rightConstant.getValue()) {
                    return PrimitiveTypeState.forEmpty();
                }
            }
        }
        return this;
    }

    public TypeState forGreaterThan(PrimitiveTypeState right) {
        PrimitiveTypeState primitiveTypeState = this;
        if (primitiveTypeState instanceof PrimitiveConstantTypeState) {
            PrimitiveConstantTypeState thisConstant = (PrimitiveConstantTypeState)primitiveTypeState;
            if (right instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState rightConstant = (PrimitiveConstantTypeState)right;
                if (thisConstant.getValue() <= rightConstant.getValue()) {
                    return PrimitiveTypeState.forEmpty();
                }
            }
        }
        return this;
    }

    public abstract boolean canBeTrue();

    public abstract boolean canBeFalse();

    public abstract String toString();

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public int typesCount() {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    public AnalysisType exactType() {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    protected Iterator<AnalysisType> typesIterator(BigBang bb) {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    public boolean containsType(AnalysisType exactType) {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    public int objectsCount() {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(BigBang bb) {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(AnalysisType type) {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    @Override
    public TypeState forCanBeNull(PointsToAnalysis bb, boolean stateCanBeNull) {
        throw PrimitiveTypeState.shouldNotReachHere();
    }

    private static RuntimeException shouldNotReachHere() {
        throw AnalysisError.shouldNotReachHere("This method should never be called.");
    }
}

