/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;

public class AnalysisObjectScanningObserver
implements ObjectScanningObserver {
    private final BigBang bb;

    public AnalysisObjectScanningObserver(BigBang bb) {
        this.bb = bb;
    }

    @Override
    public boolean forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        boolean changed = false;
        if (fieldValue.isNonNull()) {
            FieldTypeFlow fieldTypeFlow = this.getFieldTypeFlow(field, receiver);
            changed = fieldTypeFlow.addState(this.getAnalysis(), TypeState.anyPrimitiveState());
        }
        if (!field.isWritten()) {
            changed |= field.registerAsWritten(reason);
        }
        return changed;
    }

    @Override
    public boolean forNullFieldValue(JavaConstant receiver, AnalysisField field, ObjectScanner.ScanReason reason) {
        FieldTypeFlow fieldTypeFlow = this.getFieldTypeFlow(field, receiver);
        if (!fieldTypeFlow.getState().canBeNull()) {
            return fieldTypeFlow.addState(this.getAnalysis(), TypeState.forNull());
        }
        return false;
    }

    @Override
    public boolean forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        PointsToAnalysis analysis = this.getAnalysis();
        AnalysisType fieldType = analysis.getMetaAccess().lookupJavaType(fieldValue);
        FieldTypeFlow fieldTypeFlow = this.getFieldTypeFlow(field, receiver);
        return fieldTypeFlow.addState(analysis, this.bb.analysisPolicy().constantTypeState(analysis, fieldValue, fieldType));
    }

    @Override
    public boolean forPrimitiveFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        PointsToAnalysis analysis = this.getAnalysis();
        FieldTypeFlow fieldTypeFlow = this.getFieldTypeFlow(field, receiver);
        return fieldTypeFlow.addState(analysis, TypeState.forPrimitiveConstant(fieldValue.asLong()));
    }

    private FieldTypeFlow getFieldTypeFlow(AnalysisField field, JavaConstant receiver) {
        if (field.isStatic()) {
            return field.getStaticFieldFlow();
        }
        PointsToAnalysis analysis = this.getAnalysis();
        AnalysisType receiverType = analysis.getMetaAccess().lookupJavaType(receiver);
        AnalysisObject constantReceiverObj = analysis.analysisPolicy().createConstantObject(analysis, receiver, receiverType);
        return constantReceiverObj.getInstanceFieldFlow(analysis, field, true);
    }

    @Override
    public boolean forNullArrayElement(JavaConstant array, AnalysisType arrayType, int elementIndex, ObjectScanner.ScanReason reason) {
        ArrayElementsTypeFlow arrayObjElementsFlow = this.getArrayElementsFlow(array, arrayType);
        if (!arrayObjElementsFlow.getState().canBeNull()) {
            return arrayObjElementsFlow.addState(this.getAnalysis(), TypeState.forNull());
        }
        return false;
    }

    @Override
    public boolean forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementConstant, AnalysisType elementType, int elementIndex, ObjectScanner.ScanReason reason) {
        ArrayElementsTypeFlow arrayObjElementsFlow = this.getArrayElementsFlow(array, arrayType);
        PointsToAnalysis analysis = this.getAnalysis();
        return arrayObjElementsFlow.addState(analysis, this.bb.analysisPolicy().constantTypeState(analysis, elementConstant, elementType));
    }

    private ArrayElementsTypeFlow getArrayElementsFlow(JavaConstant array, AnalysisType arrayType) {
        PointsToAnalysis analysis = this.getAnalysis();
        AnalysisObject arrayObjConstant = analysis.analysisPolicy().createConstantObject(analysis, array, arrayType);
        return arrayObjConstant.getArrayElementsFlow(analysis, true);
    }

    @Override
    public void forScannedConstant(JavaConstant value, ObjectScanner.ScanReason reason) {
        PointsToAnalysis analysis = this.getAnalysis();
        Object valueObj = analysis.getSnippetReflectionProvider().asObject(Object.class, value);
        ResolvedJavaType type = this.bb.getMetaAccess().lookupJavaType((Class)valueObj.getClass());
        type.registerAsInstantiated(reason);
    }

    private PointsToAnalysis getAnalysis() {
        return (PointsToAnalysis)this.bb;
    }
}

