/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.GraalAccess;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public class HostedValuesProvider {
    protected final AnalysisMetaAccess metaAccess;
    protected final AnalysisUniverse universe;

    public HostedValuesProvider(AnalysisMetaAccess metaAccess, AnalysisUniverse universe) {
        this.metaAccess = metaAccess;
        this.universe = universe;
    }

    public ValueSupplier<JavaConstant> readFieldValue(AnalysisField field, JavaConstant receiver) {
        return ValueSupplier.eagerValue(this.doReadValue(field, receiver));
    }

    public JavaConstant readFieldValueWithReplacement(AnalysisField field, JavaConstant receiver) {
        return this.replaceObject(this.doReadValue(field, receiver));
    }

    private JavaConstant doReadValue(AnalysisField field, JavaConstant receiver) {
        field.beforeFieldValueAccess();
        return this.interceptHosted(GraalAccess.getOriginalProviders().getConstantReflection().readFieldValue(field.wrapped, receiver));
    }

    public Integer readArrayLength(JavaConstant array) {
        return GraalAccess.getOriginalProviders().getConstantReflection().readArrayLength(array);
    }

    public JavaConstant readArrayElement(JavaConstant array, int index) {
        return GraalAccess.getOriginalProviders().getConstantReflection().readArrayElement(array, index);
    }

    public JavaConstant replaceObject(JavaConstant value) {
        Object oldObject;
        JavaConstant replacedConstant;
        if (value == JavaConstant.NULL_POINTER) {
            return JavaConstant.NULL_POINTER;
        }
        if (value instanceof ImageHeapConstant) {
            return value;
        }
        if (value.getJavaKind() == JavaKind.Object && !(replacedConstant = this.universe.replaceObjectWithConstant(oldObject = this.asObject(Object.class, value))).equals((Object)value)) {
            return this.validateReplacedConstant(replacedConstant);
        }
        return value;
    }

    public JavaConstant validateReplacedConstant(JavaConstant value) {
        return value;
    }

    public JavaConstant forObject(Object object) {
        return GraalAccess.getOriginalSnippetReflection().forObject(object);
    }

    public <T> T asObject(Class<T> type, JavaConstant constant) {
        return (T)GraalAccess.getOriginalSnippetReflection().asObject(type, constant);
    }

    public JavaConstant interceptHosted(JavaConstant constant) {
        return constant;
    }
}

