/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public final class DynamicNewInstanceTypeFlow
extends TypeFlow<BytecodePosition> {
    private TypeFlow<?> newTypeFlow;
    private final AnalysisContext allocationContext;

    public DynamicNewInstanceTypeFlow(BytecodePosition location, TypeFlow<?> newTypeFlow, AnalysisType type) {
        super(location, type);
        this.allocationContext = null;
        this.newTypeFlow = newTypeFlow;
    }

    private DynamicNewInstanceTypeFlow(PointsToAnalysis bb, DynamicNewInstanceTypeFlow original, MethodFlowsGraph methodFlows, AnalysisContext allocationContext) {
        super(original, methodFlows);
        this.allocationContext = allocationContext;
        this.newTypeFlow = methodFlows.lookupCloneOf(bb, original.newTypeFlow);
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        AnalysisContext allocContext = bb.analysisPolicy().allocationContext(bb, methodFlows);
        return new DynamicNewInstanceTypeFlow(bb, this, methodFlows, allocContext);
    }

    @Override
    public void initFlow(PointsToAnalysis bb) {
        assert (!bb.usePredicates() || this.newTypeFlow.getPredicate() != null || MethodFlowsGraph.nonMethodFlow(this.newTypeFlow)) : "Missing predicate for the flow " + String.valueOf(this.newTypeFlow) + ", which is input for " + String.valueOf(this);
        this.newTypeFlow.addObserver(bb, this);
    }

    @Override
    public boolean needsInitialization() {
        return true;
    }

    @Override
    protected void onFlowEnabled(PointsToAnalysis bb) {
        if (this.newTypeFlow.isFlowEnabled()) {
            bb.postTask(() -> this.onObservedUpdate(bb));
        }
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        if (!this.isFlowEnabled()) {
            return;
        }
        TypeState newTypeState = this.newTypeFlow.getState();
        TypeState updateState = bb.analysisPolicy().dynamicNewInstanceState(bb, this.getState(), newTypeState, (BytecodePosition)this.source, this.allocationContext);
        this.addState(bb, updateState);
    }

    public AnalysisContext allocationContext() {
        return this.allocationContext;
    }

    @Override
    public void setObserved(TypeFlow<?> declaredTypeFlow) {
        this.newTypeFlow = declaredTypeFlow;
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        if (bb.isClosed(this.declaredType)) {
            this.replaceObservedWith(bb, this.declaredType);
        } else {
            this.onSaturated(bb);
        }
    }

    @Override
    public boolean canSaturate(PointsToAnalysis bb) {
        return !bb.isClosed(this.declaredType);
    }

    @Override
    public String toString() {
        return "DynamicNewInstanceFlow<" + this.getStateDescription() + ">";
    }
}

