/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public class NullCheckTypeFlow
extends TypeFlow<BytecodePosition> {
    private final boolean blockNull;

    public NullCheckTypeFlow(BytecodePosition position, AnalysisType inputType, boolean blockNull) {
        super(position, inputType);
        this.blockNull = blockNull;
    }

    public NullCheckTypeFlow(MethodFlowsGraph methodFlows, NullCheckTypeFlow original) {
        super(original, methodFlows);
        this.blockNull = original.blockNull;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new NullCheckTypeFlow(methodFlows, this);
    }

    public boolean isBlockingNull() {
        return this.blockNull;
    }

    @Override
    public TypeState filter(PointsToAnalysis bb, TypeState newState) {
        if (this.blockNull) {
            return newState.forNonNull(bb);
        }
        if (newState.canBeNull()) {
            return TypeState.forNull();
        }
        return TypeState.forEmpty();
    }

    @Override
    public String toString() {
        return "NullCheckTypeFlow<" + (this.getDeclaredType() != null ? this.getDeclaredType().toJavaName(false) : "null") + " : " + this.getStateDescription() + ">";
    }
}

