/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.heap.HostedValuesProvider;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.heap.ImageHeapRelocatableConstant;
import com.oracle.graal.pointsto.heap.ImageLayerLoaderHelper;
import com.oracle.graal.pointsto.heap.ImageLayerSnapshotUtil;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.BaseLayerField;
import com.oracle.graal.pointsto.meta.BaseLayerMethod;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.util.ReflectionUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.util.ObjectCopier;
import jdk.graal.compiler.util.json.JsonParser;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class ImageLayerLoader {
    private final Map<Integer, AnalysisType> types = new ConcurrentHashMap<Integer, AnalysisType>();
    protected final Map<Integer, AnalysisMethod> methods = new ConcurrentHashMap<Integer, AnalysisMethod>();
    protected final Map<Integer, AnalysisField> fields = new ConcurrentHashMap<Integer, AnalysisField>();
    protected final Map<Integer, ImageHeapConstant> constants = new ConcurrentHashMap<Integer, ImageHeapConstant>();
    private final List<FilePaths> loadPaths;
    private final Map<Integer, BaseLayerType> baseLayerTypes = new ConcurrentHashMap<Integer, BaseLayerType>();
    private final Map<Integer, Integer> typeToHubIdentityHashCode = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, BaseLayerMethod> baseLayerMethods = new ConcurrentHashMap<Integer, BaseLayerMethod>();
    private final Map<Integer, BaseLayerField> baseLayerFields = new ConcurrentHashMap<Integer, BaseLayerField>();
    protected final Map<Integer, String> typeIdToIdentifier = new HashMap<Integer, String>();
    private final Map<Integer, String> methodIdToIdentifier = new HashMap<Integer, String>();
    private final Map<Integer, FieldIdentifier> fieldIdToIdentifier = new HashMap<Integer, FieldIdentifier>();
    protected final Set<AnalysisFuture<Void>> heapScannerTasks = ConcurrentHashMap.newKeySet();
    private ImageLayerSnapshotUtil imageLayerSnapshotUtil;
    private ImageLayerLoaderHelper imageLayerLoaderHelper;
    protected final Map<Integer, Integer> typeToConstant = new ConcurrentHashMap<Integer, Integer>();
    protected final Map<String, Integer> stringToConstant = new ConcurrentHashMap<String, Integer>();
    protected final Map<Enum<?>, Integer> enumToConstant = new ConcurrentHashMap();
    protected final Map<Integer, Long> objectOffsets = new ConcurrentHashMap<Integer, Long>();
    protected final Map<AnalysisField, Integer> fieldLocations = new ConcurrentHashMap<AnalysisField, Integer>();
    protected AnalysisUniverse universe;
    protected AnalysisMetaAccess metaAccess;
    protected HostedValuesProvider hostedValuesProvider;
    protected EconomicMap<String, Object> jsonMap;
    protected FileChannel graphsChannel;
    private long imageHeapSize;

    public ImageLayerLoader() {
        this(List.of());
    }

    public ImageLayerLoader(List<FilePaths> loadPaths) {
        this.loadPaths = loadPaths;
    }

    public void setImageLayerSnapshotUtil(ImageLayerSnapshotUtil imageLayerSnapshotUtil) {
        this.imageLayerSnapshotUtil = imageLayerSnapshotUtil;
    }

    public AnalysisUniverse getUniverse() {
        return this.universe;
    }

    public void setUniverse(AnalysisUniverse newUniverse) {
        this.universe = newUniverse;
    }

    public void setImageLayerLoaderHelper(ImageLayerLoaderHelper imageLayerLoaderHelper) {
        this.imageLayerLoaderHelper = imageLayerLoaderHelper;
    }

    protected void openFilesAndLoadJsonMap() {
        assert (this.loadPaths.size() == 1) : "Currently only one path is supported for image layer loading " + String.valueOf(this.loadPaths);
        if (this.jsonMap == null) {
            for (FilePaths paths : this.loadPaths) {
                try {
                    this.graphsChannel = FileChannel.open(paths.snapshotGraphs, new OpenOption[0]);
                    try (InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(paths.snapshot.toFile()));){
                        Object json = new JsonParser((Reader)inputStreamReader).parse();
                        this.jsonMap = (EconomicMap)ImageLayerLoader.cast(json);
                    }
                }
                catch (IOException e) {
                    throw AnalysisError.shouldNotReachHere("Error during image layer snapshot loading", e);
                }
            }
        }
    }

    public void loadLayerAnalysis() {
        this.openFilesAndLoadJsonMap();
        this.loadLayerAnalysis0();
    }

    public void cleanupAfterAnalysis() {
        if (this.graphsChannel != null) {
            try {
                this.graphsChannel.close();
            }
            catch (IOException e) {
                throw AnalysisError.shouldNotReachHere(e);
            }
        }
    }

    private void loadLayerAnalysis0() {
        int id;
        int nextTypeId = (Integer)ImageLayerLoader.get(this.jsonMap, "next type id");
        this.universe.setStartTypeId(nextTypeId);
        int nextMethodId = (Integer)ImageLayerLoader.get(this.jsonMap, "next method id");
        this.universe.setStartMethodId(nextMethodId);
        int nextFieldId = (Integer)ImageLayerLoader.get(this.jsonMap, "next field id");
        this.universe.setStartFieldId(nextFieldId);
        int nextConstantId = (Integer)ImageLayerLoader.get(this.jsonMap, "next constant id");
        ImageHeapConstant.setCurrentId(nextConstantId);
        this.imageHeapSize = Long.parseLong((String)ImageLayerLoader.get(this.jsonMap, "image heap size"));
        this.storeIdToIdentifier("types", this.typeIdToIdentifier);
        this.storeIdToIdentifier("methods", this.methodIdToIdentifier);
        EconomicMap fieldsMap = (EconomicMap)ImageLayerLoader.get(this.jsonMap, "fields");
        MapCursor fieldsCursor = fieldsMap.getEntries();
        while (fieldsCursor.advance()) {
            EconomicMap typeData = (EconomicMap)ImageLayerLoader.getValue((MapCursor<String, Object>)fieldsCursor);
            MapCursor typeFieldsCursor = typeData.getEntries();
            while (typeFieldsCursor.advance()) {
                EconomicMap fieldData = (EconomicMap)ImageLayerLoader.getValue((MapCursor<String, Object>)typeFieldsCursor);
                id = (Integer)ImageLayerLoader.get((EconomicMap<String, Object>)fieldData, "id");
                this.fieldIdToIdentifier.put(id, new FieldIdentifier((String)fieldsCursor.getKey(), (String)typeFieldsCursor.getKey()));
            }
        }
        EconomicMap constantsMap = (EconomicMap)ImageLayerLoader.get(this.jsonMap, "constants");
        List constantsToRelink = (List)ImageLayerLoader.get(this.jsonMap, "constants to relink");
        Iterator iterator = constantsToRelink.iterator();
        while (iterator.hasNext()) {
            id = (Integer)iterator.next();
            EconomicMap constantData = (EconomicMap)ImageLayerLoader.get((EconomicMap<String, Object>)constantsMap, String.valueOf(id));
            int identityHashCode = (Integer)ImageLayerLoader.get((EconomicMap<String, Object>)constantData, "identityHashCode");
            this.prepareConstantRelinking((EconomicMap<String, Object>)constantData, identityHashCode, id);
        }
    }

    private void storeIdToIdentifier(String tag, Map<Integer, String> idToIdentifier) {
        EconomicMap elementsMap = (EconomicMap)ImageLayerLoader.get(this.jsonMap, tag);
        MapCursor cursor = elementsMap.getEntries();
        while (cursor.advance()) {
            EconomicMap data = (EconomicMap)ImageLayerLoader.getValue((MapCursor<String, Object>)cursor);
            int id = (Integer)ImageLayerLoader.get((EconomicMap<String, Object>)data, "id");
            idToIdentifier.put(id, (String)cursor.getKey());
        }
    }

    protected void prepareConstantRelinking(EconomicMap<String, Object> constantData, int identityHashCode, int id) {
        String className;
        String value = (String)ImageLayerLoader.get(constantData, "value");
        if (value != null) {
            this.injectIdentityHashCode(value.intern(), identityHashCode);
            this.stringToConstant.put(value, id);
        }
        if ((className = (String)ImageLayerLoader.get(constantData, "enum class")) != null) {
            Enum<?> enumValue = this.getEnumValue(constantData);
            this.injectIdentityHashCode(enumValue, identityHashCode);
            this.enumToConstant.put(enumValue, id);
        }
    }

    private void loadType(EconomicMap<String, Object> typeData) {
        int tid = (Integer)ImageLayerLoader.get(typeData, "id");
        if (this.imageLayerLoaderHelper.loadType(typeData, tid)) {
            return;
        }
        String name = (String)ImageLayerLoader.get(typeData, "class java name");
        Class<?> clazz = this.lookupBaseLayerTypeInHostVM(name);
        Integer superClassTid = (Integer)ImageLayerLoader.get(typeData, "super class");
        ResolvedJavaType superClass = this.getResolvedJavaType(superClassTid);
        List interfacesIds = (List)ImageLayerLoader.get(typeData, "interfaces");
        ResolvedJavaType[] interfaces = interfacesIds.stream().map(this::getResolvedJavaType).toList().toArray(new ResolvedJavaType[0]);
        if (clazz != null) {
            this.metaAccess.lookupJavaType((Class)clazz);
        }
        if (!this.types.containsKey(tid)) {
            BaseLayerType baseLayerType = this.getBaseLayerType(typeData, tid, superClass, interfaces);
            List instanceFieldIds = (List)ImageLayerLoader.get(typeData, "instance fields");
            ResolvedJavaField[] instanceFields = instanceFieldIds.stream().map(this::getBaseLayerField).toList().toArray(new ResolvedJavaField[0]);
            baseLayerType.setInstanceFields(instanceFields);
            List instanceFieldWithSuperIds = (List)ImageLayerLoader.get(typeData, "instance fields with super");
            ResolvedJavaField[] instanceFieldsWithSuper = instanceFieldWithSuperIds.stream().map(this::getBaseLayerField).toList().toArray(new ResolvedJavaField[0]);
            baseLayerType.setInstanceFieldsWithSuper(instanceFieldsWithSuper);
            AnalysisType type = this.universe.lookup((JavaType)baseLayerType);
            AnalysisError.guarantee(this.getBaseLayerTypeId(type) == tid, "The base layer type %s is not correctly matched to the id %d", type, tid);
        }
    }

    private BaseLayerType getBaseLayerType(int tid) {
        EconomicMap typesMap = (EconomicMap)ImageLayerLoader.get(this.jsonMap, "types");
        EconomicMap typeData = (EconomicMap)ImageLayerLoader.get((EconomicMap<String, Object>)typesMap, this.typeIdToIdentifier.get(tid));
        Integer superClassTid = (Integer)ImageLayerLoader.get((EconomicMap<String, Object>)typeData, "super class");
        ResolvedJavaType superClass = this.getResolvedJavaType(superClassTid);
        List interfacesIds = (List)ImageLayerLoader.get((EconomicMap<String, Object>)typeData, "interfaces");
        ResolvedJavaType[] interfaces = interfacesIds.stream().map(this::getResolvedJavaType).toList().toArray(new ResolvedJavaType[0]);
        return this.getBaseLayerType((EconomicMap<String, Object>)typeData, tid, superClass, interfaces);
    }

    private BaseLayerType getBaseLayerType(EconomicMap<String, Object> typeData, int tid, ResolvedJavaType superClass, ResolvedJavaType[] interfaces) {
        return this.baseLayerTypes.computeIfAbsent(tid, typeId -> {
            String className = (String)ImageLayerLoader.get(typeData, "class name");
            int modifiers = (Integer)ImageLayerLoader.get(typeData, "modifiers");
            boolean isInterface = (Boolean)ImageLayerLoader.get(typeData, "is interface");
            boolean isEnum = (Boolean)ImageLayerLoader.get(typeData, "is enum");
            boolean isInitialized = (Boolean)ImageLayerLoader.get(typeData, "is initialized");
            boolean initializedAtBuildTime = (Boolean)ImageLayerLoader.get(typeData, "is initialized at build time");
            boolean isLinked = (Boolean)ImageLayerLoader.get(typeData, "is linked");
            String sourceFileName = (String)ImageLayerLoader.get(typeData, "source file name");
            Integer enclosingTid = (Integer)ImageLayerLoader.get(typeData, "enclosing type");
            ResolvedJavaType enclosingType = this.getResolvedJavaType(enclosingTid);
            Integer componentTid = (Integer)ImageLayerLoader.get(typeData, "component type");
            ResolvedJavaType componentType = this.getResolvedJavaType(componentTid);
            ResolvedJavaType objectType = this.universe.getOriginalMetaAccess().lookupJavaType(Object.class);
            Annotation[] annotations = this.getAnnotations(typeData);
            return new BaseLayerType(className, tid, modifiers, isInterface, isEnum, isInitialized, initializedAtBuildTime, isLinked, sourceFileName, enclosingType, componentType, superClass, interfaces, objectType, annotations);
        });
    }

    protected Annotation[] getAnnotations(EconomicMap<String, Object> elementData) {
        return new Annotation[0];
    }

    private ResolvedJavaType getResolvedJavaType(Integer tid) {
        return tid == null ? null : this.getAnalysisType(tid).getWrapped();
    }

    public AnalysisType getAnalysisType(Integer tid) {
        if (!this.types.containsKey(tid)) {
            EconomicMap typesMap = (EconomicMap)ImageLayerLoader.get(this.jsonMap, "types");
            this.loadType((EconomicMap<String, Object>)((EconomicMap)ImageLayerLoader.get((EconomicMap<String, Object>)typesMap, this.typeIdToIdentifier.get(tid))));
        }
        AnalysisError.guarantee(this.types.containsKey(tid), "Type with id %d was not correctly loaded.", tid);
        return this.universe.lookup((JavaType)this.types.get(tid).getWrapped());
    }

    public int lookupHostedTypeInBaseLayer(AnalysisType type) {
        int id = this.getBaseLayerTypeId(type);
        if (id == -1 || this.types.putIfAbsent(id, type) != null) {
            return -1;
        }
        return id;
    }

    private int getBaseLayerTypeId(AnalysisType type) {
        ResolvedJavaType resolvedJavaType = type.getWrapped();
        if (resolvedJavaType instanceof BaseLayerType) {
            BaseLayerType baseLayerType = (BaseLayerType)resolvedJavaType;
            return baseLayerType.getBaseLayerId();
        }
        String typeIdentifier = this.imageLayerSnapshotUtil.getTypeIdentifier(type);
        EconomicMap<String, Object> typeData = this.getElementData("types", typeIdentifier);
        if (typeData == null) {
            return -1;
        }
        int id = (Integer)ImageLayerLoader.get(typeData, "id");
        int hubIdentityHashCode = (Integer)ImageLayerLoader.get(typeData, "hub identityHashCode");
        this.typeToHubIdentityHashCode.put(id, hubIdentityHashCode);
        return id;
    }

    public void initializeBaseLayerType(AnalysisType type) {
        EconomicMap<String, Object> typeData;
        String typeIdentifier = this.typeIdToIdentifier.get(type.getId());
        boolean post = true;
        if (typeIdentifier == null) {
            post = false;
            typeIdentifier = this.imageLayerSnapshotUtil.getTypeIdentifier(type);
        }
        if ((typeData = this.getElementData("types", typeIdentifier)) != null) {
            boolean isInstantiated = (Boolean)ImageLayerLoader.get(typeData, "is instantiated");
            boolean isUnsafeAllocated = (Boolean)ImageLayerLoader.get(typeData, "is unsafe allocated");
            boolean isReachable = (Boolean)ImageLayerLoader.get(typeData, "is reachable");
            this.registerFlag(isInstantiated, post, () -> type.registerAsInstantiated("persisted"));
            this.registerFlag(isUnsafeAllocated, post, () -> type.registerAsUnsafeAllocated("persisted"));
            this.registerFlag(isReachable, post, () -> type.registerAsReachable("persisted"));
        }
    }

    public Class<?> lookupBaseLayerTypeInHostVM(String type) {
        int arrayType = 0;
        String componentType = type;
        while (componentType.endsWith("[]")) {
            componentType = componentType.substring(0, componentType.length() - 2);
            ++arrayType;
        }
        TypeDescriptor.OfField<Class<?>> clazz = ImageLayerLoader.lookupPrimitiveClass(componentType);
        if (clazz == null) {
            clazz = this.lookupClass(true, componentType);
        }
        if (clazz == null) {
            return null;
        }
        while (arrayType > 0) {
            assert (clazz != null);
            clazz = clazz.arrayType();
            --arrayType;
        }
        return clazz;
    }

    private static Class<?> lookupPrimitiveClass(String type) {
        return switch (type) {
            case "boolean" -> Boolean.TYPE;
            case "byte" -> Byte.TYPE;
            case "short" -> Short.TYPE;
            case "char" -> Character.TYPE;
            case "int" -> Integer.TYPE;
            case "long" -> Long.TYPE;
            case "float" -> Float.TYPE;
            case "double" -> Double.TYPE;
            case "void" -> Void.TYPE;
            default -> null;
        };
    }

    private void loadMethod(EconomicMap<String, Object> methodData) {
        Executable method;
        int mid = (Integer)ImageLayerLoader.get(methodData, "id");
        if (this.imageLayerLoaderHelper.loadMethod(methodData, mid)) {
            return;
        }
        int tid = (Integer)ImageLayerLoader.get(methodData, "tid");
        AnalysisType type = this.getAnalysisType(tid);
        List parameterTypeIds = (List)ImageLayerLoader.get(methodData, "argument ids");
        AnalysisType[] parameterTypes = parameterTypeIds.stream().map(this::getAnalysisType).toList().toArray(new AnalysisType[0]);
        AnalysisType returnType = this.getAnalysisType((Integer)ImageLayerLoader.get(methodData, "return type"));
        String name = (String)ImageLayerLoader.get(methodData, "name");
        String className = (String)ImageLayerLoader.get(methodData, "class name");
        if (className != null) {
            List arguments = (List)ImageLayerLoader.get(methodData, "arguments");
            method = null;
            Class<?> clazz = this.lookupBaseLayerTypeInHostVM(className);
            if (clazz != null) {
                Class[] argumentClasses = arguments.stream().map(this::lookupBaseLayerTypeInHostVM).toList().toArray(new Class[0]);
                method = ImageLayerLoader.lookupMethodByReflection(name, clazz, argumentClasses);
            }
            if (method != null) {
                this.metaAccess.lookupJavaMethod(method);
                if (this.methods.containsKey(mid)) {
                    return;
                }
            }
        }
        Class[] argumentClasses = Arrays.stream(parameterTypes).map(AnalysisType::getJavaClass).toList().toArray(new Class[0]);
        method = ImageLayerLoader.lookupMethodByReflection(name, type.getJavaClass(), argumentClasses);
        if (method != null) {
            this.metaAccess.lookupJavaMethod(method);
            if (this.methods.containsKey(mid)) {
                return;
            }
        }
        ResolvedSignature<AnalysisType> signature = ResolvedSignature.fromList(Arrays.stream(parameterTypes).toList(), returnType);
        if (name.equals("<init>")) {
            type.findConstructor(signature);
        } else if (name.equals("<clinit>")) {
            type.getClassInitializer();
        } else {
            type.findMethod(name, signature);
        }
        if (!this.methods.containsKey(mid)) {
            this.createBaseLayerMethod(methodData, mid, name, parameterTypes, returnType);
        }
    }

    public static Executable lookupMethodByReflection(String name, Class<?> clazz, Class<?>[] argumentClasses) {
        try {
            Executable method = name.equals("<init>") ? ReflectionUtil.lookupConstructor((boolean)true, clazz, (Class[])argumentClasses) : ReflectionUtil.lookupMethod((boolean)true, clazz, (String)name, (Class[])argumentClasses);
            return method;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    private void createBaseLayerMethod(EconomicMap<String, Object> methodData, int mid, String name, AnalysisType[] parameterTypes, AnalysisType returnType) {
        AnalysisType type = this.getAnalysisType((Integer)ImageLayerLoader.get(methodData, "tid"));
        ResolvedSignature signature = ResolvedSignature.fromArray((ResolvedJavaType[])parameterTypes, (ResolvedJavaType)returnType);
        boolean canBeStaticallyBound = (Boolean)ImageLayerLoader.get(methodData, "can be statically bound");
        boolean isConstructor = (Boolean)ImageLayerLoader.get(methodData, "is constructor");
        int modifiers = (Integer)ImageLayerLoader.get(methodData, "modifiers");
        boolean isSynthetic = (Boolean)ImageLayerLoader.get(methodData, "is synthetic");
        boolean isVarArgs = (Boolean)ImageLayerLoader.get(methodData, "is varArg");
        List codeEncoding = (List)ImageLayerLoader.get(methodData, "code");
        byte[] code = codeEncoding == null ? null : ImageLayerLoader.getBytes(codeEncoding);
        int codeSize = (Integer)ImageLayerLoader.get(methodData, "code size");
        String methodHandleIntrinsicName = (String)ImageLayerLoader.get(methodData, "method handle intrinsic");
        MethodHandleAccessProvider.IntrinsicMethod methodHandleIntrinsic = methodHandleIntrinsicName == null ? null : MethodHandleAccessProvider.IntrinsicMethod.valueOf((String)methodHandleIntrinsicName);
        Annotation[] annotations = this.getAnnotations(methodData);
        this.baseLayerMethods.computeIfAbsent(mid, methodId -> new BaseLayerMethod(mid, type, name, isVarArgs, signature, canBeStaticallyBound, isConstructor, modifiers, isSynthetic, code, codeSize, methodHandleIntrinsic, annotations));
        BaseLayerMethod baseLayerMethod = this.baseLayerMethods.get(mid);
        this.universe.lookup((JavaMethod)baseLayerMethod);
    }

    public AnalysisMethod getAnalysisMethod(int mid) {
        AnalysisMethod analysisMethod;
        if (!this.methods.containsKey(mid)) {
            EconomicMap methodsMap = (EconomicMap)ImageLayerLoader.get(this.jsonMap, "methods");
            this.loadMethod((EconomicMap<String, Object>)((EconomicMap)ImageLayerLoader.get((EconomicMap<String, Object>)methodsMap, this.methodIdToIdentifier.get(mid))));
        }
        AnalysisError.guarantee((analysisMethod = this.methods.get(mid)) != null, "Method with id %d was not correctly loaded.", mid);
        return analysisMethod;
    }

    public int lookupHostedMethodInBaseLayer(AnalysisMethod analysisMethod) {
        return this.getBaseLayerMethodId(analysisMethod);
    }

    private int getBaseLayerMethodId(AnalysisMethod analysisMethod) {
        ResolvedJavaMethod resolvedJavaMethod = analysisMethod.getWrapped();
        if (resolvedJavaMethod instanceof BaseLayerMethod) {
            BaseLayerMethod baseLayerMethod = (BaseLayerMethod)resolvedJavaMethod;
            return baseLayerMethod.getBaseLayerId();
        }
        EconomicMap<String, Object> methodData = this.getMethodData(analysisMethod);
        if (methodData == null || this.methods.containsKey(analysisMethod.getId())) {
            return -1;
        }
        return (Integer)ImageLayerLoader.get(methodData, "id");
    }

    public void addBaseLayerMethod(AnalysisMethod analysisMethod) {
        this.methods.putIfAbsent(analysisMethod.getId(), analysisMethod);
    }

    public void initializeBaseLayerMethod(AnalysisMethod analysisMethod) {
        this.initializeBaseLayerMethod(analysisMethod, this.getMethodData(analysisMethod));
    }

    protected void initializeBaseLayerMethod(AnalysisMethod analysisMethod, EconomicMap<String, Object> methodData) {
        boolean isVirtualRootMethod = (Boolean)ImageLayerLoader.get(methodData, "is virtual root method");
        boolean isDirectRootMethod = (Boolean)ImageLayerLoader.get(methodData, "is direct root method");
        boolean isInvoked = (Boolean)ImageLayerLoader.get(methodData, "is invoked");
        boolean isImplementationInvoked = (Boolean)ImageLayerLoader.get(methodData, "is implementation invoked");
        boolean isIntrinsicMethod = (Boolean)ImageLayerLoader.get(methodData, "is intrinsic method");
        this.registerFlag(isVirtualRootMethod, true, () -> analysisMethod.registerAsVirtualRootMethod("persisted"));
        this.registerFlag(isDirectRootMethod, true, () -> analysisMethod.registerAsDirectRootMethod("persisted"));
        this.registerFlag(isInvoked, true, () -> analysisMethod.registerAsInvoked("persisted"));
        this.registerFlag(isImplementationInvoked, true, () -> analysisMethod.registerAsImplementationInvoked("persisted"));
        this.registerFlag(isIntrinsicMethod, true, () -> analysisMethod.registerAsIntrinsicMethod("persisted"));
    }

    public boolean hasAnalysisParsedGraph(AnalysisMethod analysisMethod) {
        EconomicMap<String, Object> methodData = this.getMethodData(analysisMethod);
        return ImageLayerLoader.get(methodData, "analysis parsed graph") != null;
    }

    public AnalysisParsedGraph getAnalysisParsedGraph(AnalysisMethod analysisMethod) {
        EconomicMap<String, Object> methodData = this.getMethodData(analysisMethod);
        byte[] encodedAnalyzedGraph = this.readEncodedGraph(methodData, "analysis parsed graph");
        Boolean intrinsic = (Boolean)ImageLayerLoader.get(methodData, "intrinsic");
        EncodedGraph analyzedGraph = (EncodedGraph)ObjectCopier.decode((ObjectCopier.Decoder)this.imageLayerSnapshotUtil.getGraphDecoder(this, analysisMethod, this.universe.getSnippetReflection()), (byte[])encodedAnalyzedGraph);
        if (this.hasStrengthenedGraph(analysisMethod)) {
            throw AnalysisError.shouldNotReachHere("Strengthened graphs are not supported until late loading is implemented.");
        }
        this.afterGraphDecodeHook(analyzedGraph);
        return new AnalysisParsedGraph(analyzedGraph, intrinsic);
    }

    private byte[] readEncodedGraph(EconomicMap<String, Object> methodData, String elementIdentifier) {
        long nbytes;
        long offset;
        String location = (String)ImageLayerLoader.get(methodData, elementIdentifier);
        int closingBracketAt = location.length() - 1;
        AnalysisError.guarantee(location.charAt(0) == '@' && location.charAt(closingBracketAt) == ']', "Location must start with '@' and end with ']': %s", location);
        int openingBracketAt = location.indexOf(91, 1, closingBracketAt);
        AnalysisError.guarantee(openingBracketAt < closingBracketAt, "Location does not contain '[' at expected location: %s", location);
        try {
            offset = Long.parseUnsignedLong(location.substring(1, openingBracketAt));
            nbytes = Long.parseUnsignedLong(location.substring(openingBracketAt + 1, closingBracketAt));
        }
        catch (NumberFormatException e) {
            throw AnalysisError.shouldNotReachHere("Location contains invalid positive integer(s): " + location);
        }
        ByteBuffer bb = ByteBuffer.allocate(NumUtil.safeToInt((long)nbytes));
        try {
            this.graphsChannel.read(bb, offset);
        }
        catch (IOException e) {
            throw AnalysisError.shouldNotReachHere("Failed reading a graph from location: " + location, e);
        }
        return bb.array();
    }

    public boolean hasStrengthenedGraph(AnalysisMethod analysisMethod) {
        EconomicMap<String, Object> methodData = this.getMethodData(analysisMethod);
        return ImageLayerLoader.get(methodData, "strengthened graph") != null;
    }

    public void setStrengthenedGraph(AnalysisMethod analysisMethod) {
        EconomicMap<String, Object> methodData = this.getMethodData(analysisMethod);
        byte[] encodedAnalyzedGraph = this.readEncodedGraph(methodData, "strengthened graph");
        EncodedGraph analyzedGraph = (EncodedGraph)ObjectCopier.decode((ObjectCopier.Decoder)this.imageLayerSnapshotUtil.getGraphDecoder(this, analysisMethod, this.universe.getSnippetReflection()), (byte[])encodedAnalyzedGraph);
        this.afterGraphDecodeHook(analyzedGraph);
        analysisMethod.setAnalyzedGraph(analyzedGraph);
    }

    protected void afterGraphDecodeHook(EncodedGraph encodedGraph) {
    }

    protected static int getId(String line) {
        return Integer.parseInt(line.split(" = ")[1]);
    }

    private EconomicMap<String, Object> getMethodData(AnalysisMethod analysisMethod) {
        int id = analysisMethod.getId();
        String name = this.methodIdToIdentifier.containsKey(id) ? this.methodIdToIdentifier.get(id) : this.imageLayerSnapshotUtil.getMethodIdentifier(analysisMethod);
        return this.getElementData("methods", name);
    }

    private void loadField(FieldIdentifier fieldIdentifier, EconomicMap<String, Object> fieldData) {
        Field field;
        Class<?> clazz;
        AnalysisType declaringClass = this.getAnalysisType(Integer.parseInt(fieldIdentifier.tid));
        String className = (String)ImageLayerLoader.get(fieldData, "class name");
        int id = (Integer)ImageLayerLoader.get(fieldData, "id");
        Class<?> clazz2 = clazz = className != null ? this.lookupBaseLayerTypeInHostVM(className) : declaringClass.getJavaClass();
        if (clazz == null) {
            clazz = declaringClass.getJavaClass();
        }
        try {
            field = ReflectionUtil.lookupField((boolean)true, clazz, (String)fieldIdentifier.name);
        }
        catch (Throwable e) {
            field = null;
        }
        if (field == null && !(declaringClass.getWrapped() instanceof BaseLayerType)) {
            boolean isStatic = (Boolean)ImageLayerLoader.get(fieldData, "is static");
            if (isStatic) {
                declaringClass.getStaticFields();
            } else {
                declaringClass.getInstanceFields(true);
            }
            if (this.fields.containsKey(id)) {
                return;
            }
        }
        if (field == null) {
            AnalysisType type = this.getAnalysisType((Integer)ImageLayerLoader.get(fieldData, "field type"));
            BaseLayerField baseLayerField = this.getBaseLayerField(fieldIdentifier, fieldData, id, declaringClass.getWrapped(), type.getWrapped());
            this.universe.lookup((JavaField)baseLayerField);
        } else {
            this.metaAccess.lookupJavaField(field);
        }
    }

    private BaseLayerField getBaseLayerField(int id) {
        FieldIdentifier fieldIdentifier = this.fieldIdToIdentifier.get(id);
        EconomicMap fieldsMap = (EconomicMap)ImageLayerLoader.get(this.jsonMap, "fields");
        EconomicMap fieldData = (EconomicMap)ImageLayerLoader.get((EconomicMap<String, Object>)((EconomicMap)ImageLayerLoader.get((EconomicMap<String, Object>)fieldsMap, fieldIdentifier.tid)), fieldIdentifier.name);
        BaseLayerType declaringClass = this.getBaseLayerType(Integer.parseInt(fieldIdentifier.tid));
        ResolvedJavaType type = this.getResolvedJavaType((Integer)ImageLayerLoader.get((EconomicMap<String, Object>)fieldData, "field type"));
        return this.getBaseLayerField(fieldIdentifier, (EconomicMap<String, Object>)fieldData, id, declaringClass, type);
    }

    private BaseLayerField getBaseLayerField(FieldIdentifier fieldIdentifier, EconomicMap<String, Object> fieldData, int id, ResolvedJavaType declaringClass, ResolvedJavaType type) {
        return this.baseLayerFields.computeIfAbsent(id, fid -> new BaseLayerField(id, fieldIdentifier.name, declaringClass, type, (Boolean)ImageLayerLoader.get(fieldData, "is internal"), (Boolean)ImageLayerLoader.get(fieldData, "is synthetic"), (Integer)ImageLayerLoader.get(fieldData, "modifiers"), this.getAnnotations(fieldData)));
    }

    public AnalysisField getAnalysisField(int fid) {
        AnalysisField analysisField;
        if (!this.fields.containsKey(fid)) {
            FieldIdentifier fieldIdentifier = this.fieldIdToIdentifier.get(fid);
            EconomicMap fieldsMap = (EconomicMap)ImageLayerLoader.get(this.jsonMap, "fields");
            this.loadField(fieldIdentifier, (EconomicMap<String, Object>)((EconomicMap)ImageLayerLoader.get((EconomicMap<String, Object>)((EconomicMap)ImageLayerLoader.get((EconomicMap<String, Object>)fieldsMap, fieldIdentifier.tid)), fieldIdentifier.name)));
        }
        AnalysisError.guarantee((analysisField = this.fields.get(fid)) != null, "Field with id %d was not correctly loaded.", fid);
        return analysisField;
    }

    public int lookupHostedFieldInBaseLayer(AnalysisField analysisField) {
        return this.getBaseLayerFieldId(analysisField);
    }

    private int getBaseLayerFieldId(AnalysisField analysisField) {
        ResolvedJavaField resolvedJavaField = analysisField.wrapped;
        if (resolvedJavaField instanceof BaseLayerField) {
            BaseLayerField baseLayerField = (BaseLayerField)resolvedJavaField;
            return baseLayerField.getBaseLayerId();
        }
        EconomicMap<String, Object> fieldData = this.getFieldData(analysisField);
        if (fieldData == null) {
            return -1;
        }
        return (Integer)ImageLayerLoader.get(fieldData, "id");
    }

    public void addBaseLayerField(AnalysisField analysisField) {
        this.fields.putIfAbsent(analysisField.getId(), analysisField);
    }

    public void initializeBaseLayerField(AnalysisField analysisField) {
        EconomicMap<String, Object> fieldData = this.getFieldData(analysisField);
        assert (fieldData != null) : "The field should be in the base layer";
        Integer location = (Integer)ImageLayerLoader.get(fieldData, "location");
        if (location != null) {
            this.fieldLocations.put(analysisField, location);
        }
        boolean isAccessed = (Boolean)ImageLayerLoader.get(fieldData, "accessed");
        boolean isRead = (Boolean)ImageLayerLoader.get(fieldData, "read");
        boolean isWritten = (Boolean)ImageLayerLoader.get(fieldData, "written");
        boolean isFolded = (Boolean)ImageLayerLoader.get(fieldData, "folded");
        if (!analysisField.isStatic() && (isAccessed || isRead)) {
            analysisField.getDeclaringClass().getInstanceFields(true);
        }
        this.registerFlag(isAccessed, true, () -> analysisField.registerAsAccessed("persisted"));
        this.registerFlag(isRead, true, () -> analysisField.registerAsRead("persisted"));
        this.registerFlag(isWritten, true, () -> analysisField.registerAsWritten("persisted"));
        this.registerFlag(isFolded, true, () -> analysisField.registerAsFolded("persisted"));
    }

    protected EconomicMap<String, Object> getFieldData(AnalysisField analysisField) {
        int tid = analysisField.getDeclaringClass().getId();
        EconomicMap<String, Object> typeFieldsMap = this.getElementData("fields", Integer.toString(tid));
        if (typeFieldsMap == null) {
            return null;
        }
        return (EconomicMap)ImageLayerLoader.get(typeFieldsMap, analysisField.getName());
    }

    private void registerFlag(boolean flag, boolean post, Runnable runnable) {
        if (flag) {
            if (this.universe.getBigbang() != null) {
                if (post) {
                    this.universe.getBigbang().postTask(debug -> runnable.run());
                } else {
                    runnable.run();
                }
            } else {
                this.heapScannerTasks.add(new AnalysisFuture(runnable));
            }
        }
    }

    public void executeHeapScannerTasks() {
        AnalysisError.guarantee(this.universe.getHeapScanner() != null, "Those tasks should only be executed when the bigbang is not null.", new Object[0]);
        for (AnalysisFuture<Void> task : this.heapScannerTasks) {
            task.ensureDone();
        }
    }

    protected ImageHeapConstant getOrCreateConstant(EconomicMap<String, Object> constantsMap, int id, JavaConstant parentReachableHostedObjectCandidate) {
        String constantType;
        JavaConstant parentReachableHostedObject;
        if (this.constants.containsKey(id)) {
            return this.constants.get(id);
        }
        EconomicMap baseLayerConstant = (EconomicMap)ImageLayerLoader.get(constantsMap, Integer.toString(id));
        if (baseLayerConstant == null) {
            throw GraalError.shouldNotReachHere((String)"The constant was not reachable in the base image");
        }
        int tid = (Integer)ImageLayerLoader.get((EconomicMap<String, Object>)baseLayerConstant, "tid");
        AnalysisType type = this.getAnalysisType(tid);
        String objectOffset = (String)ImageLayerLoader.get((EconomicMap<String, Object>)baseLayerConstant, "object offset");
        int identityHashCode = (Integer)ImageLayerLoader.get((EconomicMap<String, Object>)baseLayerConstant, "identityHashCode");
        if (parentReachableHostedObjectCandidate == null) {
            Integer parentConstantId = (Integer)ImageLayerLoader.get((EconomicMap<String, Object>)baseLayerConstant, "parent constant id");
            if (parentConstantId != null) {
                ImageHeapConstant parentConstant = this.getOrCreateConstant(parentConstantId);
                int index = (Integer)ImageLayerLoader.get((EconomicMap<String, Object>)baseLayerConstant, "parent constant index");
                parentReachableHostedObject = this.getReachableHostedValue(parentConstant, index);
            } else {
                parentReachableHostedObject = null;
            }
        } else {
            parentReachableHostedObject = parentReachableHostedObjectCandidate;
        }
        if (parentReachableHostedObject != null && !type.getJavaClass().equals(Class.class)) {
            this.injectIdentityHashCode(this.hostedValuesProvider.asObject(Object.class, parentReachableHostedObject), identityHashCode);
        }
        switch (constantType = (String)ImageLayerLoader.get((EconomicMap<String, Object>)baseLayerConstant, "constant type")) {
            case "instance": {
                List instanceData = (List)ImageLayerLoader.get((EconomicMap<String, Object>)baseLayerConstant, "data");
                JavaConstant foundHostedObject = this.lookupHostedObject((EconomicMap<String, Object>)baseLayerConstant, type);
                if (foundHostedObject != null && parentReachableHostedObject != null) {
                    Object reachableObject;
                    Object foundObject = this.hostedValuesProvider.asObject(Object.class, foundHostedObject);
                    AnalysisError.guarantee(foundObject == (reachableObject = this.hostedValuesProvider.asObject(Object.class, parentReachableHostedObject)), "Found discrepancy between recipe-found hosted value %s and parent-reachable hosted value %s.", foundObject, reachableObject);
                }
                this.addBaseLayerObject(id, objectOffset, () -> {
                    ImageHeapInstance imageHeapInstance = new ImageHeapInstance(type, foundHostedObject == null ? parentReachableHostedObject : foundHostedObject, identityHashCode, id);
                    if (instanceData != null) {
                        Object[] fieldValues = this.getReferencedValues(constantsMap, imageHeapInstance, instanceData, this.imageLayerSnapshotUtil.getRelinkedFields(type, this.metaAccess));
                        imageHeapInstance.setFieldValues(fieldValues);
                    }
                    return imageHeapInstance;
                });
                break;
            }
            case "array": {
                List arrayData = (List)ImageLayerLoader.get((EconomicMap<String, Object>)baseLayerConstant, "data");
                this.addBaseLayerObject(id, objectOffset, () -> {
                    ImageHeapObjectArray imageHeapObjectArray = new ImageHeapObjectArray(type, null, arrayData.size(), identityHashCode, id);
                    Object[] elementsValues = this.getReferencedValues(constantsMap, imageHeapObjectArray, arrayData, Set.of());
                    imageHeapObjectArray.setElementValues(elementsValues);
                    return imageHeapObjectArray;
                });
                break;
            }
            case "primitive array": {
                List primitiveData = (List)ImageLayerLoader.get((EconomicMap<String, Object>)baseLayerConstant, "data");
                Object array = ImageLayerLoader.getArray(type.getComponentType().getJavaKind(), primitiveData);
                this.addBaseLayerObject(id, objectOffset, () -> new ImageHeapPrimitiveArray(type, null, array, primitiveData.size(), identityHashCode, id));
                break;
            }
            case "relocation constant": {
                String key = (String)ImageLayerLoader.get((EconomicMap<String, Object>)baseLayerConstant, "data");
                this.addBaseLayerObject(id, objectOffset, () -> ImageHeapRelocatableConstant.create(type, key, id));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)("Unknown constant type: " + constantType));
            }
        }
        return this.constants.get(id);
    }

    protected JavaConstant lookupHostedObject(EconomicMap<String, Object> baseLayerConstant, AnalysisType analysisType) {
        boolean simulated = (Boolean)ImageLayerLoader.get(baseLayerConstant, "simulated");
        if (!simulated) {
            Class<?> clazz = analysisType.getJavaClass();
            return this.lookupHostedObject(baseLayerConstant, clazz);
        }
        return null;
    }

    protected JavaConstant lookupHostedObject(EconomicMap<String, Object> baseLayerConstant, Class<?> clazz) {
        if (clazz.equals(String.class)) {
            String value = (String)ImageLayerLoader.get(baseLayerConstant, "value");
            if (value != null) {
                String object = value.intern();
                return this.hostedValuesProvider.forObject(object);
            }
        } else if (Enum.class.isAssignableFrom(clazz)) {
            Enum<?> enumValue = this.getEnumValue(baseLayerConstant);
            return this.hostedValuesProvider.forObject(enumValue);
        }
        return null;
    }

    protected void injectIdentityHashCode(Object object, Integer identityHashCode) {
    }

    private static Object getArray(JavaKind kind, Object listObject) {
        return switch (kind) {
            case JavaKind.Boolean -> ImageLayerLoader.getBooleans((List)listObject);
            case JavaKind.Byte -> (Object[])ImageLayerLoader.getBytes((List)listObject);
            case JavaKind.Short -> (Object[])ImageLayerLoader.getShorts((List)listObject);
            case JavaKind.Char -> (Object[])((List)listObject).stream().mapToInt(i -> i).mapToObj(i -> Character.toString((char)i)).collect(Collectors.joining()).toCharArray();
            case JavaKind.Int -> (Object[])((List)listObject).stream().mapToInt(i -> i).toArray();
            case JavaKind.Long -> (Object[])((List)listObject).stream().mapToLong(Long::parseLong).toArray();
            case JavaKind.Float -> (Object[])ImageLayerLoader.getFloats((List)listObject);
            case JavaKind.Double -> (Object[])((List)listObject).stream().mapToDouble(Double::parseDouble).toArray();
            default -> throw new IllegalArgumentException("Unsupported kind: " + String.valueOf(kind));
        };
    }

    private static float[] getFloats(List<String> listObject) {
        float[] primitiveFloats = new float[listObject.size()];
        for (int i = 0; i < listObject.size(); ++i) {
            primitiveFloats[i] = Float.parseFloat(listObject.get(i));
        }
        return primitiveFloats;
    }

    private static byte[] getBytes(List<Integer> listObject) {
        byte[] primitiveBytes = new byte[listObject.size()];
        for (int i = 0; i < listObject.size(); ++i) {
            primitiveBytes[i] = (byte)listObject.get(i).intValue();
        }
        return primitiveBytes;
    }

    private static short[] getShorts(List<Integer> listObject) {
        short[] primitiveShorts = new short[listObject.size()];
        for (int i = 0; i < listObject.size(); ++i) {
            primitiveShorts[i] = (short)listObject.get(i).intValue();
        }
        return primitiveShorts;
    }

    private static boolean[] getBooleans(List<Boolean> listObject) {
        boolean[] primitiveBooleans = new boolean[listObject.size()];
        for (int i = 0; i < listObject.size(); ++i) {
            primitiveBooleans[i] = listObject.get(i);
        }
        return primitiveBooleans;
    }

    private Object[] getReferencedValues(EconomicMap<String, Object> constantsMap, ImageHeapConstant parentConstant, List<List<Object>> data, Set<Integer> positionsToRelink) {
        Object[] values = new Object[data.size()];
        for (int position = 0; position < data.size(); ++position) {
            Object constantValue;
            List<Object> constantData = data.get(position);
            String constantKind = (String)constantData.get(0);
            if (this.delegateProcessing(constantKind, constantValue = constantData.get(1), constantData, values, position)) continue;
            if (constantKind.equals("A")) {
                int constantId = (Integer)constantValue;
                if (constantId >= 0) {
                    boolean relink = positionsToRelink.contains(position);
                    int finalPosition = position;
                    values[position] = new AnalysisFuture<ImageHeapConstant>(() -> {
                        this.ensureHubInitialized(parentConstant);
                        JavaConstant hostedConstant = relink ? this.getReachableHostedValue(parentConstant, finalPosition) : null;
                        ImageHeapConstant baseLayerConstant = this.getOrCreateConstant(constantsMap, constantId, hostedConstant);
                        values[finalPosition] = baseLayerConstant;
                        this.ensureHubInitialized(baseLayerConstant);
                        if (hostedConstant != null) {
                            this.addBaseLayerValueToImageHeap(baseLayerConstant, parentConstant, finalPosition);
                        }
                        return baseLayerConstant;
                    });
                    continue;
                }
                if (constantId == -1) {
                    values[position] = JavaConstant.NULL_POINTER;
                    continue;
                }
                AnalysisError.guarantee(constantId == -2);
                values[position] = new AnalysisFuture<Object>(() -> {
                    throw AnalysisError.shouldNotReachHere("This constant was not materialized in the base image.");
                });
                continue;
            }
            JavaKind kind = JavaKind.fromTypeString((String)constantKind);
            values[position] = ImageLayerLoader.getPrimitiveValue(kind, constantValue);
        }
        return values;
    }

    protected boolean delegateProcessing(String constantType, Object constantValue, List<Object> constantData, Object[] values, int i) {
        return false;
    }

    private JavaConstant getReachableHostedValue(ImageHeapConstant parentConstant, int index) {
        if (parentConstant instanceof ImageHeapObjectArray) {
            ImageHeapObjectArray array = (ImageHeapObjectArray)parentConstant;
            return this.getHostedElementValue(array, index);
        }
        if (parentConstant instanceof ImageHeapInstance) {
            ImageHeapInstance instance = (ImageHeapInstance)parentConstant;
            AnalysisField field = ImageLayerLoader.getFieldFromIndex(instance, index);
            return this.getHostedFieldValue(instance, field);
        }
        throw AnalysisError.shouldNotReachHere("unexpected constant: " + String.valueOf(parentConstant));
    }

    private static AnalysisField getFieldFromIndex(ImageHeapInstance instance, int i) {
        return (AnalysisField)instance.getType().getInstanceFields(true)[i];
    }

    private JavaConstant getHostedElementValue(ImageHeapObjectArray array, int idx) {
        JavaConstant hostedArray = array.getHostedObject();
        JavaConstant rawElementValue = null;
        if (hostedArray != null) {
            rawElementValue = this.hostedValuesProvider.readArrayElement(hostedArray, idx);
        }
        return rawElementValue;
    }

    private JavaConstant getHostedFieldValue(ImageHeapInstance instance, AnalysisField field) {
        ValueSupplier<JavaConstant> rawFieldValue;
        try {
            JavaConstant hostedInstance = instance.getHostedObject();
            AnalysisError.guarantee(hostedInstance != null);
            rawFieldValue = this.universe.getHeapScanner().readHostedFieldValue(field, hostedInstance);
        }
        catch (InternalError | LinkageError | TypeNotPresentException e) {
            return null;
        }
        return rawFieldValue.get();
    }

    public void addBaseLayerValueToImageHeap(ImageHeapConstant constant, ImageHeapConstant parentConstant, int i) {
        if (parentConstant instanceof ImageHeapInstance) {
            ImageHeapInstance imageHeapInstance = (ImageHeapInstance)parentConstant;
            this.universe.getHeapScanner().registerBaseLayerValue(constant, ImageLayerLoader.getFieldFromIndex(imageHeapInstance, i));
        } else if (parentConstant instanceof ImageHeapObjectArray) {
            this.universe.getHeapScanner().registerBaseLayerValue(constant, i);
        } else {
            throw AnalysisError.shouldNotReachHere("unexpected constant: " + String.valueOf(constant));
        }
    }

    public void ensureHubInitialized(ImageHeapConstant constant) {
    }

    public void rescanHub(AnalysisType type, Object hubObject) {
    }

    private static PrimitiveConstant getPrimitiveValue(JavaKind kind, Object value) {
        return switch (kind) {
            case JavaKind.Boolean -> JavaConstant.forBoolean(((Integer)value != 0 ? 1 : 0) != 0);
            case JavaKind.Byte -> JavaConstant.forByte((byte)((byte)((Integer)value).intValue()));
            case JavaKind.Short -> JavaConstant.forShort((short)((short)((Integer)value).intValue()));
            case JavaKind.Char -> JavaConstant.forChar((char)((char)Integer.parseInt((String)value)));
            case JavaKind.Int -> JavaConstant.forInt((int)((Integer)value));
            case JavaKind.Long -> JavaConstant.forLong((long)Long.parseLong((String)value));
            case JavaKind.Float -> JavaConstant.forFloat((float)Float.parseFloat((String)value));
            case JavaKind.Double -> JavaConstant.forDouble((double)ImageLayerLoader.getDouble(value));
            default -> throw AnalysisError.shouldNotReachHere("Unexpected kind: " + String.valueOf(kind));
        };
    }

    private static double getDouble(Object value) {
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            AnalysisError.guarantee(integer == 0);
            return 0.0;
        }
        return Double.longBitsToDouble((Long)value);
    }

    private void addBaseLayerObject(int id, String objectOffset, Supplier<ImageHeapConstant> imageHeapConstantSupplier) {
        this.constants.computeIfAbsent(id, key -> {
            ImageHeapConstant heapObj = (ImageHeapConstant)imageHeapConstantSupplier.get();
            heapObj.markInBaseLayer();
            if (heapObj.getType().getJavaClass().equals(Package.class)) {
                this.universe.getHeapScanner().doScan(heapObj);
            }
            if (objectOffset != null) {
                this.objectOffsets.put(heapObj.constantData.id, Long.parseLong(objectOffset));
            }
            return heapObj;
        });
    }

    private EconomicMap<String, Object> getElementData(String registry, String elementIdentifier) {
        EconomicMap innerMap = (EconomicMap)ImageLayerLoader.get(this.jsonMap, registry);
        if (innerMap == null) {
            return null;
        }
        return (EconomicMap)ImageLayerLoader.get((EconomicMap<String, Object>)innerMap, elementIdentifier);
    }

    protected Enum<?> getEnumValue(EconomicMap<String, Object> enumData) {
        String className = (String)ImageLayerLoader.get(enumData, "enum class");
        Class<?> enumClass = this.lookupClass(false, className);
        String name = (String)ImageLayerLoader.get(enumData, "enum name");
        return Enum.valueOf(enumClass.asSubclass(Enum.class), name);
    }

    public Class<?> lookupClass(boolean optional, String className) {
        return ReflectionUtil.lookupClass((boolean)optional, (String)className);
    }

    public static <T> T get(EconomicMap<String, Object> innerMap, String elementIdentifier) {
        return ImageLayerLoader.cast(innerMap.get((Object)elementIdentifier));
    }

    private static <T> T getValue(MapCursor<String, Object> mapCursor) {
        return ImageLayerLoader.cast(mapCursor.getValue());
    }

    protected static <T> T cast(Object object) {
        return (T)object;
    }

    public boolean hasValueForConstant(JavaConstant javaConstant) {
        Object object = this.hostedValuesProvider.asObject(Object.class, javaConstant);
        return this.hasValueForObject(object);
    }

    @SuppressFBWarnings(value={"ES"}, justification="Reference equality check needed to detect intern status")
    protected boolean hasValueForObject(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return this.stringToConstant.containsKey(string) && string.intern() == string;
        }
        if (object instanceof Enum) {
            return this.enumToConstant.containsKey(object);
        }
        return false;
    }

    public ImageHeapConstant getValueForConstant(JavaConstant javaConstant) {
        Object object = this.hostedValuesProvider.asObject(Object.class, javaConstant);
        return this.getValueForObject(object);
    }

    protected ImageHeapConstant getValueForObject(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            int id = this.stringToConstant.get(string);
            return this.getOrCreateConstant(id);
        }
        if (object instanceof Enum) {
            int id = this.enumToConstant.get(object);
            return this.getOrCreateConstant(id);
        }
        throw AnalysisError.shouldNotReachHere("The constant was not in the persisted heap.");
    }

    public ImageHeapConstant getOrCreateConstant(int id) {
        return this.getOrCreateConstant((EconomicMap<String, Object>)((EconomicMap)ImageLayerLoader.get(this.jsonMap, "constants")), id, null);
    }

    public AnalysisMetaAccess getMetaAccess() {
        return this.metaAccess;
    }

    public void setMetaAccess(AnalysisMetaAccess metaAccess) {
        this.metaAccess = metaAccess;
    }

    public void setHostedValuesProvider(HostedValuesProvider hostedValuesProvider) {
        this.hostedValuesProvider = hostedValuesProvider;
    }

    public Set<Integer> getRelinkedFields(AnalysisType type) {
        return this.imageLayerSnapshotUtil.getRelinkedFields(type, this.metaAccess);
    }

    public Long getObjectOffset(JavaConstant javaConstant) {
        ImageHeapConstant imageHeapConstant = (ImageHeapConstant)javaConstant;
        return this.objectOffsets.get(imageHeapConstant.constantData.id);
    }

    public int getFieldLocation(AnalysisField field) {
        return this.fieldLocations.get(field);
    }

    public ImageHeapConstant getBaseLayerStaticPrimitiveFields() {
        return this.getTaggedImageHeapConstant("static primitive fields");
    }

    public ImageHeapConstant getBaseLayerStaticObjectFields() {
        return this.getTaggedImageHeapConstant("static object fields");
    }

    private ImageHeapConstant getTaggedImageHeapConstant(String tag) {
        int id = (Integer)ImageLayerLoader.get(this.jsonMap, tag);
        return this.getOrCreateConstant(id);
    }

    public long getImageHeapSize() {
        return this.imageHeapSize;
    }

    public boolean hasDynamicHubIdentityHashCode(int tid) {
        return this.typeToHubIdentityHashCode.containsKey(tid);
    }

    public int getDynamicHubIdentityHashCode(int tid) {
        return this.typeToHubIdentityHashCode.get(tid);
    }

    public record FilePaths(Path snapshot, Path snapshotGraphs) {
    }

    record FieldIdentifier(String tid, String name) {
    }
}

