/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class ClassInclusionPolicy {
    protected BigBang bb;
    protected final Object reason;

    public ClassInclusionPolicy(Object reason) {
        this.reason = reason;
    }

    public void setBigBang(BigBang bb) {
        this.bb = bb;
    }

    public static boolean isClassIncludedBase(Class<?> cls) {
        if (Feature.class.isAssignableFrom(cls)) {
            return false;
        }
        if (AnnotationAccess.isAnnotationPresent(cls, TargetClass.class)) {
            return false;
        }
        try {
            Class<?> enclosingClass = cls.getEnclosingClass();
            return enclosingClass == null || ClassInclusionPolicy.isClassIncludedBase(enclosingClass);
        }
        catch (LinkageError e) {
            return true;
        }
    }

    public boolean isClassIncluded(Class<?> cls) {
        Class<?> enclosingClass = cls.getEnclosingClass();
        return ClassInclusionPolicy.isClassIncludedBase(cls) && (enclosingClass == null || this.isClassIncluded(enclosingClass));
    }

    public boolean isMethodIncluded(Executable method) {
        return this.isMethodIncluded(this.bb.getMetaAccess().lookupJavaMethod(method));
    }

    public boolean isMethodIncluded(AnalysisMethod method) {
        return !AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, Fold.class);
    }

    public boolean isFieldIncluded(Field field) {
        if (!this.bb.getHostVM().platformSupported(field)) {
            return false;
        }
        return this.bb.getHostVM().isFieldIncluded(this.bb, field);
    }

    public boolean isFieldIncluded(AnalysisField field) {
        if (!this.bb.getHostVM().platformSupported(field)) {
            return false;
        }
        return this.bb.getHostVM().isFieldIncluded(this.bb, field);
    }

    public void includeClass(Class<?> cls) {
        if (Modifier.isAbstract(cls.getModifiers()) || cls.isInterface() || cls.isPrimitive()) {
            this.bb.getMetaAccess().lookupJavaType((Class)cls).registerAsReachable(this.reason);
        } else {
            this.bb.getMetaAccess().lookupJavaType((Class)cls).registerAsInstantiated(this.reason);
        }
    }

    public abstract void includeMethod(Executable var1);

    public abstract void includeMethod(AnalysisMethod var1);

    public void includeField(Field field) {
        this.bb.postTask(debug -> this.bb.addRootField(field));
    }

    public void includeField(AnalysisField field) {
        this.bb.postTask(debug -> this.bb.addRootField(field));
    }

    protected boolean isAccessible(Member member) {
        Class<?> cls = member.getDeclaringClass();
        int modifiers = member.getModifiers();
        return this.isAccessible(cls, modifiers);
    }

    protected boolean isAccessible(Class<?> cls, int modifiers) {
        return Modifier.isPublic(modifiers) || !Modifier.isFinal(cls.getModifiers()) && !cls.isSealed() && Modifier.isProtected(modifiers);
    }

    public static class DefaultAllInclusionPolicy
    extends ClassInclusionPolicy {
        public DefaultAllInclusionPolicy(Object reason) {
            super(reason);
        }

        @Override
        public void includeMethod(Executable method) {
            this.bb.postTask(debug -> this.bb.addRootMethod(method, method instanceof Constructor, this.reason, new MultiMethod.MultiMethodKey[0]));
        }

        @Override
        public void includeMethod(AnalysisMethod method) {
            this.bb.postTask(debug -> this.bb.addRootMethod(method, method.isConstructor(), this.reason, new MultiMethod.MultiMethodKey[0]));
        }
    }

    public static class LayeredBaseImageInclusionPolicy
    extends ClassInclusionPolicy {
        public LayeredBaseImageInclusionPolicy(Object reason) {
            super(reason);
        }

        @Override
        public boolean isClassIncluded(Class<?> cls) {
            if (!super.isClassIncluded(cls)) {
                return false;
            }
            Class<?> enclosingClass = cls.getEnclosingClass();
            int classModifiers = cls.getModifiers();
            if (enclosingClass != null) {
                return this.isAccessible(enclosingClass, classModifiers) && this.isClassIncluded(enclosingClass);
            }
            return Modifier.isPublic(classModifiers);
        }

        @Override
        public boolean isMethodIncluded(Executable method) {
            return !Modifier.isAbstract(method.getModifiers()) && this.isAccessible(method) && super.isMethodIncluded(method);
        }

        @Override
        public void includeMethod(Executable method) {
            this.bb.postTask(debug -> {
                Class<?> declaringClass = method.getDeclaringClass();
                AnalysisMethod analysisMethod = this.bb.getMetaAccess().lookupJavaMethod(method);
                this.registerMethod(method.getModifiers(), declaringClass, analysisMethod);
                this.bb.forcedAddRootMethod(analysisMethod, analysisMethod.isConstructor(), this.reason, new MultiMethod.MultiMethodKey[0]);
            });
        }

        @Override
        public void includeMethod(AnalysisMethod method) {
            this.bb.postTask(debug -> {
                Class<?> declaringClass = method.getDeclaringClass().getJavaClass();
                this.registerMethod(method.getModifiers(), declaringClass, method);
                this.bb.forcedAddRootMethod(method, method.isConstructor(), this.reason, new MultiMethod.MultiMethodKey[0]);
            });
        }

        private void registerMethod(int methodModifiers, Class<?> declaringClass, AnalysisMethod analysisMethod) {
            if (!Modifier.isAbstract(methodModifiers) && (declaringClass.isInterface() || Modifier.isAbstract(declaringClass.getModifiers()))) {
                analysisMethod.registerAsDirectRootMethod(this.reason);
                analysisMethod.registerAsImplementationInvoked(this.reason);
            }
        }
    }
}

