/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public abstract class OffsetStoreTypeFlow
extends TypeFlow<BytecodePosition> {
    protected final AnalysisType objectType;
    protected final TypeFlow<?> valueFlow;
    protected TypeFlow<?> objectFlow;
    boolean isContextInsensitive;

    public OffsetStoreTypeFlow(BytecodePosition storeLocation, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
        super(storeLocation, componentType);
        this.objectType = objectType;
        this.valueFlow = valueFlow;
        this.objectFlow = objectFlow;
    }

    public OffsetStoreTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, OffsetStoreTypeFlow original) {
        super(original, methodFlows);
        this.objectType = original.objectType;
        this.valueFlow = original.valueFlow != null ? methodFlows.lookupCloneOf(bb, original.valueFlow) : null;
        this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
    }

    @Override
    public TypeFlow<?> receiver() {
        return this.objectFlow;
    }

    @Override
    public abstract TypeFlow<BytecodePosition> copy(PointsToAnalysis var1, MethodFlowsGraph var2);

    @Override
    public void setObserved(TypeFlow<?> newObjectFlow) {
        this.objectFlow = newObjectFlow;
    }

    @Override
    public abstract void onObservedUpdate(PointsToAnalysis var1);

    @Override
    public abstract void onObservedSaturated(PointsToAnalysis var1, TypeFlow<?> var2);

    public void markAsContextInsensitive() {
        this.isContextInsensitive = true;
    }

    @Override
    public boolean isContextInsensitive() {
        return this.isContextInsensitive;
    }

    public static class UnsafeStoreTypeFlow
    extends OffsetStoreTypeFlow {
        public UnsafeStoreTypeFlow(BytecodePosition storeLocation, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super(storeLocation, objectType, UnsafeStoreTypeFlow.filterUncheckedInterface(componentType), objectFlow, valueFlow);
        }

        public UnsafeStoreTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, UnsafeStoreTypeFlow original) {
            super(bb, methodFlows, original);
        }

        public final UnsafeStoreTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new UnsafeStoreTypeFlow(bb, methodFlows, this);
        }

        @Override
        public boolean needsInitialization() {
            return true;
        }

        @Override
        public void initFlow(PointsToAnalysis bb) {
            assert (!bb.analysisPolicy().isContextSensitiveAnalysis() || this.isClone()) : this;
            bb.registerUnsafeStore(this);
            this.forceUpdate(bb);
        }

        public void forceUpdate(PointsToAnalysis bb) {
            for (AnalysisField field : bb.getUniverse().getUnsafeAccessedStaticFields()) {
                this.addUse(bb, field.getStaticFieldFlow().filterFlow(bb));
            }
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            TypeState objectState = this.objectFlow.getState();
            for (AnalysisObject object : objectState.objects(bb)) {
                AnalysisType type = object.type();
                if (type.isArray()) {
                    if (object.isPrimitiveArray() || object.isEmptyObjectArrayConstant(bb)) continue;
                    ArrayElementsTypeFlow elementsFlow = object.getArrayElementsFlow(bb, true);
                    this.addUse(bb, elementsFlow);
                    continue;
                }
                for (AnalysisField field : type.unsafeAccessedFields()) {
                    this.addUse(bb, object.getInstanceFieldFilterFlow(bb, this.objectFlow, (BytecodePosition)this.source, field));
                }
            }
        }

        @Override
        public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
            this.objectFlow.removeObserver(this);
            this.valueFlow.removeUse(this);
            UnsafeStoreTypeFlow contextInsensitiveStore = ((PointsToAnalysisType)this.objectType).initAndGetContextInsensitiveUnsafeStore(bb, (BytecodePosition)this.source);
            this.valueFlow.addUse(bb, contextInsensitiveStore);
        }

        @Override
        public String toString() {
            return "UnsafeStoreTypeFlow<" + this.getStateDescription() + ">";
        }
    }

    public static class StoreIndexedTypeFlow
    extends OffsetStoreTypeFlow {
        public StoreIndexedTypeFlow(BytecodePosition storeLocation, AnalysisType arrayType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super(storeLocation, arrayType, arrayType.getComponentType(), objectFlow, valueFlow);
        }

        public StoreIndexedTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, StoreIndexedTypeFlow original) {
            super(bb, methodFlows, original);
        }

        public StoreIndexedTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new StoreIndexedTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            TypeState objectState = this.objectFlow.getState();
            for (AnalysisObject object : objectState.objects(bb)) {
                if (bb.analysisPolicy().relaxTypeFlowConstraints() && !object.type().isArray() || object.isPrimitiveArray() || object.isEmptyObjectArrayConstant(bb)) continue;
                ArrayElementsTypeFlow elementsFlow = object.getArrayElementsFlow(bb, true);
                this.addUse(bb, elementsFlow);
            }
        }

        @Override
        public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
            this.objectFlow.removeObserver(this);
            this.valueFlow.removeUse(this);
            StoreIndexedTypeFlow contextInsensitiveStore = ((PointsToAnalysisType)this.objectType).initAndGetContextInsensitiveIndexedStore(bb, (BytecodePosition)this.source);
            this.valueFlow.addUse(bb, contextInsensitiveStore);
        }

        @Override
        public String toString() {
            return "StoreIndexedTypeFlow<" + this.getStateDescription() + ">";
        }
    }
}

