/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shaded.org.capnproto;

import com.oracle.svm.shaded.org.capnproto.StructSize;
import com.oracle.svm.shaded.org.capnproto.WirePointer;
import java.nio.ByteBuffer;

final class StructPointer {
    StructPointer() {
    }

    public static int dataSize(long ref) {
        return WirePointer.upper32Bits(ref) & 0xFFFF;
    }

    public static int ptrCount(long ref) {
        return WirePointer.upper32Bits(ref) >>> 16;
    }

    public static int wordSize(long ref) {
        return StructPointer.dataSize(ref) + StructPointer.ptrCount(ref);
    }

    public static void setFromStructSize(ByteBuffer buffer, int offset, StructSize size) {
        buffer.putShort(8 * offset + 4, size.data);
        buffer.putShort(8 * offset + 6, size.pointers);
    }

    public static void set(ByteBuffer buffer, int offset, short dataSize, short pointerCount) {
        buffer.putShort(8 * offset + 4, dataSize);
        buffer.putShort(8 * offset + 6, pointerCount);
    }
}

