/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonPrinter;
import jdk.graal.compiler.util.json.JsonWriter;

public record LambdaConfigurationTypeDescriptor(ConfigurationTypeDescriptor declaringClass, ConfigurationParser.ConfigurationMethodDescriptor declaringMethod, List<NamedConfigurationTypeDescriptor> interfaces) implements ConfigurationTypeDescriptor
{
    public static final ConfigurationTypeDescriptor[] EMPTY_TYPE_DESCRIPTOR_ARRAY = new ConfigurationTypeDescriptor[0];

    public static LambdaConfigurationTypeDescriptor fromReflectionNames(String declaringClass, List<String> interfaces) {
        return new LambdaConfigurationTypeDescriptor(NamedConfigurationTypeDescriptor.fromReflectionName(declaringClass), null, LambdaConfigurationTypeDescriptor.getNamedConfigurationTypeDescriptors(interfaces));
    }

    public static LambdaConfigurationTypeDescriptor fromTypeNames(String declaringClass, List<String> interfaces) {
        return new LambdaConfigurationTypeDescriptor(NamedConfigurationTypeDescriptor.fromTypeName(declaringClass), null, LambdaConfigurationTypeDescriptor.getNamedConfigurationTypeDescriptors(interfaces));
    }

    private static List<NamedConfigurationTypeDescriptor> getNamedConfigurationTypeDescriptors(List<String> interfaces) {
        ArrayList<NamedConfigurationTypeDescriptor> reflectionInterfaces = new ArrayList<NamedConfigurationTypeDescriptor>(interfaces.size());
        for (String interfaceName : interfaces) {
            reflectionInterfaces.add(NamedConfigurationTypeDescriptor.fromReflectionName(interfaceName));
        }
        return reflectionInterfaces;
    }

    @Override
    public ConfigurationTypeDescriptor.Kind getDescriptorType() {
        return ConfigurationTypeDescriptor.Kind.LAMBDA;
    }

    @Override
    public Collection<String> getAllQualifiedJavaNames() {
        ArrayList<String> allNames = new ArrayList<String>(this.declaringClass.getAllQualifiedJavaNames());
        for (ConfigurationTypeDescriptor configurationTypeDescriptor : this.interfaces) {
            allNames.addAll(configurationTypeDescriptor.getAllQualifiedJavaNames());
        }
        return allNames;
    }

    @Override
    public int compareTo(ConfigurationTypeDescriptor other) {
        if (other instanceof LambdaConfigurationTypeDescriptor) {
            LambdaConfigurationTypeDescriptor otherLambda = (LambdaConfigurationTypeDescriptor)other;
            int result = this.declaringClass.compareTo(otherLambda.declaringClass());
            if (result != 0) {
                return result;
            }
            if (this.declaringMethod() == null && otherLambda.declaringMethod() != null) {
                return -1;
            }
            if (this.declaringMethod() != null && otherLambda.declaringMethod() == null) {
                return 1;
            }
            if (this.declaringMethod() != null && (result = this.declaringMethod().compareTo(otherLambda.declaringMethod())) != 0) {
                return result;
            }
            return Arrays.compare((Comparable[])this.interfaces.toArray(EMPTY_TYPE_DESCRIPTOR_ARRAY), (Comparable[])otherLambda.interfaces().toArray(EMPTY_TYPE_DESCRIPTOR_ARRAY));
        }
        return this.getDescriptorType().compareTo(other.getDescriptorType());
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.appendObjectStart().quote("lambda").appendFieldSeparator().appendObjectStart();
        writer.quote("declaringClass").appendFieldSeparator();
        this.declaringClass.printJson(writer);
        writer.appendSeparator();
        if (this.declaringMethod != null) {
            writer.quote("declaringMethod").appendFieldSeparator();
            this.declaringMethod.printJson(writer);
            writer.appendSeparator();
        }
        writer.quote("interfaces").appendFieldSeparator();
        JsonPrinter.printCollection((JsonWriter)writer, this.interfaces, Comparable::compareTo, JsonPrintable::printJson);
        writer.appendObjectEnd().appendObjectEnd();
    }
}

