/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.ConfigurationFile;
import com.oracle.svm.configure.config.ForeignConfiguration;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.config.conditional.ConditionalConfigurationPredicate;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import jdk.graal.compiler.util.json.JsonPrettyWriter;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonWriter;

public class ConfigurationSet {
    private final TypeConfiguration reflectionConfiguration;
    private final ResourceConfiguration resourceConfiguration;
    private final ProxyConfiguration proxyConfiguration;
    private final SerializationConfiguration serializationConfiguration;
    private final PredefinedClassesConfiguration predefinedClassesConfiguration;
    private final ForeignConfiguration foreignConfiguration;

    public ConfigurationSet(TypeConfiguration reflectionConfiguration, ResourceConfiguration resourceConfiguration, ProxyConfiguration proxyConfiguration, SerializationConfiguration serializationConfiguration, PredefinedClassesConfiguration predefinedClassesConfiguration, ForeignConfiguration foreignConfiguration) {
        this.reflectionConfiguration = reflectionConfiguration;
        this.resourceConfiguration = resourceConfiguration;
        this.proxyConfiguration = proxyConfiguration;
        this.serializationConfiguration = serializationConfiguration;
        this.predefinedClassesConfiguration = predefinedClassesConfiguration;
        this.foreignConfiguration = foreignConfiguration;
    }

    public ConfigurationSet(ConfigurationSet other) {
        this(other.reflectionConfiguration.copy(), other.resourceConfiguration.copy(), other.proxyConfiguration.copy(), other.serializationConfiguration.copy(), other.predefinedClassesConfiguration.copy(), other.foreignConfiguration.copy());
    }

    public ConfigurationSet() {
        this(new TypeConfiguration(), new ResourceConfiguration(), new ProxyConfiguration(), new SerializationConfiguration(), new PredefinedClassesConfiguration(Collections.emptyList(), hash -> false), new ForeignConfiguration());
    }

    private ConfigurationSet mutate(ConfigurationSet other, Mutator mutator) {
        TypeConfiguration reflectionConfig = mutator.apply(this.reflectionConfiguration, other.reflectionConfiguration);
        ResourceConfiguration resourceConfig = mutator.apply(this.resourceConfiguration, other.resourceConfiguration);
        ProxyConfiguration proxyConfig = mutator.apply(this.proxyConfiguration, other.proxyConfiguration);
        SerializationConfiguration serializationConfig = mutator.apply(this.serializationConfiguration, other.serializationConfiguration);
        PredefinedClassesConfiguration predefinedClassesConfig = mutator.apply(this.predefinedClassesConfiguration, other.predefinedClassesConfiguration);
        ForeignConfiguration foreignConfig = mutator.apply(this.foreignConfiguration, other.foreignConfiguration);
        return new ConfigurationSet(reflectionConfig, resourceConfig, proxyConfig, serializationConfig, predefinedClassesConfig, foreignConfig);
    }

    public ConfigurationSet copyAndMerge(ConfigurationSet other) {
        return this.mutate(other, ConfigurationBase::copyAndMerge);
    }

    public ConfigurationSet copyAndSubtract(ConfigurationSet other) {
        return this.mutate(other, ConfigurationBase::copyAndSubtract);
    }

    public ConfigurationSet copyAndIntersectWith(ConfigurationSet other) {
        return this.mutate(other, ConfigurationBase::copyAndIntersect);
    }

    public ConfigurationSet filter(ConditionalConfigurationPredicate filter) {
        TypeConfiguration reflectionConfig = (TypeConfiguration)this.reflectionConfiguration.copyAndFilter(filter);
        ResourceConfiguration resourceConfig = (ResourceConfiguration)this.resourceConfiguration.copyAndFilter(filter);
        ProxyConfiguration proxyConfig = (ProxyConfiguration)this.proxyConfiguration.copyAndFilter(filter);
        SerializationConfiguration serializationConfig = (SerializationConfiguration)this.serializationConfiguration.copyAndFilter(filter);
        PredefinedClassesConfiguration predefinedClassesConfig = (PredefinedClassesConfiguration)this.predefinedClassesConfiguration.copyAndFilter(filter);
        ForeignConfiguration foreignConfig = (ForeignConfiguration)this.foreignConfiguration.copyAndFilter(filter);
        return new ConfigurationSet(reflectionConfig, resourceConfig, proxyConfig, serializationConfig, predefinedClassesConfig, foreignConfig);
    }

    public TypeConfiguration getReflectionConfiguration() {
        return this.reflectionConfiguration;
    }

    public ResourceConfiguration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public SerializationConfiguration getSerializationConfiguration() {
        return this.serializationConfiguration;
    }

    public PredefinedClassesConfiguration getPredefinedClassesConfiguration() {
        return this.predefinedClassesConfiguration;
    }

    public ForeignConfiguration getForeignConfiguration() {
        return this.foreignConfiguration;
    }

    public <T extends ConfigurationBase<T, ?>> T getConfiguration(ConfigurationFile configurationFile) {
        switch (configurationFile) {
            case DYNAMIC_PROXY: {
                return (T)this.proxyConfiguration;
            }
            case RESOURCES: {
                return (T)this.resourceConfiguration;
            }
            case REFLECTION: 
            case JNI: {
                return (T)this.reflectionConfiguration;
            }
            case SERIALIZATION: {
                return (T)this.serializationConfiguration;
            }
            case PREDEFINED_CLASSES_NAME: {
                return (T)this.predefinedClassesConfiguration;
            }
            case FOREIGN: {
                return (T)this.foreignConfiguration;
            }
        }
        throw new IllegalArgumentException("Unsupported configuration in configuration container: " + String.valueOf((Object)configurationFile));
    }

    public static List<Path> writeConfiguration(Function<ConfigurationFile, Path> configFilePathResolver, Function<ConfigurationFile, JsonPrintable> configSupplier) throws IOException {
        return ConfigurationSet.writeConfigurationToAllPaths(cf -> Collections.singleton((Path)configFilePathResolver.apply((ConfigurationFile)((Object)cf))), configSupplier);
    }

    public static List<Path> writeConfigurationToAllPaths(Function<ConfigurationFile, Set<Path>> configFilePathResolver, Function<ConfigurationFile, JsonPrintable> configSupplier) throws IOException {
        ArrayList<Path> writtenFiles = new ArrayList<Path>();
        ConfigurationFile reachabilityMetadataFile = ConfigurationFile.REACHABILITY_METADATA;
        for (Path path : configFilePathResolver.apply(reachabilityMetadataFile)) {
            writtenFiles.add(path);
            JsonPrettyWriter writer = new JsonPrettyWriter(path);
            boolean first = true;
            for (ConfigurationFile configFile : ConfigurationFile.agentGeneratedFiles()) {
                ConfigurationBase configurationBase;
                ConfigurationBase configurationBase2;
                JsonPrintable configuration = configSupplier.apply(configFile);
                if (configuration instanceof ConfigurationBase && !(configurationBase2 = (ConfigurationBase)configuration).supportsCombinedFile()) {
                    if (configurationBase2.isEmpty()) continue;
                    for (Path specificPath : configFilePathResolver.apply(configFile)) {
                        writtenFiles.add(specificPath);
                        JsonWriter specificWriter = new JsonWriter(specificPath, new OpenOption[0]);
                        configurationBase2.printLegacyJson(specificWriter);
                        specificWriter.newline();
                        specificWriter.close();
                    }
                    continue;
                }
                if (configuration instanceof ConfigurationBase && (configurationBase = (ConfigurationBase)configuration).isEmpty()) continue;
                if (first) {
                    writer.appendObjectStart();
                    first = false;
                } else {
                    writer.appendSeparator();
                }
                ConfigurationSet.printConfigurationToCombinedFile(configSupplier.apply(configFile), configFile, (JsonWriter)writer);
            }
            if (first) {
                writer.append("{}");
            } else {
                writer.appendObjectEnd();
            }
            writer.close();
        }
        return writtenFiles;
    }

    public static void printConfigurationToCombinedFile(JsonPrintable config, ConfigurationFile configFile, JsonWriter writer) throws IOException {
        writer.quote(configFile.getFieldName()).appendFieldSeparator();
        config.printJson(writer);
    }

    public List<Path> writeConfiguration(Function<ConfigurationFile, Path> configFilePathResolver) throws IOException {
        return ConfigurationSet.writeConfiguration(configFilePathResolver, this::getConfiguration);
    }

    public boolean isEmpty() {
        return this.reflectionConfiguration.isEmpty() && this.resourceConfiguration.isEmpty() && this.proxyConfiguration.isEmpty() && this.serializationConfiguration.isEmpty() && this.predefinedClassesConfiguration.isEmpty();
    }

    @FunctionalInterface
    private static interface Mutator {
        public <T extends ConfigurationBase<T, ?>> T apply(T var1, T var2);
    }
}

