/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationMemberInfo;

public final class FieldInfo {
    private static final FieldInfo[][] FINAL_NOT_WRITABLE_CACHE;
    private final ConfigurationMemberInfo kind;
    private final boolean finalButWritable;

    static FieldInfo get(ConfigurationMemberInfo kind, boolean finalButWritable) {
        return FieldInfo.get(kind.getDeclaration(), kind.getAccessibility(), finalButWritable);
    }

    static FieldInfo get(ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility, boolean finalButWritable) {
        if (finalButWritable) {
            return new FieldInfo(declaration, accessibility, finalButWritable);
        }
        return FINAL_NOT_WRITABLE_CACHE[declaration.ordinal()][accessibility.ordinal()];
    }

    private FieldInfo(ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility, boolean finalButWritable) {
        this.kind = ConfigurationMemberInfo.get(declaration, accessibility);
        this.finalButWritable = finalButWritable;
    }

    public FieldInfo newMergedWith(FieldInfo other) {
        assert (this.kind.equals(other.kind));
        if (this.finalButWritable == other.finalButWritable) {
            return this;
        }
        return FieldInfo.get(this.kind, this.finalButWritable || other.finalButWritable);
    }

    public FieldInfo newWithDifferencesFrom(FieldInfo other) {
        boolean newFinalButWritable;
        assert (this.kind.equals(other.kind));
        boolean bl = newFinalButWritable = this.finalButWritable && !other.finalButWritable;
        if (!newFinalButWritable) {
            return null;
        }
        return FieldInfo.get(this.kind, newFinalButWritable);
    }

    public FieldInfo newIntersectedWith(FieldInfo other) {
        assert (this.kind.equals(other.kind));
        boolean newFinalButWritable = this.finalButWritable && other.finalButWritable;
        return FieldInfo.get(this.kind, newFinalButWritable);
    }

    public ConfigurationMemberInfo getKind() {
        return this.kind;
    }

    public boolean isFinalButWritable() {
        return this.finalButWritable;
    }

    public boolean equals(Object obj) {
        if (obj != this && obj instanceof FieldInfo) {
            FieldInfo other = (FieldInfo)obj;
            return this.kind.equals(other.kind) && this.finalButWritable == other.finalButWritable;
        }
        return obj == this;
    }

    public int hashCode() {
        return Boolean.hashCode(this.finalButWritable) * 31 + this.kind.hashCode();
    }

    static {
        ConfigurationMemberInfo.ConfigurationMemberDeclaration[] declarations = ConfigurationMemberInfo.ConfigurationMemberDeclaration.values();
        ConfigurationMemberInfo.ConfigurationMemberAccessibility[] accessibilities = ConfigurationMemberInfo.ConfigurationMemberAccessibility.values();
        FINAL_NOT_WRITABLE_CACHE = new FieldInfo[declarations.length][accessibilities.length];
        for (ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration : declarations) {
            for (ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility : accessibilities) {
                FieldInfo.FINAL_NOT_WRITABLE_CACHE[declaration.ordinal()][accessibility.ordinal()] = new FieldInfo(declaration, accessibility, false);
            }
        }
    }
}

