/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationMethod;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.util.TypeResult;
import java.util.List;

public class ParserConfigurationAdapter
implements ReflectionConfigurationParserDelegate<UnresolvedConfigurationCondition, ConfigurationType> {
    private final TypeConfiguration configuration;

    public ParserConfigurationAdapter(TypeConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public TypeResult<ConfigurationType> resolveType(UnresolvedConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives, boolean jniAccessible) {
        ConfigurationType type = this.configuration.get(condition, typeDescriptor);
        ConfigurationType result = type != null ? type : new ConfigurationType(condition, typeDescriptor, false);
        return TypeResult.forType((String)typeDescriptor.toString(), (Object)result);
    }

    @Override
    public TypeResult<List<ConfigurationType>> resolveTypes(UnresolvedConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives, boolean jniAccessible) {
        TypeResult<ConfigurationType> result = this.resolveType(condition, typeDescriptor, allowPrimitives, jniAccessible);
        return TypeResult.toList(result);
    }

    @Override
    public void registerType(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.equals(type.getCondition()), "condition is already a part of the type");
        this.configuration.add(type);
    }

    @Override
    public void registerField(UnresolvedConfigurationCondition condition, ConfigurationType type, String fieldName, boolean finalButWritable, boolean jniAccessible) {
        ParserConfigurationAdapter.checkArguments(condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.addField(fieldName, ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, finalButWritable);
    }

    @Override
    public boolean registerAllMethodsWithName(UnresolvedConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, ConfigurationType type, String methodName) {
        ParserConfigurationAdapter.checkArguments(condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.addMethodsWithName(methodName, ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
        return true;
    }

    @Override
    public boolean registerAllConstructors(UnresolvedConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.addMethodsWithName("<init>", ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
        return true;
    }

    @Override
    public void registerUnsafeAllocated(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.equals(type.getCondition()), "condition is already a part of the type");
        type.setUnsafeAllocated();
    }

    @Override
    public void registerMethod(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type, String methodName, List<ConfigurationType> methodParameterTypes, boolean jniAccessible) {
        ParserConfigurationAdapter.checkArguments(condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.addMethod(methodName, ConfigurationMethod.toInternalParamsSignature(methodParameterTypes), ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    @Override
    public void registerConstructor(UnresolvedConfigurationCondition condition, boolean queriedOnly, ConfigurationType type, List<ConfigurationType> methodParameterTypes, boolean jniAccessible) {
        ParserConfigurationAdapter.checkArguments(condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.addMethod("<init>", ConfigurationMethod.toInternalParamsSignature(methodParameterTypes), ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    @Override
    public void registerPublicClasses(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        type.setAllPublicClasses();
    }

    @Override
    public void registerDeclaredClasses(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        type.setAllDeclaredClasses();
    }

    @Override
    public void registerRecordComponents(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        type.setAllRecordComponents();
    }

    @Override
    public void registerPermittedSubclasses(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        type.setAllPermittedSubclasses();
    }

    @Override
    public void registerNestMembers(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        type.setAllNestMembers();
    }

    @Override
    public void registerSigners(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        type.setAllSigners();
    }

    @Override
    public void registerPublicFields(UnresolvedConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.setAllPublicFields(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    @Override
    public void registerDeclaredFields(UnresolvedConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.setAllDeclaredFields(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    @Override
    public void registerPublicMethods(UnresolvedConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.setAllPublicMethods(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    @Override
    public void registerDeclaredMethods(UnresolvedConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.setAllDeclaredMethods(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    @Override
    public void registerPublicConstructors(UnresolvedConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.setAllPublicConstructors(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    @Override
    public void registerDeclaredConstructors(UnresolvedConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        if (jniAccessible) {
            type.setJniAccessible();
        }
        type.setAllDeclaredConstructors(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    @Override
    public void registerAsSerializable(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        type.setSerializable();
    }

    @Override
    public void registerAsJniAccessed(UnresolvedConfigurationCondition condition, ConfigurationType type) {
        ParserConfigurationAdapter.checkArguments(condition.isAlwaysTrue() || condition.equals(type.getCondition()), "condition is already a part of the type");
        type.setJniAccessible();
    }

    @Override
    public String getTypeName(ConfigurationType type) {
        return type.getTypeDescriptor().toString();
    }

    @Override
    public String getSimpleName(ConfigurationType type) {
        return this.getTypeName(type);
    }

    private static void checkArguments(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }
}

