/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config.conditional;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.ConfigurationFile;
import com.oracle.svm.configure.config.conditional.MethodCallNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonWriter;

public class HumanReadableConfigurationWithOrigins
implements JsonPrintable {
    static final String CONNECTING_INDENT = "\u2502   ";
    static final String EMPTY_INDENT = "    ";
    static final String CHILD = "\u251c\u2500\u2500 ";
    static final String LAST_CHILD = "\u2514\u2500\u2500 ";
    private final MethodCallNode root;
    private final ConfigurationFile configFile;
    private final Set<MethodCallNode> nodesWithNonEmptyConfig;

    public HumanReadableConfigurationWithOrigins(MethodCallNode root, ConfigurationFile configFile) {
        this.root = root;
        this.configFile = configFile;
        this.nodesWithNonEmptyConfig = root.getNodesWithNonEmptyConfig(configFile);
    }

    private MethodCallNode findLastChildWithNonEmptyConfig(List<MethodCallNode> nodes) {
        MethodCallNode child = null;
        for (MethodCallNode node : nodes) {
            if (!this.nodesWithNonEmptyConfig.contains(node)) continue;
            child = node;
        }
        return child;
    }

    private void printNode(JsonWriter writer, String prefix, MethodCallNode node) throws IOException {
        writer.append(prefix).append(node.methodInfo.toString());
        if (node.hasConfig(this.configFile)) {
            writer.append(" - ");
            Object config = node.configuration.getConfiguration(this.configFile);
            StringWriter sw = new StringWriter();
            JsonWriter jw = new JsonWriter((Writer)sw);
            if (((ConfigurationBase)config).supportsCombinedFile()) {
                config.printJson(jw);
            } else {
                ((ConfigurationBase)config).printLegacyJson(jw);
            }
            writer.append(sw.toString().replace("\n", " "));
        }
        writer.newline();
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append("root").newline();
        List<MethodCallNode> nodes = List.copyOf(this.root.calledMethods.values());
        MethodCallNode lastChild = this.findLastChildWithNonEmptyConfig(nodes);
        for (MethodCallNode node : nodes) {
            if (!this.nodesWithNonEmptyConfig.contains(node)) continue;
            this.printNode(writer, node == lastChild ? LAST_CHILD : CHILD, node);
            this.printChildNodes(writer, node == lastChild ? EMPTY_INDENT : CONNECTING_INDENT, node);
        }
    }

    private void printChildNodes(JsonWriter writer, String prefix, MethodCallNode node) throws IOException {
        List<MethodCallNode> nodes = List.copyOf(node.calledMethods.values());
        MethodCallNode lastChild = this.findLastChildWithNonEmptyConfig(nodes);
        for (MethodCallNode child : node.calledMethods.values()) {
            if (!this.nodesWithNonEmptyConfig.contains(child)) continue;
            this.printNode(writer, prefix + (child == lastChild ? LAST_CHILD : CHILD), child);
            this.printChildNodes(writer, prefix + (child == lastChild ? EMPTY_INDENT : CONNECTING_INDENT), child);
        }
    }
}

