/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.ForeignConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.util.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.collections.EconomicMap;

class ForeignProcessor
extends AbstractProcessor {
    ForeignProcessor() {
    }

    @Override
    public void processEntry(EconomicMap<String, Object> entry, ConfigurationSet configurationSet) {
        boolean invalidResult = Boolean.FALSE.equals(entry.get((Object)"result"));
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get((Object)"function");
        List args = (List)entry.get((Object)"args");
        ForeignConfiguration foreignConfiguration = configurationSet.getForeignConfiguration();
        switch (function) {
            case "downcallHandle0": {
                ForeignProcessor.expectSize(args, 3);
                String returnType = (String)args.get(0);
                List parameterTypes = (List)args.get(1);
                List linkerOptions = (List)args.get(2);
                foreignConfiguration.addDowncall(returnType, parameterTypes, ForeignProcessor.processLinkerOptions(linkerOptions));
                break;
            }
            case "upcallStub": {
                ClassAndMethodName classAndMethodName;
                ForeignProcessor.expectSize(args, 4);
                String returnType = (String)args.get(0);
                List parameterTypes = (List)args.get(1);
                List linkerOptions = (List)args.get(2);
                Object targetDesc = args.get(3);
                if (targetDesc instanceof String) {
                    String targetDescString = (String)targetDesc;
                    v0 = ForeignProcessor.getClassAndMethodName(targetDescString);
                } else {
                    v0 = classAndMethodName = null;
                }
                if (classAndMethodName != null) {
                    foreignConfiguration.addDirectUpcall(returnType, parameterTypes, ForeignProcessor.processLinkerOptions(linkerOptions), classAndMethodName.className, classAndMethodName.methodName);
                    break;
                }
                foreignConfiguration.addUpcall(returnType, parameterTypes, ForeignProcessor.processLinkerOptions(linkerOptions));
            }
        }
    }

    private static Map<String, Object> processLinkerOptions(List<String> linkerOptions) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String linkerOption : linkerOptions) {
            Map.Entry<String, Object> processed = ForeignProcessor.processLinkerOption(linkerOption);
            if (processed == null) continue;
            result.put(processed.getKey(), processed.getValue());
        }
        return result;
    }

    private static Map.Entry<String, Object> processLinkerOption(String linkerOption) {
        if (linkerOption == null || linkerOption.isEmpty()) {
            return null;
        }
        switch (linkerOption) {
            case "ALLOW_HEAP": {
                return ForeignProcessor.critical(true);
            }
            case "DONT_ALLOW_HEAP": {
                return ForeignProcessor.critical(false);
            }
        }
        int argStart = linkerOption.indexOf(91);
        int argEnd = linkerOption.lastIndexOf(93);
        if (argStart == -1 || argEnd == -1 || argEnd != linkerOption.length() - 1) {
            LogUtils.warning((String)("Ignoring invalid Linker.Option: " + linkerOption));
            return null;
        }
        return switch (linkerOption.substring(0, argStart)) {
            case "CaptureCallState" -> {
                Map.Entry<String, Boolean> var5_6;
                yield var5_6 = Map.entry("captureCallState", true);
            }
            case "FirstVariadicArg" -> {
                try {
                    int eqIndex = linkerOption.indexOf(61, argStart);
                    int index = Integer.parseInt(linkerOption.substring(eqIndex + 1, argEnd));
                    Map.Entry<String, Integer> var5_7 = Map.entry("firstVariadicArg", index);
                    yield var5_7;
                }
                catch (NumberFormatException e) {
                    LogUtils.warning((String)("Invalid parameter in Linker.Option: " + linkerOption));
                    Object var5_8 = null;
                    yield var5_8;
                }
            }
            case "Critical" -> {
                try {
                    int eqIndex = linkerOption.indexOf(61, argStart);
                    boolean allowHeapAccess = Boolean.parseBoolean(linkerOption.substring(eqIndex + 1, argEnd));
                    Map.Entry<String, Object> var5_9 = ForeignProcessor.critical(allowHeapAccess);
                    yield var5_9;
                }
                catch (NumberFormatException e) {
                    LogUtils.warning((String)("Invalid parameter in Linker.Option: " + linkerOption));
                    Object var5_10 = null;
                    yield var5_10;
                }
            }
            default -> {
                Map.Entry<String, Boolean> var5_11;
                yield var5_11 = null;
            }
        };
    }

    private static Map.Entry<String, Object> critical(boolean allowHeapAccess) {
        return Map.entry("critical", Map.of("allowHeapAccess", allowHeapAccess));
    }

    private static ClassAndMethodName getClassAndMethodName(String targetDesc) {
        int sep;
        if (targetDesc == null || (sep = targetDesc.indexOf("::")) == -1) {
            return null;
        }
        String className = MetaUtil.internalNameToJava((String)targetDesc.substring(0, sep), (boolean)true, (boolean)false);
        String methodName = targetDesc.substring(sep + 2);
        return new ClassAndMethodName(className, methodName);
    }

    private record ClassAndMethodName(String className, String methodName) {
    }
}

