/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.DeoptimizationSourcePositionDecoder;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.util.ByteArrayReader;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.util.FrequencyEncoder;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.compiler.graph.NodeSourcePosition;

public class DeoptimizationSourcePositionEncoder {
    private final FrequencyEncoder<Object> objectConstants = FrequencyEncoder.createIdentityEncoder();

    public void encodeAndInstall(List<NodeSourcePosition> deoptimzationSourcePositions, CodeInfo target) {
        this.addObjectConstants(deoptimzationSourcePositions);
        Object[] encodedObjectConstants = this.objectConstants.encodeAll(new Object[this.objectConstants.getLength()]);
        UnsafeArrayTypeWriter encodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        EconomicMap sourcePositionStartOffsets = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        NonmovableArray<Integer> deoptimizationStartOffsets = NonmovableArrays.createIntArray(deoptimzationSourcePositions.size());
        this.encodeSourcePositions(deoptimzationSourcePositions, (EconomicMap<NodeSourcePosition, Long>)sourcePositionStartOffsets, deoptimizationStartOffsets, encodingBuffer);
        NonmovableArray<Byte> deoptimizationEncodings = NonmovableArrays.createByteArray(TypeConversion.asS4((long)encodingBuffer.getBytesWritten()));
        encodingBuffer.toByteBuffer(NonmovableArrays.asByteBuffer(deoptimizationEncodings));
        DeoptimizationSourcePositionEncoder.install(target, deoptimizationStartOffsets, deoptimizationEncodings, encodedObjectConstants, deoptimzationSourcePositions);
    }

    @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed in target.")
    private static void install(CodeInfo target, NonmovableArray<Integer> deoptimizationStartOffsets, NonmovableArray<Byte> deoptimizationEncodings, Object[] encodedObjectConstants, List<NodeSourcePosition> deoptimizationSourcePositions) {
        NonmovableObjectArray<Object> deoptimizationObjectConstants = NonmovableArrays.copyOfObjectArray(encodedObjectConstants);
        RuntimeCodeInfoAccess.setDeoptimizationMetadata(target, deoptimizationStartOffsets, deoptimizationEncodings, deoptimizationObjectConstants);
        DeoptimizationSourcePositionEncoder.afterInstallation(deoptimizationStartOffsets, deoptimizationEncodings, deoptimizationSourcePositions, deoptimizationObjectConstants);
    }

    @Uninterruptible(reason="Safe for GC, but called from uninterruptible code.", calleeMustBe=false)
    private static void afterInstallation(NonmovableArray<Integer> deoptimizationStartOffsets, NonmovableArray<Byte> deoptimizationEncodings, List<NodeSourcePosition> deoptimizationSourcePositions, NonmovableObjectArray<Object> deoptimizationObjectConstants) {
        DeoptimizationSourcePositionEncoder.verifyEncoding(deoptimizationSourcePositions, deoptimizationStartOffsets, deoptimizationEncodings, deoptimizationObjectConstants);
    }

    private void addObjectConstants(List<NodeSourcePosition> deoptimzationSourcePositions) {
        EconomicSet processedPositions = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        for (NodeSourcePosition sourcePosition : deoptimzationSourcePositions) {
            this.addObjectConstants(sourcePosition, (EconomicSet<NodeSourcePosition>)processedPositions);
        }
    }

    private void addObjectConstants(NodeSourcePosition sourcePosition, EconomicSet<NodeSourcePosition> processedPositions) {
        if (sourcePosition == null || processedPositions.contains((Object)sourcePosition)) {
            return;
        }
        this.addObjectConstants(sourcePosition.getCaller(), processedPositions);
        this.objectConstants.addObject((Object)sourcePosition.getMethod());
        processedPositions.add((Object)sourcePosition);
    }

    private void encodeSourcePositions(List<NodeSourcePosition> deoptimzationSourcePositions, EconomicMap<NodeSourcePosition, Long> sourcePositionStartOffsets, NonmovableArray<Integer> deoptimizationStartOffsets, UnsafeArrayTypeWriter encodingBuffer) {
        for (int i = 0; i < deoptimzationSourcePositions.size(); ++i) {
            int startOffset;
            NodeSourcePosition sourcePosition = deoptimzationSourcePositions.get(i);
            if (sourcePosition == null) {
                startOffset = -1;
            } else {
                startOffset = TypeConversion.asS4((long)this.encodeSourcePositions(sourcePosition, sourcePositionStartOffsets, encodingBuffer));
                assert (startOffset > -1);
            }
            NonmovableArrays.setInt(deoptimizationStartOffsets, i, startOffset);
        }
    }

    private long encodeSourcePositions(NodeSourcePosition sourcePosition, EconomicMap<NodeSourcePosition, Long> sourcePositionStartOffsets, UnsafeArrayTypeWriter encodingBuffer) {
        Long existingAbsoluteOffset = (Long)sourcePositionStartOffsets.get((Object)sourcePosition);
        if (existingAbsoluteOffset != null) {
            return existingAbsoluteOffset;
        }
        long callerAbsoluteOffset = -1L;
        if (sourcePosition.getCaller() != null) {
            callerAbsoluteOffset = this.encodeSourcePositions(sourcePosition.getCaller(), sourcePositionStartOffsets, encodingBuffer);
        }
        long startAbsoluteOffset = encodingBuffer.getBytesWritten();
        long callerRelativeOffset = 0L;
        if (sourcePosition.getCaller() != null) {
            callerRelativeOffset = startAbsoluteOffset - callerAbsoluteOffset;
            assert (callerRelativeOffset > 0L);
        }
        encodingBuffer.putUV(callerRelativeOffset);
        encodingBuffer.putSV((long)sourcePosition.getBCI());
        encodingBuffer.putUV((long)this.objectConstants.getIndex((Object)sourcePosition.getMethod()));
        sourcePositionStartOffsets.put((Object)sourcePosition, (Object)startAbsoluteOffset);
        return startAbsoluteOffset;
    }

    private static boolean verifyEncoding(List<NodeSourcePosition> deoptimzationSourcePositions, NonmovableArray<Integer> deoptimizationStartOffsets, NonmovableArray<Byte> deoptimizationEncodings, NonmovableObjectArray<Object> deoptimizationObjectConstants) {
        for (int i = 0; i < deoptimzationSourcePositions.size(); ++i) {
            NodeSourcePosition originalSourcePosition = deoptimzationSourcePositions.get(i);
            NodeSourcePosition decodedSourcePosition = DeoptimizationSourcePositionDecoder.decode(i, deoptimizationStartOffsets, deoptimizationEncodings, deoptimizationObjectConstants);
            DeoptimizationSourcePositionEncoder.verifySourcePosition(originalSourcePosition, decodedSourcePosition);
        }
        return true;
    }

    private static void verifySourcePosition(NodeSourcePosition originalPosition, NodeSourcePosition decodedSourcePosition) {
        if (originalPosition == null) {
            assert (decodedSourcePosition == null);
            return;
        }
        assert (originalPosition.getBCI() == decodedSourcePosition.getBCI());
        assert (originalPosition.getMethod().equals(decodedSourcePosition.getMethod()));
        DeoptimizationSourcePositionEncoder.verifySourcePosition(originalPosition.getCaller(), decodedSourcePosition.getCaller());
    }
}

