/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import java.util.List;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.NodeWithState;

@NodeInfo(cycles=NodeCycles.CYCLES_8, cyclesRationale="Node will be lowered to a foreign call.", size=NodeSize.SIZE_8)
public final class ThrowBytecodeExceptionNode
extends ControlSinkNode
implements NodeWithState,
Lowerable {
    public static final NodeClass<ThrowBytecodeExceptionNode> TYPE = NodeClass.create(ThrowBytecodeExceptionNode.class);
    private final BytecodeExceptionNode.BytecodeExceptionKind exceptionKind;
    @Node.Input
    private NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.State)
    private FrameState stateBefore;

    public ThrowBytecodeExceptionNode(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, List<ValueNode> arguments) {
        super(TYPE, StampFactory.forVoid());
        this.exceptionKind = exceptionKind;
        this.arguments = new NodeInputList((Node)this, arguments);
    }

    public BytecodeExceptionNode.BytecodeExceptionKind getExceptionKind() {
        return this.exceptionKind;
    }

    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    public FrameState stateBefore() {
        return this.stateBefore;
    }

    public void setStateBefore(FrameState f) {
        this.updateUsages((Node)this.stateBefore, (Node)f);
        this.stateBefore = f;
    }

    public void lower(LoweringTool tool) {
        tool.getLowerer().lower((Node)this, tool);
    }
}

