/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.headers.ZLib;
import java.util.zip.CRC32;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
@TargetClass(value=CRC32.class)
final class Target_java_util_zip_CRC32 {
    Target_java_util_zip_CRC32() {
    }

    @Substitute
    private static int update(int crc, int b) {
        CCharPointer bytes = (CCharPointer)StackValue.get(CCharPointer.class);
        bytes.write((byte)b);
        return (int)ZLib.crc32(WordFactory.unsigned((int)crc), bytes, 1).rawValue();
    }

    @Substitute
    private static int updateBytes(int crc, byte[] b, int off, int len) {
        try (PinnedObject pinned = PinnedObject.create((Object)b);){
            CCharPointer bytes = (CCharPointer)pinned.addressOfArrayElement(off);
            int n = (int)ZLib.crc32(WordFactory.unsigned((int)crc), bytes, len).rawValue();
            return n;
        }
    }

    @Substitute
    private static int updateByteBuffer(int crc, long addr, int off, int len) {
        CCharPointer bytes = (CCharPointer)WordFactory.pointer((long)addr);
        CCharPointer bytesAtOffset = bytes.addressOf(off);
        return (int)ZLib.crc32(WordFactory.unsigned((int)crc), bytesAtOffset, len).rawValue();
    }
}

