/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordFactory;

public final class VMOperationControl {
    private static VMOperationThread dedicatedVMOperationThread = null;
    private final WorkQueues mainQueues = new WorkQueues("main", true);
    private final WorkQueues immediateQueues = new WorkQueues("immediate", false);
    private final OpInProgress inProgress = new OpInProgress();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    VMOperationControl() {
    }

    @Fold
    static VMOperationControl get() {
        return (VMOperationControl)ImageSingletons.lookup(VMOperationControl.class);
    }

    public static void startVMOperationThread() {
        assert (SubstrateOptions.UseDedicatedVMOperationThread.getValue().booleanValue());
        assert (VMOperationControl.get().mainQueues.isEmpty());
        dedicatedVMOperationThread = new VMOperationThread();
        Thread thread = new Thread((Runnable)dedicatedVMOperationThread, "VMOperationThread");
        thread.setDaemon(true);
        thread.start();
        dedicatedVMOperationThread.waitUntilStarted();
    }

    public static void shutdownAndDetachVMOperationThread() {
        assert (SubstrateOptions.UseDedicatedVMOperationThread.getValue().booleanValue());
        JavaVMOperation.enqueueBlockingNoSafepoint("Stop VMOperationThread", () -> dedicatedVMOperationThread.shutdown());
        VMOperationControl.waitUntilVMOperationThreadDetached();
        assert (VMOperationControl.get().mainQueues.isEmpty());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during teardown")
    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode.")
    private static void waitUntilVMOperationThreadDetached() {
        CFunctionPrologueNode.cFunctionPrologue();
        VMOperationControl.waitUntilVMOperationThreadDetachedInNative();
        CFunctionEpilogueNode.cFunctionEpilogue();
    }

    @Uninterruptible(reason="Must not stop while in native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static void waitUntilVMOperationThreadDetachedInNative() {
        VMThreads.THREAD_MUTEX.lockNoTransition();
        try {
            while (VMThreads.nextThread(VMThreads.firstThread()).isNonNull()) {
                VMThreads.THREAD_LIST_CONDITION.blockNoTransition();
            }
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isDedicatedVMOperationThread() {
        return VMOperationControl.isDedicatedVMOperationThread(CurrentIsolate.getCurrentThread());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isDedicatedVMOperationThread(IsolateThread thread) {
        if (SubstrateOptions.UseDedicatedVMOperationThread.getValue().booleanValue()) {
            return thread == dedicatedVMOperationThread.getIsolateThread();
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean mayExecuteVmOperations() {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return true;
        }
        if (SubstrateOptions.UseDedicatedVMOperationThread.getValue().booleanValue()) {
            return VMOperationControl.isDedicatedVMOperationThread();
        }
        return VMOperationControl.get().mainQueues.mutex.isOwner();
    }

    public static void logRecentEvents(Log log) {
        VMOperationControl control = VMOperationControl.get();
        VMOperation op = control.inProgress.operation;
        if (op == null) {
            log.string("No VMOperation in progress").newline();
        } else {
            log.string("VMOperation in progress: ").string(op.getName()).newline();
            log.string("  causesSafepoint: ").bool(op.getCausesSafepoint()).newline();
            log.string("  queuingThread: ").zhex(control.inProgress.queueingThread.rawValue()).newline();
            log.string("  executingThread: ").zhex(control.inProgress.executingThread.rawValue()).newline();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    OpInProgress getInProgress() {
        return this.inProgress;
    }

    @Uninterruptible(reason="Set the current VM operation as atomically as possible - this is mainly relevant for deopt test cases")
    void setInProgress(VMOperation operation, IsolateThread queueingThread, IsolateThread executingThread) {
        assert (operation != null && queueingThread.isNonNull() && executingThread.isNonNull() || operation == null && queueingThread.isNull() && executingThread.isNull());
        this.inProgress.executingThread = executingThread;
        this.inProgress.operation = operation;
        this.inProgress.queueingThread = queueingThread;
    }

    void enqueue(JavaVMOperation operation) {
        this.enqueue(operation, (NativeVMOperationData)WordFactory.nullPointer());
    }

    void enqueue(NativeVMOperationData data) {
        this.enqueue(data.getNativeVMOperation(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(VMOperation operation, NativeVMOperationData data) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            VMOperationControl.log().string("[VMOperationControl.enqueue:").string("  operation: ").string(operation.getName());
            if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                assert (!SubstrateOptions.UseDedicatedVMOperationThread.getValue().booleanValue());
                VMOperationControl.markAsQueued(operation, data);
                try {
                    operation.execute(data);
                }
                finally {
                    VMOperationControl.markAsFinished(operation, data, null);
                }
            } else if (VMOperationControl.mayExecuteVmOperations()) {
                this.immediateQueues.enqueueAndExecute(operation, data);
            } else if (SubstrateOptions.UseDedicatedVMOperationThread.getValue().booleanValue()) {
                assert (!VMOperationControl.isDedicatedVMOperationThread()) : "the dedicated VM operation thread must execute and not queue VM operations";
                assert (dedicatedVMOperationThread.isRunning()) : "must not queue VM operations before the VM operation thread is started or after it is shut down";
                VMThreads.THREAD_MUTEX.guaranteeNotOwner("could result in deadlocks otherwise");
                this.mainQueues.enqueueAndWait(operation, data);
            } else {
                VMThreads.THREAD_MUTEX.guaranteeNotOwner("could result in deadlocks otherwise");
                this.mainQueues.enqueueAndExecute(operation, data);
            }
            assert (operation.isFinished(data));
            VMOperationControl.log().string("]").newline();
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    private static void markAsQueued(VMOperation operation, NativeVMOperationData data) {
        operation.setQueuingThread(data, CurrentIsolate.getCurrentThread());
        operation.setFinished(data, false);
    }

    private static void markAsFinished(VMOperation operation, NativeVMOperationData data, VMCondition operationFinished) {
        operation.setFinished(data, true);
        operation.setQueuingThread(data, (IsolateThread)WordFactory.nullPointer());
        if (operationFinished != null) {
            operationFinished.broadcast();
        }
    }

    public static void guaranteeOkayToBlock(String message) {
        if (VMOperationControl.isFrozen()) {
            Log.log().string(message).newline();
            VMError.shouldNotReachHere("Should not reach here: Not okay to block.");
        }
    }

    public static boolean isFrozen() {
        boolean result = Safepoint.Master.singleton().isFrozen();
        assert (!result || SubstrateOptions.MultiThreaded.getValue().booleanValue());
        return result;
    }

    private static Log log() {
        return SubstrateOptions.TraceVMOperations.getValue() != false ? Log.log() : Log.noopLog();
    }

    static /* synthetic */ WorkQueues access$000(VMOperationControl x0) {
        return x0.mainQueues;
    }

    protected static class OpInProgress {
        VMOperation operation;
        IsolateThread queueingThread;
        IsolateThread executingThread;

        protected OpInProgress() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public VMOperation getOperation() {
            return this.operation;
        }

        public IsolateThread getQueuingThread() {
            return this.queueingThread;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public IsolateThread getExecutingThread() {
            return this.executingThread;
        }
    }

    protected static class NativeVMOperationQueue
    extends AllocationFreeQueue<NativeVMOperationData> {
        private NativeVMOperationData head;
        private NativeVMOperationData tail;

        NativeVMOperationQueue(String name) {
            super(name);
        }

        @Override
        public boolean isEmpty() {
            return this.head.isNull();
        }

        @Override
        public void push(NativeVMOperationData element) {
            assert (element.getNext().isNull()) : "must not already be queued";
            if (this.head.isNull()) {
                this.head = element;
            } else {
                this.tail.setNext(element);
            }
            this.tail = element;
        }

        @Override
        public NativeVMOperationData pop() {
            if (this.head.isNull()) {
                return (NativeVMOperationData)WordFactory.nullPointer();
            }
            NativeVMOperationData resultElement = this.head;
            this.head = resultElement.getNext();
            resultElement.setNext((NativeVMOperationData)WordFactory.nullPointer());
            return resultElement;
        }

        @Override
        public NativeVMOperationData peek() {
            return this.head;
        }

        @Override
        void remove(NativeVMOperationData prev, NativeVMOperationData remove) {
            if (prev.isNull()) {
                assert (this.head == remove);
                this.head = remove.getNext();
                remove.setNext((NativeVMOperationData)WordFactory.nullPointer());
            } else {
                prev.setNext(remove.getNext());
            }
        }
    }

    protected static class JavaVMOperationQueue
    extends JavaAllocationFreeQueue<JavaVMOperation> {
        JavaVMOperationQueue(String name) {
            super(name);
        }
    }

    protected static abstract class JavaAllocationFreeQueue<T extends Element<T>>
    extends AllocationFreeQueue<T> {
        private T head;
        private T tail;

        JavaAllocationFreeQueue(String name) {
            super(name);
        }

        @Override
        public boolean isEmpty() {
            return this.head == null;
        }

        @Override
        public void push(T element) {
            assert (element.getNext() == null) : "must not already be queued";
            if (this.head == null) {
                this.head = element;
            } else {
                this.tail.setNext(element);
            }
            this.tail = element;
        }

        @Override
        public T pop() {
            if (this.head == null) {
                return null;
            }
            T resultElement = this.head;
            this.head = resultElement.getNext();
            resultElement.setNext(null);
            return resultElement;
        }

        @Override
        public T peek() {
            return this.head;
        }

        @Override
        void remove(T prev, T remove) {
            if (prev == null) {
                assert (this.head == remove);
                this.head = remove.getNext();
                remove.setNext(null);
            } else {
                prev.setNext(remove.getNext());
            }
        }

        public static interface Element<T extends Element<T>> {
            public T getNext();

            public void setNext(T var1);
        }
    }

    protected static abstract class AllocationFreeQueue<T> {
        final String name;

        AllocationFreeQueue(String name) {
            this.name = name;
        }

        abstract boolean isEmpty();

        abstract void push(T var1);

        abstract T pop();

        abstract T peek();

        abstract void remove(T var1, T var2);
    }

    private static final class WorkQueues {
        private final NativeVMOperationQueue nativeNonSafepointOperations;
        private final NativeVMOperationQueue nativeSafepointOperations;
        private final JavaVMOperationQueue javaNonSafepointOperations;
        private final JavaVMOperationQueue javaSafepointOperations;
        final VMMutex mutex;
        private final VMCondition operationQueued;
        private final VMCondition operationFinished;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        WorkQueues(String prefix, boolean needsLocking) {
            this.nativeNonSafepointOperations = new NativeVMOperationQueue(prefix + "NativeNonSafepointOperations");
            this.nativeSafepointOperations = new NativeVMOperationQueue(prefix + "NativeSafepointOperations");
            this.javaNonSafepointOperations = new JavaVMOperationQueue(prefix + "JavaNonSafepointOperations");
            this.javaSafepointOperations = new JavaVMOperationQueue(prefix + "JavaSafepointOperations");
            this.mutex = WorkQueues.createMutex(needsLocking);
            this.operationQueued = this.createCondition();
            this.operationFinished = this.createCondition();
        }

        boolean isEmpty() {
            return this.nativeNonSafepointOperations.isEmpty() && this.nativeSafepointOperations.isEmpty() && this.javaNonSafepointOperations.isEmpty() && this.javaSafepointOperations.isEmpty();
        }

        void waitForWorkAndExecute() {
            assert (VMOperationControl.isDedicatedVMOperationThread());
            assert (!ThreadingSupportImpl.isRecurringCallbackRegistered(CurrentIsolate.getCurrentThread()));
            assert (this.mutex != null);
            this.mutex.guaranteeIsOwner("Must already be locked.");
            while (this.isEmpty()) {
                this.operationQueued.block();
            }
            this.executeAllQueuedVMOperations();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueueAndWait(VMOperation operation, NativeVMOperationData data) {
            assert (SubstrateOptions.UseDedicatedVMOperationThread.getValue().booleanValue());
            ThreadingSupportImpl.pauseRecurringCallback("Recurring callbacks must not interrupt this code (via an exception) as we guarantee that queued VM operations are executed.");
            try {
                this.lock();
                try {
                    this.enqueue(operation, data);
                    this.operationQueued.broadcast();
                    while (!operation.isFinished(data)) {
                        this.operationFinished.block();
                    }
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                ThreadingSupportImpl.resumeRecurringCallback();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueueAndExecute(VMOperation operation, NativeVMOperationData data) {
            ThreadingSupportImpl.pauseRecurringCallback("Recurring callbacks must not be triggered while executing a VM operation.");
            try {
                this.lock();
                try {
                    this.enqueue(operation, data);
                    this.executeAllQueuedVMOperations();
                }
                finally {
                    assert (this.isEmpty()) : "all queued VM operations must have been processed";
                    this.unlock();
                }
            }
            finally {
                ThreadingSupportImpl.resumeRecurringCallback();
            }
        }

        private void enqueue(VMOperation operation, NativeVMOperationData data) {
            this.assertIsLocked();
            VMOperationControl.markAsQueued(operation, data);
            if (operation instanceof JavaVMOperation) {
                if (operation.getCausesSafepoint()) {
                    this.javaSafepointOperations.push((JavaVMOperation)operation);
                } else {
                    this.javaNonSafepointOperations.push((JavaVMOperation)operation);
                }
            } else if (operation instanceof NativeVMOperation) {
                assert (operation == data.getNativeVMOperation());
                if (operation.getCausesSafepoint()) {
                    this.nativeSafepointOperations.push(data);
                } else {
                    this.nativeNonSafepointOperations.push(data);
                }
            } else {
                VMError.shouldNotReachHere();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAllQueuedVMOperations() {
            this.assertIsLocked();
            this.drain(this.nativeNonSafepointOperations);
            this.drain(this.javaNonSafepointOperations);
            this.filterUnnecessary(this.nativeSafepointOperations);
            this.filterUnnecessary(this.javaSafepointOperations);
            if (!this.nativeSafepointOperations.isEmpty() || !this.javaSafepointOperations.isEmpty()) {
                String safepointReason = null;
                boolean startedSafepoint = false;
                boolean lockedForSafepoint = false;
                Safepoint.Master master = Safepoint.Master.singleton();
                if (!master.isFrozen()) {
                    startedSafepoint = true;
                    safepointReason = WorkQueues.getSafepointReason(this.nativeSafepointOperations, this.javaSafepointOperations);
                    lockedForSafepoint = master.freeze(safepointReason);
                }
                try {
                    this.drain(this.nativeSafepointOperations);
                    this.drain(this.javaSafepointOperations);
                }
                finally {
                    if (startedSafepoint) {
                        master.thaw(safepointReason, lockedForSafepoint);
                    }
                }
            }
        }

        private static String getSafepointReason(NativeVMOperationQueue nativeSafepointOperations, JavaVMOperationQueue javaSafepointOperations) {
            NativeVMOperationData data = nativeSafepointOperations.peek();
            if (data.isNonNull()) {
                return data.getNativeVMOperation().getName();
            }
            VMOperation op = (VMOperation)javaSafepointOperations.peek();
            assert (op != null);
            return op.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drain(NativeVMOperationQueue workQueue) {
            this.assertIsLocked();
            if (!workQueue.isEmpty()) {
                Log trace = VMOperationControl.log();
                trace.string("[Worklist.drain:  queue: ").string(workQueue.name);
                while (!workQueue.isEmpty()) {
                    NativeVMOperationData data = workQueue.pop();
                    NativeVMOperation operation = data.getNativeVMOperation();
                    try {
                        operation.execute(data);
                    }
                    finally {
                        VMOperationControl.markAsFinished(operation, data, this.operationFinished);
                    }
                }
                trace.string("]").newline();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drain(JavaVMOperationQueue workQueue) {
            this.assertIsLocked();
            if (!workQueue.isEmpty()) {
                Log trace = VMOperationControl.log();
                trace.string("[Worklist.drain:  queue: ").string(workQueue.name);
                while (!workQueue.isEmpty()) {
                    JavaVMOperation operation = (JavaVMOperation)workQueue.pop();
                    try {
                        operation.execute((NativeVMOperationData)WordFactory.nullPointer());
                    }
                    finally {
                        VMOperationControl.markAsFinished(operation, (NativeVMOperationData)WordFactory.nullPointer(), this.operationFinished);
                    }
                }
                trace.string("]").newline();
            }
        }

        private void filterUnnecessary(JavaVMOperationQueue workQueue) {
            Log trace = VMOperationControl.log();
            JavaVMOperation prev = null;
            JavaVMOperation op = (JavaVMOperation)workQueue.peek();
            while (op != null) {
                JavaVMOperation next = op.getNext();
                if (!op.hasWork((NativeVMOperationData)WordFactory.nullPointer())) {
                    trace.string("[Skipping unnecessary operation in queue ").string(workQueue.name).string(": ").string(op.getName());
                    workQueue.remove(prev, op);
                    VMOperationControl.markAsFinished(op, (NativeVMOperationData)WordFactory.nullPointer(), this.operationFinished);
                } else {
                    prev = op;
                }
                op = next;
            }
        }

        private void filterUnnecessary(NativeVMOperationQueue workQueue) {
            Log trace = VMOperationControl.log();
            NativeVMOperationData prev = (NativeVMOperationData)WordFactory.nullPointer();
            NativeVMOperationData data = workQueue.peek();
            while (data.isNonNull()) {
                NativeVMOperation op = data.getNativeVMOperation();
                NativeVMOperationData next = data.getNext();
                if (!op.hasWork(data)) {
                    trace.string("[Skipping unnecessary operation in queue ").string(workQueue.name).string(": ").string(op.getName());
                    workQueue.remove(prev, data);
                    VMOperationControl.markAsFinished(op, data, this.operationFinished);
                } else {
                    prev = data;
                }
                data = next;
            }
        }

        private void lock() {
            if (this.mutex != null) {
                this.mutex.lock();
            }
        }

        private void unlock() {
            if (this.mutex != null) {
                this.mutex.unlock();
            }
        }

        private void assertIsLocked() {
            if (this.mutex != null) {
                this.mutex.assertIsOwner("must be locked");
            }
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private static VMMutex createMutex(boolean needsLocking) {
            if (needsLocking) {
                return new VMMutex();
            }
            return null;
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private VMCondition createCondition() {
            if (this.mutex != null && SubstrateOptions.UseDedicatedVMOperationThread.getValue().booleanValue()) {
                return new VMCondition(this.mutex);
            }
            return null;
        }
    }

    private static class VMOperationThread
    implements Runnable {
        private volatile IsolateThread isolateThread = (IsolateThread)WordFactory.nullPointer();
        private boolean running = false;

        VMOperationThread() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void waitUntilStarted() {
            while (this.isolateThread.isNull()) {
                Thread.yield();
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        public IsolateThread getIsolateThread() {
            return this.isolateThread;
        }

        public boolean isRunning() {
            return this.running;
        }

        void shutdown() {
            VMOperation.guaranteeInProgress("must only be called from a VM operation");
            this.running = false;
        }
    }
}

