/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.WinBase;
import java.nio.ByteBuffer;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

@Platforms(value={Platform.WINDOWS.class})
public class WindowsSystemPropertiesSupport
extends SystemPropertiesSupport {
    @Override
    protected String userNameValue() {
        return "somebody";
    }

    @Override
    protected String userHomeValue() {
        return "C:\\Users\\somebody";
    }

    @Override
    protected String userDirValue() {
        CCharPointer path = (CCharPointer)StackValue.get((int)260, CCharPointer.class);
        int result = WinBase.GetCurrentDirectoryA(260L, path);
        VMError.guarantee(result > 0, "Could not determine value of user.dir");
        return CTypeConversion.toJavaString((CCharPointer)path);
    }

    @Override
    protected String tmpdirValue() {
        return "C:\\Temp";
    }

    @Override
    protected String osVersionValue() {
        ByteBuffer versionBytes = ByteBuffer.allocate(4);
        versionBytes.putInt(WinBase.GetVersion());
        byte majorVersion = versionBytes.get(3);
        byte minorVersion = versionBytes.get(2);
        return majorVersion + "." + minorVersion;
    }
}

