/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.ExcludeFromReferenceMap;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;
import sun.misc.Unsafe;

public class DiscoverableReference {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    @ExcludeFromReferenceMap(value="Field is manually processed by the garbage collector.")
    private Object rawReferent;
    private static final long RAW_REFERENT_OFFSET = DiscoverableReference.getFieldOffset("rawReferent");
    private static final long NEXT_FIELD_OFFSET = DiscoverableReference.getFieldOffset("next");
    private boolean isDiscovered;
    private DiscoverableReference next;
    private final boolean discoverableReferenceInitialized;

    public DiscoverableReference prependToDiscoveredReference(DiscoverableReference newNext) {
        this.setNextDiscoverableReference(newNext, true);
        return this;
    }

    public boolean isDiscoverableReferenceInitialized() {
        return this.discoverableReferenceInitialized;
    }

    Object getReferentObject() {
        return this.rawReferent;
    }

    public void clear() {
        this.rawReferent = null;
    }

    public Pointer getReferentPointer() {
        return Word.objectToUntrackedPointer((Object)ObjectAccess.readObject((Object)this, (WordBase)WordFactory.signed((long)RAW_REFERENT_OFFSET)));
    }

    public void setReferentPointer(Pointer value) {
        ObjectAccess.writeObject((Object)this, (WordBase)WordFactory.signed((long)RAW_REFERENT_OFFSET), (Object)value.toObject());
    }

    public DiscoverableReference getNextDiscoverableReference() {
        return KnownIntrinsics.convertUnknownValue(ObjectAccess.readObject((Object)this, (WordBase)WordFactory.signed((long)NEXT_FIELD_OFFSET)), DiscoverableReference.class);
    }

    private void setNextDiscoverableReference(DiscoverableReference newNext, boolean newIsDiscovered) {
        ObjectAccess.writeObject((Object)this, (WordBase)WordFactory.signed((long)NEXT_FIELD_OFFSET), (Object)newNext);
        this.isDiscovered = newIsDiscovered;
    }

    public boolean getIsDiscovered() {
        return this.isDiscovered;
    }

    public void clean() {
        this.setNextDiscoverableReference(null, false);
    }

    @Uninterruptible(reason="The initialization of the fields must be atomic with respect to collection.")
    protected DiscoverableReference(Object referent) {
        this.rawReferent = referent;
        this.next = null;
        this.isDiscovered = false;
        this.discoverableReferenceInitialized = true;
    }

    private static long getFieldOffset(String fieldName) {
        try {
            return UNSAFE.objectFieldOffset(DiscoverableReference.class.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static Pointer getReferentPointer(DiscoverableReference that) {
            return that.getReferentPointer();
        }

        public static DiscoverableReference getNextDiscoverableReference(DiscoverableReference that) {
            return that.getNextDiscoverableReference();
        }
    }
}

