/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.Target_java_lang_ref_Cleaner_Cleanable;
import com.oracle.svm.core.jdk.Target_java_lang_ref_ReferenceQueue;
import com.oracle.svm.core.jdk.Target_jdk_internal_ref_Cleaner;
import com.oracle.svm.core.jdk.Target_jdk_internal_ref_CleanerFactory;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public class SunMiscSupport {
    public static void drainCleanerQueue() {
        Target_java_lang_ref_ReferenceQueue cleanerQueue = SubstrateUtil.cast(Target_jdk_internal_ref_Cleaner.dummyQueue, Target_java_lang_ref_ReferenceQueue.class);
        SunMiscSupport.processQueue(cleanerQueue);
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            Target_java_lang_ref_ReferenceQueue cleanableQueue = SubstrateUtil.cast(Target_jdk_internal_ref_CleanerFactory.cleaner().impl.queue, Target_java_lang_ref_ReferenceQueue.class);
            SunMiscSupport.processQueue(cleanableQueue);
        }
    }

    private static void processQueue(Target_java_lang_ref_ReferenceQueue queue) {
        if (!queue.isEmpty()) {
            ThreadingSupportImpl.pauseRecurringCallback("An exception in a recurring callback must not interrupt the cleaner processing as this would result in a memory leak.");
            try {
                while (true) {
                    Object cleaner;
                    Object entry;
                    if ((entry = queue.poll()) == null) {
                        return;
                    }
                    if (entry instanceof Target_jdk_internal_ref_Cleaner) {
                        cleaner = (Target_jdk_internal_ref_Cleaner)entry;
                        ((Target_jdk_internal_ref_Cleaner)cleaner).clean();
                        continue;
                    }
                    if (JavaVersionUtil.JAVA_SPEC > 8 && entry instanceof Target_java_lang_ref_Cleaner_Cleanable) {
                        cleaner = (Target_java_lang_ref_Cleaner_Cleanable)entry;
                        ((Target_java_lang_ref_Cleaner_Cleanable)cleaner).clean();
                        continue;
                    }
                    VMError.shouldNotReachHere("Unexpected type: " + entry.getClass().getName());
                }
            }
            finally {
                ThreadingSupportImpl.resumeRecurringCallback();
            }
        }
    }
}

