/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.linux.LinuxSched;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.PointerBase;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
@TargetClass(value=Runtime.class)
final class Target_java_lang_Runtime {
    Target_java_lang_Runtime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    public int availableProcessors() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            int pid = Unistd.getpid();
            LinuxSched.cpu_set_t cpuSet = (LinuxSched.cpu_set_t)StackValue.get(LinuxSched.cpu_set_t.class);
            int size = SizeOf.get(LinuxSched.cpu_set_t.class);
            int res = LinuxSched.sched_getaffinity(pid, size, cpuSet);
            if (res == 0) {
                return LinuxSched.CPU_COUNT_S(size, cpuSet);
            }
            size = Integer.highestOneBit(size) << 1;
            while (Integer.numberOfTrailingZeros(size) < 16) {
                assert (Integer.bitCount(size) == 1);
                cpuSet = (LinuxSched.cpu_set_t)UnmanagedMemory.calloc((int)size);
                if (cpuSet.isNull()) {
                    throw new InternalError("Cannot determine CPU count");
                }
                try {
                    res = LinuxSched.sched_getaffinity(pid, size, cpuSet);
                    if (res == 0) {
                        int n = LinuxSched.CPU_COUNT_S(size, cpuSet);
                        return n;
                    }
                }
                finally {
                    UnmanagedMemory.free((PointerBase)cpuSet);
                }
                size <<= 1;
            }
            res = (int)Unistd.sysconf(Unistd._SC_NPROCESSORS_ONLN());
            if (res == -1) {
                throw new InternalError("Cannot determine CPU count");
            }
            return res;
        }
        return 1;
    }
}

