/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.libc;

import com.oracle.svm.core.c.libc.Libc;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.util.GuardedAnnotationAccess;

public interface LibCBase {
    public static final String PATH_DEFAULT = "<default>";

    public static boolean containsLibCAnnotation(AnnotatedElement element) {
        return GuardedAnnotationAccess.getAnnotation((AnnotatedElement)element, Libc.class) != null;
    }

    public static boolean isProvidedInCurrentLibc(AnnotatedElement element) {
        LibCBase currentLibC = (LibCBase)ImageSingletons.lookup(LibCBase.class);
        Libc targetLibC = (Libc)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)element, Libc.class);
        return targetLibC != null && Arrays.asList(targetLibC.value()).contains(currentLibC.getClass());
    }

    public static boolean isTypeProvidedInCurrentLibc(Class<?> clazz) {
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getEnclosingClass()) {
            if (!LibCBase.containsLibCAnnotation(currentClazz)) continue;
            return LibCBase.isProvidedInCurrentLibc(currentClazz);
        }
        Package clazzPackage = clazz.getPackage();
        if (clazzPackage != null) {
            return !LibCBase.containsLibCAnnotation(clazz) || LibCBase.isProvidedInCurrentLibc(clazzPackage);
        }
        return true;
    }

    public static boolean isMethodProvidedInCurrentLibc(Method method) {
        if (LibCBase.containsLibCAnnotation(method) && !LibCBase.isProvidedInCurrentLibc(method)) {
            return false;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        return LibCBase.isTypeProvidedInCurrentLibc(declaringClass);
    }

    public String getJDKStaticLibsPath();

    public void prepare(Path var1);

    public List<String> getAdditionalQueryCodeCompilerOptions();

    public List<String> getCCompilerOptions();

    public static LibCBase singleton() {
        return (LibCBase)ImageSingletons.lookup(LibCBase.class);
    }

    default public boolean isLibC(Class<? extends LibCBase> libC) {
        return this.getClass().equals(libC);
    }

    public boolean hasIsolatedNamespaces();
}

